/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.grounditems;

import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import java.util.List;
import javax.annotation.Nonnull;
import net.runelite.client.util.WildcardMatcher;

class WildcardMatchLoader
extends CacheLoader<String, Boolean> {
    private final List<String> nameFilters;

    WildcardMatchLoader(List<String> nameFilters) {
        this.nameFilters = nameFilters;
    }

    @Override
    public Boolean load(@Nonnull String key) {
        if (Strings.isNullOrEmpty(key)) {
            return false;
        }
        String filteredName = key.trim();
        for (String filter : this.nameFilters) {
            if (!WildcardMatcher.matches(filter, filteredName)) continue;
            return true;
        }
        return false;
    }
}

