/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.grounditems;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemLayer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Node;
import net.runelite.api.Player;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemQuantityChanged;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.grounditems.GroundItem;
import net.runelite.client.plugins.grounditems.GroundItemInputListener;
import net.runelite.client.plugins.grounditems.GroundItemsConfig;
import net.runelite.client.plugins.grounditems.GroundItemsOverlay;
import net.runelite.client.plugins.grounditems.MenuEntryWithCount;
import net.runelite.client.plugins.grounditems.WildcardMatchLoader;
import net.runelite.client.plugins.grounditems.config.ItemHighlightMode;
import net.runelite.client.plugins.grounditems.config.MenuHighlightMode;
import net.runelite.client.plugins.grounditems.config.ValueCalculationMode;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.StackFormatter;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Ground Items", description="Highlight ground items and/or show price information", tags={"grand", "exchange", "high", "alchemy", "prices", "highlight", "overlay"})
public class GroundItemsPlugin
extends Plugin {
    private static final float HIGH_ALCHEMY_CONSTANT = 0.6f;
    private static final int COINS = 995;
    private static final int FIRST_OPTION = MenuAction.GROUND_ITEM_FIRST_OPTION.getId();
    private static final int SECOND_OPTION = MenuAction.GROUND_ITEM_SECOND_OPTION.getId();
    private static final int THIRD_OPTION = MenuAction.GROUND_ITEM_THIRD_OPTION.getId();
    private static final int FOURTH_OPTION = MenuAction.GROUND_ITEM_FOURTH_OPTION.getId();
    private static final int FIFTH_OPTION = MenuAction.GROUND_ITEM_FIFTH_OPTION.getId();
    private static final int EXAMINE_ITEM = MenuAction.EXAMINE_ITEM_GROUND.getId();
    private Map.Entry<Rectangle, GroundItem> textBoxBounds;
    private Map.Entry<Rectangle, GroundItem> hiddenBoxBounds;
    private Map.Entry<Rectangle, GroundItem> highlightBoxBounds;
    private boolean hotKeyPressed;
    private boolean hideAll;
    private List<String> hiddenItemList = new CopyOnWriteArrayList<String>();
    private List<String> highlightedItemsList = new CopyOnWriteArrayList<String>();
    @Inject
    private GroundItemInputListener inputListener;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private GroundItemsConfig config;
    @Inject
    private GroundItemsOverlay overlay;
    @Inject
    private Notifier notifier;
    private final Map<GroundItem.GroundItemKey, GroundItem> collectedGroundItems = new LinkedHashMap<GroundItem.GroundItemKey, GroundItem>();
    private final Map<Integer, Color> priceChecks = new LinkedHashMap<Integer, Color>();
    private LoadingCache<String, Boolean> highlightedItems;
    private LoadingCache<String, Boolean> hiddenItems;

    @Provides
    GroundItemsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(GroundItemsConfig.class);
    }

    @Override
    protected void startUp() {
        this.overlayManager.add(this.overlay);
        this.reset();
        this.mouseManager.registerMouseListener(this.inputListener);
        this.keyManager.registerKeyListener(this.inputListener);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.mouseManager.unregisterMouseListener(this.inputListener);
        this.keyManager.unregisterKeyListener(this.inputListener);
        this.highlightedItems.invalidateAll();
        this.highlightedItems = null;
        this.hiddenItems.invalidateAll();
        this.hiddenItems = null;
        this.hiddenItemList = null;
        this.highlightedItemsList = null;
        this.collectedGroundItems.clear();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("grounditems")) {
            this.reset();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.collectedGroundItems.clear();
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        boolean shouldNotify;
        Item item = itemSpawned.getItem();
        Tile tile = itemSpawned.getTile();
        GroundItem groundItem = this.buildGroundItem(tile, item);
        GroundItem.GroundItemKey groundItemKey = new GroundItem.GroundItemKey(item.getId(), tile.getWorldLocation());
        GroundItem existing = this.collectedGroundItems.putIfAbsent(groundItemKey, groundItem);
        if (existing != null) {
            existing.setQuantity(existing.getQuantity() + groundItem.getQuantity());
        }
        boolean bl = shouldNotify = !this.config.onlyShowLoot() && this.config.highlightedColor().equals(this.getHighlighted(groundItem.getName(), groundItem.getGePrice(), groundItem.getHaPrice()));
        if (this.config.notifyHighlightedDrops() && shouldNotify) {
            this.notifyHighlightedItem(groundItem);
        }
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned itemDespawned) {
        Item item = itemDespawned.getItem();
        Tile tile = itemDespawned.getTile();
        GroundItem.GroundItemKey groundItemKey = new GroundItem.GroundItemKey(item.getId(), tile.getWorldLocation());
        GroundItem groundItem = this.collectedGroundItems.get(groundItemKey);
        if (groundItem == null) {
            return;
        }
        if (groundItem.getQuantity() <= item.getQuantity()) {
            this.collectedGroundItems.remove(groundItemKey);
        } else {
            groundItem.setQuantity(groundItem.getQuantity() - item.getQuantity());
        }
    }

    @Subscribe
    public void onItemQuantityChanged(ItemQuantityChanged itemQuantityChanged) {
        Item item = itemQuantityChanged.getItem();
        Tile tile = itemQuantityChanged.getTile();
        int oldQuantity = itemQuantityChanged.getOldQuantity();
        int newQuantity = itemQuantityChanged.getNewQuantity();
        int diff = newQuantity - oldQuantity;
        GroundItem.GroundItemKey groundItemKey = new GroundItem.GroundItemKey(item.getId(), tile.getWorldLocation());
        GroundItem groundItem = this.collectedGroundItems.get(groundItemKey);
        if (groundItem != null) {
            groundItem.setQuantity(groundItem.getQuantity() + diff);
        }
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        Collection<ItemStack> items = npcLootReceived.getItems();
        this.lootReceived(items);
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) {
        Collection<ItemStack> items = playerLootReceived.getItems();
        this.lootReceived(items);
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        if (!this.config.collapseEntries()) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        ArrayList<MenuEntryWithCount> newEntries = new ArrayList<MenuEntryWithCount>(menuEntries.length);
        block0: for (int i = menuEntries.length - 1; i >= 0; --i) {
            MenuEntry menuEntry = menuEntries[i];
            int menuType = menuEntry.getType();
            if (menuType == FIRST_OPTION || menuType == SECOND_OPTION || menuType == THIRD_OPTION || menuType == FOURTH_OPTION || menuType == FIFTH_OPTION || menuType == EXAMINE_ITEM) {
                for (MenuEntryWithCount entryWCount : newEntries) {
                    if (!entryWCount.getEntry().equals(menuEntry)) continue;
                    entryWCount.increment();
                    continue block0;
                }
            }
            newEntries.add(new MenuEntryWithCount(menuEntry));
        }
        Collections.reverse(newEntries);
        this.client.setMenuEntries((MenuEntry[])newEntries.stream().map(e -> {
            MenuEntry entry = e.getEntry();
            int count = e.getCount();
            if (count > 1) {
                entry.setTarget(entry.getTarget() + " x " + count);
            }
            return entry;
        }).toArray(MenuEntry[]::new));
    }

    private void lootReceived(Collection<ItemStack> items) {
        for (ItemStack itemStack : items) {
            boolean shouldNotify;
            WorldPoint location = WorldPoint.fromLocal(this.client, itemStack.getLocation());
            GroundItem.GroundItemKey groundItemKey = new GroundItem.GroundItemKey(itemStack.getId(), location);
            GroundItem groundItem = this.collectedGroundItems.get(groundItemKey);
            if (groundItem == null) continue;
            groundItem.setMine(true);
            boolean bl = shouldNotify = this.config.onlyShowLoot() && this.config.highlightedColor().equals(this.getHighlighted(groundItem.getName(), groundItem.getGePrice(), groundItem.getHaPrice()));
            if (!this.config.notifyHighlightedDrops() || !shouldNotify) continue;
            this.notifyHighlightedItem(groundItem);
        }
    }

    private GroundItem buildGroundItem(Tile tile, Item item) {
        int itemId = item.getId();
        ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
        int realItemId = itemComposition.getNote() != -1 ? itemComposition.getLinkedNoteId() : itemId;
        int alchPrice = Math.round((float)itemComposition.getPrice() * 0.6f);
        GroundItem groundItem = GroundItem.builder().id(itemId).location(tile.getWorldLocation()).itemId(realItemId).quantity(item.getQuantity()).name(itemComposition.getName()).haPrice(alchPrice).height(tile.getItemLayer().getHeight()).tradeable(itemComposition.isTradeable()).build();
        if (realItemId == 995) {
            groundItem.setHaPrice(1);
            groundItem.setGePrice(1);
        } else {
            groundItem.setGePrice(this.itemManager.getItemPrice(realItemId));
        }
        return groundItem;
    }

    private void reset() {
        this.hiddenItemList = Text.fromCSV(this.config.getHiddenItems());
        this.highlightedItemsList = Text.fromCSV(this.config.getHighlightItems());
        this.highlightedItems = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(10L, TimeUnit.MINUTES).build(new WildcardMatchLoader(this.highlightedItemsList));
        this.hiddenItems = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(10L, TimeUnit.MINUTES).build(new WildcardMatchLoader(this.hiddenItemList));
        this.priceChecks.clear();
        if (this.config.insaneValuePrice() > 0) {
            this.priceChecks.put(this.config.insaneValuePrice(), this.config.insaneValueColor());
        }
        if (this.config.highValuePrice() > 0) {
            this.priceChecks.put(this.config.highValuePrice(), this.config.highValueColor());
        }
        if (this.config.mediumValuePrice() > 0) {
            this.priceChecks.put(this.config.mediumValuePrice(), this.config.mediumValueColor());
        }
        if (this.config.lowValuePrice() > 0) {
            this.priceChecks.put(this.config.lowValuePrice(), this.config.lowValueColor());
        }
        if (this.config.getHighlightOverValue() > 0) {
            this.priceChecks.put(this.config.getHighlightOverValue(), this.config.highlightedColor());
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (this.config.itemHighlightMode() != ItemHighlightMode.OVERLAY && event.getOption().equals("Take") && event.getType() == THIRD_OPTION) {
            boolean canBeRecolored;
            int itemId = event.getIdentifier();
            Scene scene = this.client.getScene();
            Tile tile = scene.getTiles()[this.client.getPlane()][event.getActionParam0()][event.getActionParam1()];
            ItemLayer itemLayer = tile.getItemLayer();
            if (itemLayer == null) {
                return;
            }
            MenuEntry[] menuEntries = this.client.getMenuEntries();
            MenuEntry lastEntry = menuEntries[menuEntries.length - 1];
            int quantity = 1;
            Node current = itemLayer.getBottom();
            while (current instanceof Item) {
                Item item = (Item)current;
                if (item.getId() == itemId) {
                    quantity = item.getQuantity();
                }
                current = current.getNext();
            }
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
            int realItemId = itemComposition.getNote() != -1 ? itemComposition.getLinkedNoteId() : itemComposition.getId();
            int itemPrice = this.itemManager.getItemPrice(realItemId);
            int price = itemPrice <= 0 ? itemComposition.getPrice() : itemPrice;
            int haPrice = Math.round((float)itemComposition.getPrice() * 0.6f) * quantity;
            int gePrice = quantity * price;
            Color hidden = this.getHidden(itemComposition.getName(), gePrice, haPrice, itemComposition.isTradeable());
            Color highlighted = this.getHighlighted(itemComposition.getName(), gePrice, haPrice);
            Color color = this.getItemColor(highlighted, hidden);
            boolean bl = canBeRecolored = highlighted != null || hidden != null && this.config.recolorMenuHiddenItems();
            if (color != null && canBeRecolored && !color.equals(this.config.defaultColor())) {
                MenuHighlightMode mode = this.config.menuHighlightMode();
                if (mode == MenuHighlightMode.BOTH || mode == MenuHighlightMode.OPTION) {
                    lastEntry.setOption(ColorUtil.prependColorTag("Take", color));
                }
                if (mode == MenuHighlightMode.BOTH || mode == MenuHighlightMode.NAME) {
                    String target = lastEntry.getTarget().substring(lastEntry.getTarget().indexOf(">") + 1);
                    lastEntry.setTarget(ColorUtil.prependColorTag(target, color));
                }
            }
            if (this.config.showMenuItemQuantities() && itemComposition.isStackable() && quantity > 1) {
                lastEntry.setTarget(lastEntry.getTarget() + " (" + quantity + ")");
            }
            this.client.setMenuEntries(menuEntries);
        }
    }

    void updateList(String item, boolean hiddenList) {
        HashSet<String> hiddenItemSet = new HashSet<String>(this.hiddenItemList);
        HashSet<String> highlightedItemSet = new HashSet<String>(this.highlightedItemsList);
        if (hiddenList) {
            highlightedItemSet.removeIf(item::equalsIgnoreCase);
        } else {
            hiddenItemSet.removeIf(item::equalsIgnoreCase);
        }
        HashSet<String> items = hiddenList ? hiddenItemSet : highlightedItemSet;
        if (!items.removeIf(item::equalsIgnoreCase)) {
            items.add(item);
        }
        this.config.setHiddenItems(Text.toCSV(hiddenItemSet));
        this.config.setHighlightedItem(Text.toCSV(highlightedItemSet));
    }

    Color getHighlighted(String item, int gePrice, int haPrice) {
        if (Boolean.TRUE.equals(this.highlightedItems.getUnchecked(item))) {
            return this.config.highlightedColor();
        }
        if (Boolean.TRUE.equals(this.hiddenItems.getUnchecked(item))) {
            return null;
        }
        ValueCalculationMode mode = this.config.valueCalculationMode();
        block4: for (Map.Entry<Integer, Color> entry : this.priceChecks.entrySet()) {
            switch (mode) {
                case GE: {
                    if (gePrice <= entry.getKey()) continue block4;
                    return entry.getValue();
                }
                case HA: {
                    if (haPrice <= entry.getKey()) continue block4;
                    return entry.getValue();
                }
            }
            if (gePrice <= entry.getKey() && haPrice <= entry.getKey()) continue;
            return entry.getValue();
        }
        return null;
    }

    Color getHidden(String item, int gePrice, int haPrice, boolean isTradeable) {
        boolean isExplicitHidden = Boolean.TRUE.equals(this.hiddenItems.getUnchecked(item));
        boolean isExplicitHighlight = Boolean.TRUE.equals(this.highlightedItems.getUnchecked(item));
        boolean canBeHidden = gePrice > 0 || isTradeable || !this.config.dontHideUntradeables();
        boolean underGe = gePrice < this.config.getHideUnderValue();
        boolean underHa = haPrice < this.config.getHideUnderValue();
        return isExplicitHidden || !isExplicitHighlight && canBeHidden && underGe && underHa ? this.config.hiddenColor() : null;
    }

    Color getItemColor(Color highlighted, Color hidden) {
        if (highlighted != null) {
            return highlighted;
        }
        if (hidden != null) {
            return hidden;
        }
        return this.config.defaultColor();
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (!focusChanged.isFocused()) {
            this.setHotKeyPressed(false);
        }
    }

    private void notifyHighlightedItem(GroundItem item) {
        Player local = this.client.getLocalPlayer();
        StringBuilder notificationStringBuilder = new StringBuilder().append("[").append(local.getName()).append("] received a highlighted drop: ").append(item.getName());
        if (item.getQuantity() > 1) {
            notificationStringBuilder.append(" x ").append(item.getQuantity());
            if (item.getQuantity() > 65535) {
                notificationStringBuilder.append(" (Lots!)");
            } else {
                notificationStringBuilder.append(" (").append(StackFormatter.quantityToStackSize(item.getQuantity())).append(")");
            }
        }
        notificationStringBuilder.append("!");
        this.notifier.notify(notificationStringBuilder.toString());
    }

    Map.Entry<Rectangle, GroundItem> getTextBoxBounds() {
        return this.textBoxBounds;
    }

    void setTextBoxBounds(Map.Entry<Rectangle, GroundItem> textBoxBounds) {
        this.textBoxBounds = textBoxBounds;
    }

    Map.Entry<Rectangle, GroundItem> getHiddenBoxBounds() {
        return this.hiddenBoxBounds;
    }

    void setHiddenBoxBounds(Map.Entry<Rectangle, GroundItem> hiddenBoxBounds) {
        this.hiddenBoxBounds = hiddenBoxBounds;
    }

    Map.Entry<Rectangle, GroundItem> getHighlightBoxBounds() {
        return this.highlightBoxBounds;
    }

    void setHighlightBoxBounds(Map.Entry<Rectangle, GroundItem> highlightBoxBounds) {
        this.highlightBoxBounds = highlightBoxBounds;
    }

    boolean isHotKeyPressed() {
        return this.hotKeyPressed;
    }

    void setHotKeyPressed(boolean hotKeyPressed) {
        this.hotKeyPressed = hotKeyPressed;
    }

    boolean isHideAll() {
        return this.hideAll;
    }

    void setHideAll(boolean hideAll) {
        this.hideAll = hideAll;
    }

    public Map<GroundItem.GroundItemKey, GroundItem> getCollectedGroundItems() {
        return this.collectedGroundItems;
    }
}

