/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.grandexchange;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.GrandExchangeOfferState;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GrandExchangeOfferChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.account.AccountSession;
import net.runelite.client.account.SessionManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.SessionClose;
import net.runelite.client.events.SessionOpen;
import net.runelite.client.game.AsyncBufferedImage;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.grandexchange.GrandExchangeConfig;
import net.runelite.client.plugins.grandexchange.GrandExchangeInputListener;
import net.runelite.client.plugins.grandexchange.GrandExchangePanel;
import net.runelite.client.plugins.grandexchange.SavedOffer;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.StackFormatter;
import net.runelite.client.util.Text;
import net.runelite.http.api.ge.GrandExchangeClient;
import net.runelite.http.api.ge.GrandExchangeTrade;
import net.runelite.http.api.osbuddy.OSBGrandExchangeClient;
import net.runelite.http.api.osbuddy.OSBGrandExchangeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Grand Exchange", description="Provide additional and/or easier access to Grand Exchange information", tags={"external", "integration", "notifications", "panel", "prices", "trade"})
public class GrandExchangePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GrandExchangePlugin.class);
    private static final int OFFER_CONTAINER_ITEM = 21;
    private static final int OFFER_DEFAULT_ITEM_ID = 6512;
    private static final OSBGrandExchangeClient CLIENT = new OSBGrandExchangeClient();
    private static final String OSB_GE_TEXT = "<br>OSBuddy Actively traded price: ";
    private static final String BUY_LIMIT_GE_TEXT = "<br>Buy limit: ";
    private static final Gson GSON = new Gson();
    private static final TypeToken<Map<Integer, Integer>> BUY_LIMIT_TOKEN = new TypeToken<Map<Integer, Integer>>(){};
    static final String SEARCH_GRAND_EXCHANGE = "Search Grand Exchange";
    private NavigationButton button;
    private GrandExchangePanel panel;
    private boolean hotKeyPressed;
    @Inject
    private GrandExchangeInputListener inputListener;
    @Inject
    private ItemManager itemManager;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private GrandExchangeConfig config;
    @Inject
    private Notifier notifier;
    @Inject
    private ScheduledExecutorService executorService;
    @Inject
    private SessionManager sessionManager;
    @Inject
    private ConfigManager configManager;
    private Widget grandExchangeText;
    private Widget grandExchangeItem;
    private Map<Integer, Integer> itemGELimits;
    private GrandExchangeClient grandExchangeClient;

    private SavedOffer getOffer(int slot) {
        String offer = this.configManager.getConfiguration("geoffer." + this.client.getUsername().toLowerCase(), Integer.toString(slot));
        if (offer == null) {
            return null;
        }
        return GSON.fromJson(offer, SavedOffer.class);
    }

    private void setOffer(int slot, SavedOffer offer) {
        this.configManager.setConfiguration("geoffer." + this.client.getUsername().toLowerCase(), Integer.toString(slot), GSON.toJson(offer));
    }

    private void deleteOffer(int slot) {
        this.configManager.unsetConfiguration("geoffer." + this.client.getUsername().toLowerCase(), Integer.toString(slot));
    }

    @Provides
    GrandExchangeConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(GrandExchangeConfig.class);
    }

    @Override
    protected void startUp() {
        AccountSession accountSession;
        this.itemGELimits = GrandExchangePlugin.loadGELimits();
        this.panel = this.injector.getInstance(GrandExchangePanel.class);
        this.panel.setGELimits(this.itemGELimits);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), "ge_icon.png");
        this.button = NavigationButton.builder().tooltip("Grand Exchange").icon(icon).priority(3).panel(this.panel).build();
        this.clientToolbar.addNavigation(this.button);
        if (this.config.quickLookup()) {
            this.mouseManager.registerMouseListener(this.inputListener);
            this.keyManager.registerKeyListener(this.inputListener);
        }
        if ((accountSession = this.sessionManager.getAccountSession()) != null) {
            this.grandExchangeClient = new GrandExchangeClient(accountSession.getUuid());
        }
    }

    @Override
    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.button);
        this.mouseManager.unregisterMouseListener(this.inputListener);
        this.keyManager.unregisterKeyListener(this.inputListener);
        this.grandExchangeText = null;
        this.grandExchangeItem = null;
        this.itemGELimits = null;
        this.grandExchangeClient = null;
    }

    @Subscribe
    public void onSessionOpen(SessionOpen sessionOpen) {
        AccountSession accountSession = this.sessionManager.getAccountSession();
        this.grandExchangeClient = accountSession.getUuid() != null ? new GrandExchangeClient(accountSession.getUuid()) : null;
    }

    @Subscribe
    public void onSessionClose(SessionClose sessionClose) {
        this.grandExchangeClient = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("grandexchange") && event.getKey().equals("quickLookup")) {
            if (this.config.quickLookup()) {
                this.mouseManager.registerMouseListener(this.inputListener);
                this.keyManager.registerKeyListener(this.inputListener);
            } else {
                this.mouseManager.unregisterMouseListener(this.inputListener);
                this.keyManager.unregisterKeyListener(this.inputListener);
            }
        }
    }

    @Subscribe
    public void onGrandExchangeOfferChanged(GrandExchangeOfferChanged offerEvent) {
        int slot = offerEvent.getSlot();
        GrandExchangeOffer offer = offerEvent.getOffer();
        ItemComposition offerItem = this.itemManager.getItemComposition(offer.getItemId());
        boolean shouldStack = offerItem.isStackable() || offer.getTotalQuantity() > 1;
        AsyncBufferedImage itemImage = this.itemManager.getImage(offer.getItemId(), offer.getTotalQuantity(), shouldStack);
        SwingUtilities.invokeLater(() -> this.panel.getOffersPanel().updateOffer(offerItem, itemImage, offer, slot));
        this.submitTrades(slot, offer);
        this.updateConfig(slot, offer);
    }

    private void submitTrades(int slot, GrandExchangeOffer offer) {
        if (this.grandExchangeClient == null) {
            return;
        }
        if (offer.getState() != GrandExchangeOfferState.BOUGHT && offer.getState() != GrandExchangeOfferState.SOLD) {
            return;
        }
        SavedOffer savedOffer = this.getOffer(slot);
        if (!this.shouldUpdate(savedOffer, offer)) {
            return;
        }
        int priceEach = offer.getSpent() / offer.getTotalQuantity();
        GrandExchangeTrade grandExchangeTrade = new GrandExchangeTrade();
        grandExchangeTrade.setBuy(offer.getState() == GrandExchangeOfferState.BOUGHT);
        grandExchangeTrade.setItemId(offer.getItemId());
        grandExchangeTrade.setQuantity(offer.getTotalQuantity());
        grandExchangeTrade.setPrice(priceEach);
        log.debug("Submitting trade: {}", (Object)grandExchangeTrade);
        this.grandExchangeClient.submit(grandExchangeTrade);
    }

    private void updateConfig(int slot, GrandExchangeOffer offer) {
        if (offer.getState() == GrandExchangeOfferState.EMPTY) {
            this.deleteOffer(slot);
        } else {
            SavedOffer savedOffer = new SavedOffer();
            savedOffer.setItemId(offer.getItemId());
            savedOffer.setQuantitySold(offer.getQuantitySold());
            savedOffer.setTotalQuantity(offer.getTotalQuantity());
            savedOffer.setPrice(offer.getPrice());
            savedOffer.setSpent(offer.getSpent());
            savedOffer.setState(offer.getState());
            this.setOffer(slot, savedOffer);
        }
    }

    private boolean shouldUpdate(SavedOffer savedOffer, GrandExchangeOffer grandExchangeOffer) {
        if (savedOffer == null) {
            return false;
        }
        return savedOffer.getState() != grandExchangeOffer.getState();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (!this.config.enableNotifications() || event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String message = Text.removeTags(event.getMessage());
        if (message.startsWith("Grand Exchange:")) {
            this.notifier.notify(message);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.panel.getOffersPanel().resetOffers();
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (this.client.getGameState() != GameState.LOGGED_IN || !this.hotKeyPressed) {
            return;
        }
        MenuEntry[] entries = this.client.getMenuEntries();
        MenuEntry menuEntry = entries[entries.length - 1];
        int widgetId = menuEntry.getParam1();
        int groupId = WidgetInfo.TO_GROUP(widgetId);
        switch (groupId) {
            case 12: {
                if (WidgetInfo.TO_CHILD(widgetId) != WidgetInfo.BANK_ITEM_CONTAINER.getChildId()) break;
            }
            case 15: 
            case 149: 
            case 301: 
            case 467: {
                menuEntry.setOption(SEARCH_GRAND_EXCHANGE);
                menuEntry.setType(MenuAction.RUNELITE.getId());
                this.client.setMenuEntries(entries);
            }
        }
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (!focusChanged.isFocused()) {
            this.setHotKeyPressed(false);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        switch (event.getGroupId()) {
            case 465: {
                Widget grandExchangeOffer = this.client.getWidget(WidgetInfo.GRAND_EXCHANGE_OFFER_CONTAINER);
                this.grandExchangeText = this.client.getWidget(WidgetInfo.GRAND_EXCHANGE_OFFER_TEXT);
                this.grandExchangeItem = grandExchangeOffer.getDynamicChildren()[21];
                break;
            }
            case 149: {
                this.grandExchangeText = null;
                this.grandExchangeItem = null;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Integer itemLimit;
        if (this.grandExchangeText == null || this.grandExchangeItem == null || this.grandExchangeItem.isHidden()) {
            return;
        }
        Widget geText = this.grandExchangeText;
        String geTextString = geText.getText();
        int itemId = this.grandExchangeItem.getItemId();
        if (itemId == 6512 || itemId == -1) {
            return;
        }
        if (this.config.enableGELimits() && this.itemGELimits != null && !geTextString.contains(BUY_LIMIT_GE_TEXT) && (itemLimit = this.itemGELimits.get(itemId)) != null) {
            String text = geText.getText() + BUY_LIMIT_GE_TEXT + StackFormatter.formatNumber(itemLimit.intValue());
            geText.setText(text);
        }
        if (!this.config.enableOsbPrices() || geTextString.contains(OSB_GE_TEXT)) {
            return;
        }
        log.debug("Looking up OSB item price {}", (Object)itemId);
        this.executorService.submit(() -> {
            if (geText.getText().contains(OSB_GE_TEXT)) {
                return;
            }
            try {
                OSBGrandExchangeResult result = CLIENT.lookupItem(itemId);
                String text = geText.getText() + OSB_GE_TEXT + StackFormatter.formatNumber(result.getOverall_average());
                geText.setText(text);
            }
            catch (IOException e) {
                log.debug("Error getting price of item {}", (Object)itemId, (Object)e);
            }
        });
    }

    private static Map<Integer, Integer> loadGELimits() {
        InputStream geLimitData = GrandExchangePlugin.class.getResourceAsStream("ge_limits.json");
        Map itemGELimits = (Map)GSON.fromJson((Reader)new InputStreamReader(geLimitData), BUY_LIMIT_TOKEN.getType());
        log.debug("Loaded {} limits", (Object)itemGELimits.size());
        return itemGELimits;
    }

    NavigationButton getButton() {
        return this.button;
    }

    GrandExchangePanel getPanel() {
        return this.panel;
    }

    boolean isHotKeyPressed() {
        return this.hotKeyPressed;
    }

    void setHotKeyPressed(boolean hotKeyPressed) {
        this.hotKeyPressed = hotKeyPressed;
    }
}

