/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.grandexchange;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.grandexchange.GrandExchangeOffersPanel;
import net.runelite.client.plugins.grandexchange.GrandExchangeSearchPanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;

class GrandExchangePanel
extends PluginPanel {
    private final JPanel display = new JPanel();
    private final MaterialTabGroup tabGroup = new MaterialTabGroup(this.display);
    private final MaterialTab searchTab;
    private GrandExchangeSearchPanel searchPanel;
    private GrandExchangeOffersPanel offersPanel;

    @Inject
    private GrandExchangePanel(ClientThread clientThread, ItemManager itemManager, ScheduledExecutorService executor) {
        super(false);
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.searchPanel = new GrandExchangeSearchPanel(clientThread, itemManager, executor);
        this.offersPanel = new GrandExchangeOffersPanel();
        MaterialTab offersTab = new MaterialTab("Offers", this.tabGroup, (JComponent)this.offersPanel);
        this.searchTab = new MaterialTab("Search", this.tabGroup, (JComponent)this.searchPanel);
        this.tabGroup.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.tabGroup.addTab(offersTab);
        this.tabGroup.addTab(this.searchTab);
        this.tabGroup.select(offersTab);
        this.add((Component)this.tabGroup, "North");
        this.add((Component)this.display, "Center");
    }

    void showSearch() {
        if (this.searchPanel.isShowing()) {
            return;
        }
        this.tabGroup.select(this.searchTab);
        this.revalidate();
    }

    void setGELimits(Map<Integer, Integer> itemGELimits) {
        this.searchPanel.setItemGELimits(itemGELimits);
    }

    public GrandExchangeSearchPanel getSearchPanel() {
        return this.searchPanel;
    }

    public GrandExchangeOffersPanel getOffersPanel() {
        return this.offersPanel;
    }
}

