/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import com.jogamp.opengl.GL4;
import java.nio.ByteBuffer;
import javax.inject.Singleton;
import net.runelite.api.Texture;
import net.runelite.api.TextureProvider;
import net.runelite.client.plugins.gpu.GLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class TextureManager {
    private static final Logger log = LoggerFactory.getLogger(TextureManager.class);
    private static final float PERC_64 = 0.015625f;
    private static final float PERC_128 = 0.0078125f;
    private static final int SMALL_TEXTURE_SIZE = 64;
    private static final int TEXTURE_SIZE = 128;

    TextureManager() {
    }

    int initTextureArray(TextureProvider textureProvider, GL4 gl) {
        if (!this.allTexturesLoaded(textureProvider)) {
            return -1;
        }
        Texture[] textures = textureProvider.getTextures();
        int textureArrayId = GLUtil.glGenTexture(gl);
        gl.glBindTexture(35866, textureArrayId);
        gl.glTexStorage3D(35866, 1, 32856, 128, 128, textures.length);
        gl.glTexParameteri(35866, 10241, 9728);
        gl.glTexParameteri(35866, 10240, 9728);
        gl.glTexParameteri(35866, 10242, 33071);
        double save = textureProvider.getBrightness();
        textureProvider.setBrightness(1.0);
        this.updateTextures(textureProvider, gl, textureArrayId);
        textureProvider.setBrightness(save);
        gl.glActiveTexture(33985);
        gl.glBindTexture(35866, textureArrayId);
        gl.glActiveTexture(33984);
        return textureArrayId;
    }

    void freeTextureArray(GL4 gl, int textureArrayId) {
        GLUtil.glDeleteTexture(gl, textureArrayId);
    }

    private boolean allTexturesLoaded(TextureProvider textureProvider) {
        Texture[] textures = textureProvider.getTextures();
        if (textures == null || textures.length == 0) {
            return false;
        }
        for (int textureId = 0; textureId < textures.length; ++textureId) {
            int[] pixels;
            Texture texture = textures[textureId];
            if (texture == null || (pixels = textureProvider.load(textureId)) != null) continue;
            return false;
        }
        return true;
    }

    private void updateTextures(TextureProvider textureProvider, GL4 gl, int textureArrayId) {
        Texture[] textures = textureProvider.getTextures();
        gl.glBindTexture(35866, textureArrayId);
        int cnt = 0;
        for (int textureId = 0; textureId < textures.length; ++textureId) {
            Texture texture = textures[textureId];
            if (texture == null) continue;
            int[] srcPixels = textureProvider.load(textureId);
            if (srcPixels == null) {
                log.warn("No pixels for texture {}!", (Object)textureId);
                continue;
            }
            ++cnt;
            int srcSize = srcPixels.length == 4096 ? 64 : 128;
            byte[] pixels = TextureManager.convertPixels(srcPixels, srcSize, srcSize, 128, 128);
            ByteBuffer pixelBuffer = ByteBuffer.wrap(pixels);
            gl.glTexSubImage3D(35866, 0, 0, 0, textureId, 128, 128, 1, 6408, 5121, pixelBuffer);
        }
        log.debug("Uploaded textures {}", (Object)cnt);
    }

    private static byte[] convertPixels(int[] srcPixels, int width, int height, int textureWidth, int textureHeight) {
        byte[] pixels = new byte[textureWidth * textureHeight * 4];
        int pixelIdx = 0;
        int srcPixelIdx = 0;
        int offset = (textureWidth - width) * 4;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb;
                if ((rgb = srcPixels[srcPixelIdx++]) != 0) {
                    pixels[pixelIdx++] = (byte)(rgb >> 16);
                    pixels[pixelIdx++] = (byte)(rgb >> 8);
                    pixels[pixelIdx++] = (byte)rgb;
                    pixels[pixelIdx++] = -1;
                    continue;
                }
                pixelIdx += 4;
            }
            pixelIdx += offset;
        }
        return pixels;
    }

    void animate(Texture texture, int diff) {
        int[] pixels = texture.getPixels();
        if (pixels == null) {
            return;
        }
        int animationSpeed = texture.getAnimationSpeed();
        float uvdiff = pixels.length == 4096 ? 0.015625f : 0.0078125f;
        float u = texture.getU();
        float v = texture.getV();
        int offset = animationSpeed * diff;
        float d = (float)offset * uvdiff;
        switch (texture.getAnimationDirection()) {
            case 1: {
                v -= d;
                if (!(v < 0.0f)) break;
                v += 1.0f;
                break;
            }
            case 3: {
                v += d;
                if (!(v > 1.0f)) break;
                v -= 1.0f;
                break;
            }
            case 2: {
                u -= d;
                if (!(u < 0.0f)) break;
                u += 1.0f;
                break;
            }
            case 4: {
                u += d;
                if (!(u > 1.0f)) break;
                u -= 1.0f;
                break;
            }
            default: {
                return;
            }
        }
        texture.setU(u);
        texture.setV(v);
    }
}

