/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.Model;
import net.runelite.api.Point;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.WallObject;
import net.runelite.client.plugins.gpu.GpuFloatBuffer;
import net.runelite.client.plugins.gpu.GpuIntBuffer;

@Singleton
class SceneUploader {
    @Inject
    private Client client;
    int sceneId = (int)(System.currentTimeMillis() / 1000L);
    private int offset;
    private int uvoffset;

    SceneUploader() {
    }

    void upload(Scene scene, GpuIntBuffer vertexbuffer, GpuFloatBuffer uvBuffer) {
        Tile tile;
        int y;
        int x;
        int z;
        ++this.sceneId;
        this.offset = 0;
        this.uvoffset = 0;
        vertexbuffer.clear();
        uvBuffer.clear();
        for (z = 0; z < 4; ++z) {
            for (x = 0; x < 104; ++x) {
                for (y = 0; y < 104; ++y) {
                    tile = scene.getTiles()[z][x][y];
                    if (tile == null) continue;
                    this.reset(tile);
                }
            }
        }
        for (z = 0; z < 4; ++z) {
            for (x = 0; x < 104; ++x) {
                for (y = 0; y < 104; ++y) {
                    tile = scene.getTiles()[z][x][y];
                    if (tile == null) continue;
                    this.upload(tile, vertexbuffer, uvBuffer);
                }
            }
        }
    }

    private void reset(Tile tile) {
        GameObject[] gameObjects;
        DecorativeObject decorativeObject;
        GroundObject groundObject;
        WallObject wallObject;
        SceneTileModel sceneTileModel;
        SceneTilePaint sceneTilePaint;
        Tile bridge = tile.getBridge();
        if (bridge != null) {
            this.reset(bridge);
        }
        if ((sceneTilePaint = tile.getSceneTilePaint()) != null) {
            sceneTilePaint.setBufferOffset(-1);
        }
        if ((sceneTileModel = tile.getSceneTileModel()) != null) {
            sceneTileModel.setBufferOffset(-1);
        }
        if ((wallObject = tile.getWallObject()) != null) {
            if (wallObject.getRenderable1() instanceof Model) {
                ((Model)wallObject.getRenderable1()).setBufferOffset(-1);
            }
            if (wallObject.getRenderable2() instanceof Model) {
                ((Model)wallObject.getRenderable2()).setBufferOffset(-1);
            }
        }
        if ((groundObject = tile.getGroundObject()) != null && groundObject.getRenderable() instanceof Model) {
            ((Model)groundObject.getRenderable()).setBufferOffset(-1);
        }
        if ((decorativeObject = tile.getDecorativeObject()) != null && decorativeObject.getRenderable() instanceof Model) {
            ((Model)decorativeObject.getRenderable()).setBufferOffset(-1);
        }
        for (GameObject gameObject : gameObjects = tile.getGameObjects()) {
            if (gameObject == null || !(gameObject.getRenderable() instanceof Model)) continue;
            ((Model)gameObject.getRenderable()).setBufferOffset(-1);
        }
    }

    private void upload(Tile tile, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer) {
        GameObject[] gameObjects;
        DecorativeObject decorativeObject;
        Renderable renderable;
        GroundObject groundObject;
        WallObject wallObject;
        SceneTileModel sceneTileModel;
        SceneTilePaint sceneTilePaint;
        Tile bridge = tile.getBridge();
        if (bridge != null) {
            this.upload(bridge, vertexBuffer, uvBuffer);
        }
        if ((sceneTilePaint = tile.getSceneTilePaint()) != null) {
            sceneTilePaint.setBufferOffset(this.offset);
            if (sceneTilePaint.getTexture() != -1) {
                sceneTilePaint.setUvBufferOffset(this.uvoffset);
            } else {
                sceneTilePaint.setUvBufferOffset(-1);
            }
            Point tilePoint = tile.getSceneLocation();
            int len = this.upload(sceneTilePaint, tile.getRenderLevel(), tilePoint.getX(), tilePoint.getY(), vertexBuffer, uvBuffer);
            sceneTilePaint.setBufferLen(len);
            this.offset += len;
            if (sceneTilePaint.getTexture() != -1) {
                this.uvoffset += len;
            }
        }
        if ((sceneTileModel = tile.getSceneTileModel()) != null) {
            sceneTileModel.setBufferOffset(this.offset);
            if (sceneTileModel.getTriangleTextureId() != null) {
                sceneTileModel.setUvBufferOffset(this.uvoffset);
            } else {
                sceneTileModel.setUvBufferOffset(-1);
            }
            Point tilePoint = tile.getSceneLocation();
            int len = this.upload(sceneTileModel, tilePoint.getX(), tilePoint.getY(), vertexBuffer, uvBuffer);
            sceneTileModel.setBufferLen(len);
            this.offset += len;
            if (sceneTileModel.getTriangleTextureId() != null) {
                this.uvoffset += len;
            }
        }
        if ((wallObject = tile.getWallObject()) != null) {
            Renderable renderable2;
            Renderable renderable1 = wallObject.getRenderable1();
            if (renderable1 instanceof Model) {
                this.uploadModel((Model)renderable1, vertexBuffer, uvBuffer);
            }
            if ((renderable2 = wallObject.getRenderable2()) instanceof Model) {
                this.uploadModel((Model)renderable2, vertexBuffer, uvBuffer);
            }
        }
        if ((groundObject = tile.getGroundObject()) != null && (renderable = groundObject.getRenderable()) instanceof Model) {
            this.uploadModel((Model)renderable, vertexBuffer, uvBuffer);
        }
        if ((decorativeObject = tile.getDecorativeObject()) != null) {
            Renderable renderable2;
            Renderable renderable3 = decorativeObject.getRenderable();
            if (renderable3 instanceof Model) {
                this.uploadModel((Model)renderable3, vertexBuffer, uvBuffer);
            }
            if ((renderable2 = decorativeObject.getRenderable2()) instanceof Model) {
                this.uploadModel((Model)renderable2, vertexBuffer, uvBuffer);
            }
        }
        for (GameObject gameObject : gameObjects = tile.getGameObjects()) {
            Renderable renderable4;
            if (gameObject == null || !((renderable4 = gameObject.getRenderable()) instanceof Model)) continue;
            this.uploadModel((Model)gameObject.getRenderable(), vertexBuffer, uvBuffer);
        }
    }

    private int upload(SceneTilePaint tile, int tileZ, int tileX, int tileY, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer) {
        int[][][] tileHeights = this.client.getTileHeights();
        boolean localX = false;
        boolean localY = false;
        int swHeight = tileHeights[tileZ][tileX][tileY];
        int seHeight = tileHeights[tileZ][tileX + 1][tileY];
        int neHeight = tileHeights[tileZ][tileX + 1][tileY + 1];
        int nwHeight = tileHeights[tileZ][tileX][tileY + 1];
        int neColor = tile.getNeColor();
        int nwColor = tile.getNwColor();
        int seColor = tile.getSeColor();
        int swColor = tile.getSwColor();
        if (neColor == 12345678) {
            return 0;
        }
        vertexBuffer.ensureCapacity(24);
        uvBuffer.ensureCapacity(24);
        int vertexDx = 0;
        int vertexDy = 0;
        int vertexDz = swHeight;
        int c1 = swColor;
        int vertexCx = 128;
        int vertexCy = 0;
        int vertexCz = seHeight;
        int c2 = seColor;
        int vertexAx = 128;
        int vertexAy = 128;
        int vertexAz = neHeight;
        int c3 = neColor;
        int vertexBx = 0;
        int vertexBy = 128;
        int vertexBz = nwHeight;
        int c4 = nwColor;
        vertexBuffer.put(vertexAx, vertexAz, vertexAy, c3);
        vertexBuffer.put(vertexBx, vertexBz, vertexBy, c4);
        vertexBuffer.put(vertexCx, vertexCz, vertexCy, c2);
        vertexBuffer.put(vertexDx, vertexDz, vertexDy, c1);
        vertexBuffer.put(vertexCx, vertexCz, vertexCy, c2);
        vertexBuffer.put(vertexBx, vertexBz, vertexBy, c4);
        if (tile.getTexture() != -1) {
            float tex = (float)tile.getTexture() + 1.0f;
            uvBuffer.put(tex, 1.0f, 1.0f, 0.0f);
            uvBuffer.put(tex, 0.0f, 1.0f, 0.0f);
            uvBuffer.put(tex, 1.0f, 0.0f, 0.0f);
            uvBuffer.put(tex, 0.0f, 0.0f, 0.0f);
            uvBuffer.put(tex, 1.0f, 0.0f, 0.0f);
            uvBuffer.put(tex, 0.0f, 1.0f, 0.0f);
        }
        return 6;
    }

    private int upload(SceneTileModel sceneTileModel, int tileX, int tileY, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer) {
        int[] faceX = sceneTileModel.getFaceX();
        int[] faceY = sceneTileModel.getFaceY();
        int[] faceZ = sceneTileModel.getFaceZ();
        int[] vertexX = sceneTileModel.getVertexX();
        int[] vertexY = sceneTileModel.getVertexY();
        int[] vertexZ = sceneTileModel.getVertexZ();
        int[] triangleColorA = sceneTileModel.getTriangleColorA();
        int[] triangleColorB = sceneTileModel.getTriangleColorB();
        int[] triangleColorC = sceneTileModel.getTriangleColorC();
        int[] triangleTextures = sceneTileModel.getTriangleTextureId();
        int faceCount = faceX.length;
        vertexBuffer.ensureCapacity(faceCount * 12);
        uvBuffer.ensureCapacity(faceCount * 12);
        int baseX = 128 * tileX;
        int baseY = 128 * tileY;
        int cnt = 0;
        for (int i = 0; i < faceCount; ++i) {
            int triangleA = faceX[i];
            int triangleB = faceY[i];
            int triangleC = faceZ[i];
            int colorA = triangleColorA[i];
            int colorB = triangleColorB[i];
            int colorC = triangleColorC[i];
            if (colorA == 12345678) continue;
            cnt += 3;
            int vertexXA = vertexX[triangleA] - baseX;
            int vertexZA = vertexZ[triangleA] - baseY;
            int vertexXB = vertexX[triangleB] - baseX;
            int vertexZB = vertexZ[triangleB] - baseY;
            int vertexXC = vertexX[triangleC] - baseX;
            int vertexZC = vertexZ[triangleC] - baseY;
            vertexBuffer.put(vertexXA, vertexY[triangleA], vertexZA, colorA);
            vertexBuffer.put(vertexXB, vertexY[triangleB], vertexZB, colorB);
            vertexBuffer.put(vertexXC, vertexY[triangleC], vertexZC, colorC);
            if (triangleTextures == null) continue;
            if (triangleTextures[i] != -1) {
                float tex = (float)triangleTextures[i] + 1.0f;
                uvBuffer.put(tex, (float)vertexXA / 128.0f, (float)vertexZA / 128.0f, 0.0f);
                uvBuffer.put(tex, (float)vertexXB / 128.0f, (float)vertexZB / 128.0f, 0.0f);
                uvBuffer.put(tex, (float)vertexXC / 128.0f, (float)vertexZC / 128.0f, 0.0f);
                continue;
            }
            uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
            uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
            uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return cnt;
    }

    private void uploadModel(Model model, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer) {
        if (model.getBufferOffset() > 0) {
            return;
        }
        model.setBufferOffset(this.offset);
        if (model.getFaceTextures() != null) {
            model.setUvBufferOffset(this.uvoffset);
        } else {
            model.setUvBufferOffset(-1);
        }
        model.setSceneId(this.sceneId);
        vertexBuffer.ensureCapacity(model.getTrianglesCount() * 12);
        uvBuffer.ensureCapacity(model.getTrianglesCount() * 12);
        int triangleCount = model.getTrianglesCount();
        int len = 0;
        for (int i = 0; i < triangleCount; ++i) {
            len += this.pushFace(model, i, vertexBuffer, uvBuffer);
        }
        this.offset += len;
        if (model.getFaceTextures() != null) {
            this.uvoffset += len;
        }
    }

    int pushFace(Model model, int face, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer) {
        int[] vertexX = model.getVerticesX();
        int[] vertexY = model.getVerticesY();
        int[] vertexZ = model.getVerticesZ();
        int[] trianglesX = model.getTrianglesX();
        int[] trianglesY = model.getTrianglesY();
        int[] trianglesZ = model.getTrianglesZ();
        int[] color1s = model.getFaceColors1();
        int[] color2s = model.getFaceColors2();
        int[] color3s = model.getFaceColors3();
        byte[] transparencies = model.getTriangleTransparencies();
        short[] faceTextures = model.getFaceTextures();
        byte[] facePriorities = model.getFaceRenderPriorities();
        int triangleA = trianglesX[face];
        int triangleB = trianglesY[face];
        int triangleC = trianglesZ[face];
        int color1 = color1s[face];
        int color2 = color2s[face];
        int color3 = color3s[face];
        int alpha = 0;
        if (transparencies != null && (faceTextures == null || faceTextures[face] == -1)) {
            alpha = (transparencies[face] & 0xFF) << 24;
        }
        int priority = 0;
        if (facePriorities != null) {
            priority = (facePriorities[face] & 0xFF) << 16;
        }
        if (color3 == -1) {
            color2 = color3 = color1;
        } else if (color3 == -2) {
            vertexBuffer.put(0, 0, 0, 0);
            vertexBuffer.put(0, 0, 0, 0);
            vertexBuffer.put(0, 0, 0, 0);
            if (faceTextures != null) {
                uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
                uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
                uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
            }
            return 3;
        }
        int a = vertexX[triangleA];
        int b = vertexY[triangleA];
        int c = vertexZ[triangleA];
        vertexBuffer.put(a, b, c, alpha | priority | color1);
        a = vertexX[triangleB];
        b = vertexY[triangleB];
        c = vertexZ[triangleB];
        vertexBuffer.put(a, b, c, alpha | priority | color2);
        a = vertexX[triangleC];
        b = vertexY[triangleC];
        c = vertexZ[triangleC];
        vertexBuffer.put(a, b, c, alpha | priority | color3);
        float[][] u = model.getFaceTextureUCoordinates();
        float[][] v = model.getFaceTextureVCoordinates();
        if (faceTextures != null) {
            float[] vf;
            float[] uf;
            if (u != null && v != null && (uf = u[face]) != null && (vf = v[face]) != null) {
                float texture = (float)faceTextures[face] + 1.0f;
                uvBuffer.put(texture, uf[0], vf[0], 0.0f);
                uvBuffer.put(texture, uf[1], vf[1], 0.0f);
                uvBuffer.put(texture, uf[2], vf[2], 0.0f);
            } else {
                uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
                uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
                uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        return 3;
    }
}

