/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import com.google.inject.Provides;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.JAWTWindow;
import com.jogamp.opengl.GL4;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.function.Function;
import javax.inject.Inject;
import jogamp.nativewindow.SurfaceScaleUtils;
import jogamp.nativewindow.jawt.x11.X11JAWTWindow;
import jogamp.newt.awt.NewtFactoryAWT;
import net.runelite.api.BufferProvider;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Model;
import net.runelite.api.NodeCache;
import net.runelite.api.Perspective;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Texture;
import net.runelite.api.TextureProvider;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.hooks.DrawCallbacks;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.gpu.GLUtil;
import net.runelite.client.plugins.gpu.GpuFloatBuffer;
import net.runelite.client.plugins.gpu.GpuIntBuffer;
import net.runelite.client.plugins.gpu.GpuPluginConfig;
import net.runelite.client.plugins.gpu.SceneUploader;
import net.runelite.client.plugins.gpu.ShaderException;
import net.runelite.client.plugins.gpu.TextureManager;
import net.runelite.client.plugins.gpu.config.AntiAliasingMode;
import net.runelite.client.plugins.gpu.template.Template;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.OSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="GPU", description="Utilizes the GPU", enabledByDefault=false, tags={"fog", "draw distance"})
public class GpuPlugin
extends Plugin
implements DrawCallbacks {
    private static final Logger log = LoggerFactory.getLogger(GpuPlugin.class);
    private static final int MAX_TRIANGLE = 4096;
    private static final int SMALL_TRIANGLE_COUNT = 512;
    private static final int FLAG_SCENE_BUFFER = Integer.MIN_VALUE;
    static final int MAX_DISTANCE = 90;
    static final int MAX_FOG_DEPTH = 100;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private GpuPluginConfig config;
    @Inject
    private TextureManager textureManager;
    @Inject
    private SceneUploader sceneUploader;
    @Inject
    private DrawManager drawManager;
    @Inject
    private PluginManager pluginManager;
    private Canvas canvas;
    private JAWTWindow jawtWindow;
    private GL4 gl;
    private GLContext glContext;
    private GLDrawable glDrawable;
    private int glProgram;
    private int glVertexShader;
    private int glGeomShader;
    private int glFragmentShader;
    private int glComputeProgram;
    private int glComputeShader;
    private int glSmallComputeProgram;
    private int glSmallComputeShader;
    private int glUnorderedComputeProgram;
    private int glUnorderedComputeShader;
    private int vaoHandle;
    private int interfaceTexture;
    private int glUiProgram;
    private int glUiVertexShader;
    private int glUiFragmentShader;
    private int vaoUiHandle;
    private int vboUiHandle;
    private int fboSceneHandle;
    private int texSceneHandle;
    private int rboSceneHandle;
    private int bufferId;
    private int uvBufferId;
    private int textureArrayId;
    private int uniformBufferId;
    private final IntBuffer uniformBuffer = GpuIntBuffer.allocateDirect(8200);
    private final float[] textureOffsets = new float[128];
    private GpuIntBuffer vertexBuffer;
    private GpuFloatBuffer uvBuffer;
    private GpuIntBuffer modelBufferUnordered;
    private GpuIntBuffer modelBufferSmall;
    private GpuIntBuffer modelBuffer;
    private int unorderedModels;
    private int smallModels;
    private int largeModels;
    private int targetBufferOffset;
    private int tempOffset;
    private int tempUvOffset;
    private int lastViewportWidth;
    private int lastViewportHeight;
    private int lastCanvasWidth;
    private int lastCanvasHeight;
    private int lastStretchedCanvasWidth;
    private int lastStretchedCanvasHeight;
    private AntiAliasingMode lastAntiAliasingMode;
    private int centerX;
    private int centerY;
    private int uniUseFog;
    private int uniFogColor;
    private int uniFogDepth;
    private int uniDrawDistance;
    private int uniProjectionMatrix;
    private int uniBrightness;
    private int uniTex;
    private int uniTextures;
    private int uniTextureOffsets;
    private int uniBlockSmall;
    private int uniBlockLarge;
    private int uniBlockMain;
    private int uniSmoothBanding;

    @Override
    protected void startUp() {
        this.clientThread.invoke(() -> {
            try {
                int res;
                this.uniformBufferId = -1;
                this.uvBufferId = -1;
                this.bufferId = -1;
                this.largeModels = 0;
                this.smallModels = 0;
                this.unorderedModels = 0;
                this.vertexBuffer = new GpuIntBuffer();
                this.uvBuffer = new GpuFloatBuffer();
                this.modelBufferUnordered = new GpuIntBuffer();
                this.modelBufferSmall = new GpuIntBuffer();
                this.modelBuffer = new GpuIntBuffer();
                this.canvas = this.client.getCanvas();
                this.canvas.setIgnoreRepaint(true);
                if (log.isDebugEnabled()) {
                    System.setProperty("jogl.debug", "true");
                }
                GLProfile.initSingleton();
                GLProfile glProfile = GLProfile.get("GL4");
                GLCapabilities glCaps = new GLCapabilities(glProfile);
                AWTGraphicsConfiguration config = AWTGraphicsConfiguration.create(this.canvas.getGraphicsConfiguration(), (CapabilitiesImmutable)glCaps, (CapabilitiesImmutable)glCaps);
                this.jawtWindow = NewtFactoryAWT.getNativeWindow((Component)this.canvas, config);
                this.canvas.setFocusable(true);
                GLDrawableFactory glDrawableFactory = GLDrawableFactory.getFactory(glProfile);
                this.glDrawable = glDrawableFactory.createGLDrawable(this.jawtWindow);
                this.glDrawable.setRealized(true);
                this.glContext = this.glDrawable.createContext(null);
                if (log.isDebugEnabled()) {
                    this.glContext.enableGLDebugMessage(true);
                }
                if ((res = this.glContext.makeCurrent()) == 0) {
                    throw new GLException("Unable to make context current");
                }
                if (this.jawtWindow instanceof X11JAWTWindow && this.jawtWindow.getLock().isLocked()) {
                    this.jawtWindow.unlockSurface();
                }
                this.gl = this.glContext.getGL().getGL4();
                this.gl.setSwapInterval(0);
                if (log.isDebugEnabled()) {
                    this.gl.glEnable(37600);
                    this.gl.getContext().glDebugMessageControl(33350, 33361, 33387, 0, null, 0, false);
                }
                this.initVao();
                this.initProgram();
                this.initInterfaceTexture();
                this.initUniformBuffer();
                this.client.setDrawCallbacks(this);
                this.client.setGpu(true);
                this.client.resizeCanvas();
                this.lastCanvasHeight = -1;
                this.lastCanvasWidth = -1;
                this.lastViewportHeight = -1;
                this.lastViewportWidth = -1;
                this.lastStretchedCanvasHeight = -1;
                this.lastStretchedCanvasWidth = -1;
                this.lastAntiAliasingMode = null;
                this.textureArrayId = -1;
                NodeCache cachedModels2 = this.client.getCachedModels2();
                cachedModels2.setCapacity(256);
                cachedModels2.setRemainingCapacity(256);
                cachedModels2.reset();
                if (this.client.getGameState() == GameState.LOGGED_IN) {
                    this.uploadScene();
                }
            }
            catch (Throwable e) {
                log.error("Error starting GPU plugin", e);
                try {
                    this.pluginManager.setPluginEnabled(this, false);
                    this.pluginManager.stopPlugin(this);
                }
                catch (PluginInstantiationException ex) {
                    log.error("error stopping plugin", ex);
                }
                this.shutDown();
            }
        });
    }

    @Override
    protected void shutDown() {
        this.clientThread.invoke(() -> {
            this.client.setGpu(false);
            this.client.setDrawCallbacks(null);
            if (this.gl != null) {
                if (this.textureArrayId != -1) {
                    this.textureManager.freeTextureArray(this.gl, this.textureArrayId);
                    this.textureArrayId = -1;
                }
                if (this.bufferId != -1) {
                    GLUtil.glDeleteBuffer(this.gl, this.bufferId);
                    this.bufferId = -1;
                }
                if (this.uvBufferId != -1) {
                    GLUtil.glDeleteBuffer(this.gl, this.uvBufferId);
                    this.uvBufferId = -1;
                }
                if (this.uniformBufferId != -1) {
                    GLUtil.glDeleteBuffer(this.gl, this.uniformBufferId);
                    this.uniformBufferId = -1;
                }
                this.shutdownInterfaceTexture();
                this.shutdownProgram();
                this.shutdownVao();
                this.shutdownSceneFbo();
            }
            if (this.jawtWindow != null) {
                if (!this.jawtWindow.getLock().isLocked()) {
                    this.jawtWindow.lockSurface();
                }
                if (this.glContext != null) {
                    this.glContext.destroy();
                }
                NewtFactoryAWT.destroyNativeWindow(this.jawtWindow);
            }
            this.jawtWindow = null;
            this.gl = null;
            this.glDrawable = null;
            this.glContext = null;
            this.vertexBuffer = null;
            this.uvBuffer = null;
            this.modelBufferSmall = null;
            this.modelBuffer = null;
            this.modelBufferUnordered = null;
            this.client.resizeCanvas();
        });
    }

    @Provides
    GpuPluginConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(GpuPluginConfig.class);
    }

    private void initProgram() throws ShaderException {
        this.glProgram = this.gl.glCreateProgram();
        this.glVertexShader = this.gl.glCreateShader(35633);
        this.glGeomShader = this.gl.glCreateShader(36313);
        this.glFragmentShader = this.gl.glCreateShader(35632);
        String glVersionHeader = OSType.getOSType() == OSType.Linux ? "#version 420\n#extension GL_ARB_compute_shader : require\n#extension GL_ARB_shader_storage_buffer_object : require\n" : "#version 430\n";
        Function<String, String> resourceLoader = s -> {
            if (s.endsWith(".glsl")) {
                return GLUtil.inputStreamToString(this.getClass().getResourceAsStream((String)s));
            }
            if (s.equals("version_header")) {
                return glVersionHeader;
            }
            return "";
        };
        Template template = new Template(resourceLoader);
        String source = template.process(resourceLoader.apply("geom.glsl"));
        template = new Template(resourceLoader);
        String vertSource = template.process(resourceLoader.apply("vert.glsl"));
        template = new Template(resourceLoader);
        String fragSource = template.process(resourceLoader.apply("frag.glsl"));
        GLUtil.loadShaders(this.gl, this.glProgram, this.glVertexShader, this.glGeomShader, this.glFragmentShader, vertSource, source, fragSource);
        this.glComputeProgram = this.gl.glCreateProgram();
        this.glComputeShader = this.gl.glCreateShader(37305);
        template = new Template(resourceLoader);
        source = template.process(resourceLoader.apply("comp.glsl"));
        GLUtil.loadComputeShader(this.gl, this.glComputeProgram, this.glComputeShader, source);
        this.glSmallComputeProgram = this.gl.glCreateProgram();
        this.glSmallComputeShader = this.gl.glCreateShader(37305);
        template = new Template(resourceLoader);
        source = template.process(resourceLoader.apply("comp_small.glsl"));
        GLUtil.loadComputeShader(this.gl, this.glSmallComputeProgram, this.glSmallComputeShader, source);
        this.glUnorderedComputeProgram = this.gl.glCreateProgram();
        this.glUnorderedComputeShader = this.gl.glCreateShader(37305);
        template = new Template(resourceLoader);
        source = template.process(resourceLoader.apply("comp_unordered.glsl"));
        GLUtil.loadComputeShader(this.gl, this.glUnorderedComputeProgram, this.glUnorderedComputeShader, source);
        this.glUiProgram = this.gl.glCreateProgram();
        this.glUiVertexShader = this.gl.glCreateShader(35633);
        this.glUiFragmentShader = this.gl.glCreateShader(35632);
        GLUtil.loadShaders(this.gl, this.glUiProgram, this.glUiVertexShader, -1, this.glUiFragmentShader, GLUtil.inputStreamToString(this.getClass().getResourceAsStream("vertui.glsl")), null, GLUtil.inputStreamToString(this.getClass().getResourceAsStream("fragui.glsl")));
        this.initUniforms();
    }

    private void initUniforms() {
        this.uniProjectionMatrix = this.gl.glGetUniformLocation(this.glProgram, "projectionMatrix");
        this.uniBrightness = this.gl.glGetUniformLocation(this.glProgram, "brightness");
        this.uniSmoothBanding = this.gl.glGetUniformLocation(this.glProgram, "smoothBanding");
        this.uniUseFog = this.gl.glGetUniformLocation(this.glProgram, "useFog");
        this.uniFogColor = this.gl.glGetUniformLocation(this.glProgram, "fogColor");
        this.uniFogDepth = this.gl.glGetUniformLocation(this.glProgram, "fogDepth");
        this.uniDrawDistance = this.gl.glGetUniformLocation(this.glProgram, "drawDistance");
        this.uniTex = this.gl.glGetUniformLocation(this.glUiProgram, "tex");
        this.uniTextures = this.gl.glGetUniformLocation(this.glProgram, "textures");
        this.uniTextureOffsets = this.gl.glGetUniformLocation(this.glProgram, "textureOffsets");
        this.uniBlockSmall = this.gl.glGetUniformBlockIndex(this.glSmallComputeProgram, "uniforms");
        this.uniBlockLarge = this.gl.glGetUniformBlockIndex(this.glComputeProgram, "uniforms");
        this.uniBlockMain = this.gl.glGetUniformBlockIndex(this.glProgram, "uniforms");
    }

    private void shutdownProgram() {
        this.gl.glDeleteShader(this.glVertexShader);
        this.glVertexShader = -1;
        this.gl.glDeleteShader(this.glGeomShader);
        this.glGeomShader = -1;
        this.gl.glDeleteShader(this.glFragmentShader);
        this.glFragmentShader = -1;
        this.gl.glDeleteProgram(this.glProgram);
        this.glProgram = -1;
        this.gl.glDeleteShader(this.glComputeShader);
        this.glComputeShader = -1;
        this.gl.glDeleteProgram(this.glComputeProgram);
        this.glComputeProgram = -1;
        this.gl.glDeleteShader(this.glSmallComputeShader);
        this.glSmallComputeShader = -1;
        this.gl.glDeleteProgram(this.glSmallComputeProgram);
        this.glSmallComputeProgram = -1;
        this.gl.glDeleteShader(this.glUnorderedComputeShader);
        this.glUnorderedComputeShader = -1;
        this.gl.glDeleteProgram(this.glUnorderedComputeProgram);
        this.glUnorderedComputeProgram = -1;
        this.gl.glDeleteShader(this.glUiVertexShader);
        this.glUiVertexShader = -1;
        this.gl.glDeleteShader(this.glUiFragmentShader);
        this.glUiFragmentShader = -1;
        this.gl.glDeleteProgram(this.glUiProgram);
        this.glUiProgram = -1;
    }

    private void initVao() {
        this.vaoHandle = GLUtil.glGenVertexArrays(this.gl);
        this.vaoUiHandle = GLUtil.glGenVertexArrays(this.gl);
        this.vboUiHandle = GLUtil.glGenBuffers(this.gl);
        this.gl.glBindVertexArray(this.vaoUiHandle);
        FloatBuffer vboUiBuf = GpuFloatBuffer.allocateDirect(20);
        vboUiBuf.put(new float[]{1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f});
        vboUiBuf.rewind();
        this.gl.glBindBuffer(34962, this.vboUiHandle);
        this.gl.glBufferData(34962, vboUiBuf.capacity() * 4, vboUiBuf, 35044);
        this.gl.glVertexAttribPointer(0, 3, 5126, false, 20, 0L);
        this.gl.glEnableVertexAttribArray(0);
        this.gl.glVertexAttribPointer(1, 2, 5126, false, 20, 12L);
        this.gl.glEnableVertexAttribArray(1);
        this.gl.glBindBuffer(34962, 0);
    }

    private void shutdownVao() {
        GLUtil.glDeleteVertexArrays(this.gl, this.vaoHandle);
        this.vaoHandle = -1;
        GLUtil.glDeleteBuffer(this.gl, this.vboUiHandle);
        this.vboUiHandle = -1;
        GLUtil.glDeleteVertexArrays(this.gl, this.vaoUiHandle);
        this.vaoUiHandle = -1;
    }

    private void initInterfaceTexture() {
        this.interfaceTexture = GLUtil.glGenTexture(this.gl);
        this.gl.glBindTexture(3553, this.interfaceTexture);
        this.gl.glTexParameteri(3553, 10242, 10497);
        this.gl.glTexParameteri(3553, 10243, 10497);
        this.gl.glTexParameteri(3553, 10241, 9729);
        this.gl.glTexParameteri(3553, 10240, 9729);
        this.gl.glBindTexture(3553, 0);
    }

    private void shutdownInterfaceTexture() {
        GLUtil.glDeleteTexture(this.gl, this.interfaceTexture);
        this.interfaceTexture = -1;
    }

    private void initUniformBuffer() {
        this.uniformBufferId = GLUtil.glGenBuffers(this.gl);
        this.gl.glBindBuffer(35345, this.uniformBufferId);
        this.uniformBuffer.clear();
        this.uniformBuffer.put(new int[8]);
        int[] pad = new int[2];
        for (int i = 0; i < 2048; ++i) {
            this.uniformBuffer.put(Perspective.SINE[i]);
            this.uniformBuffer.put(Perspective.COSINE[i]);
            this.uniformBuffer.put(pad);
        }
        this.uniformBuffer.flip();
        this.gl.glBufferData(35345, this.uniformBuffer.limit() * 4, this.uniformBuffer, 35044);
        this.gl.glBindBuffer(35345, 0);
    }

    private void initSceneFbo(int width, int height, int aaSamples) {
        this.fboSceneHandle = GLUtil.glGenFrameBuffer(this.gl);
        this.gl.glBindFramebuffer(36160, this.fboSceneHandle);
        this.rboSceneHandle = GLUtil.glGenRenderbuffer(this.gl);
        this.gl.glBindRenderbuffer(36161, this.rboSceneHandle);
        this.gl.glRenderbufferStorageMultisample(36161, aaSamples, 6408, width, height);
        this.gl.glFramebufferRenderbuffer(36160, 36064, 36161, this.rboSceneHandle);
        this.texSceneHandle = GLUtil.glGenTexture(this.gl);
        this.gl.glBindTexture(37120, this.texSceneHandle);
        this.gl.glTexImage2DMultisample(37120, aaSamples, 6408, width, height, true);
        this.gl.glFramebufferTexture2D(36160, 36064, 37120, this.texSceneHandle, 0);
        this.gl.glBindTexture(37120, 0);
        this.gl.glBindFramebuffer(36160, 0);
        this.gl.glBindRenderbuffer(36161, 0);
    }

    private void shutdownSceneFbo() {
        if (this.texSceneHandle != -1) {
            GLUtil.glDeleteTexture(this.gl, this.texSceneHandle);
            this.texSceneHandle = -1;
        }
        if (this.fboSceneHandle != -1) {
            GLUtil.glDeleteFrameBuffer(this.gl, this.fboSceneHandle);
            this.fboSceneHandle = -1;
        }
        if (this.rboSceneHandle != -1) {
            GLUtil.glDeleteRenderbuffers(this.gl, this.rboSceneHandle);
            this.rboSceneHandle = -1;
        }
    }

    private void createProjectionMatrix(float left, float right, float bottom, float top, float near, float far) {
        float tx = -((right + left) / (right - left));
        float ty = -((top + bottom) / (top - bottom));
        float tz = -((far + near) / (far - near));
        this.gl.glUseProgram(this.glProgram);
        float[] matrix = new float[]{2.0f / (right - left), 0.0f, 0.0f, 0.0f, 0.0f, 2.0f / (top - bottom), 0.0f, 0.0f, 0.0f, 0.0f, -2.0f / (far - near), 0.0f, tx, ty, tz, 1.0f};
        this.gl.glUniformMatrix4fv(this.uniProjectionMatrix, 1, false, matrix, 0);
        this.gl.glUseProgram(0);
    }

    @Override
    public void drawScene(int cameraX, int cameraY, int cameraZ, int cameraPitch, int cameraYaw, int plane) {
        this.centerX = this.client.getCenterX();
        this.centerY = this.client.getCenterY();
        Scene scene = this.client.getScene();
        int drawDistance = Math.max(0, Math.min(90, this.config.drawDistance()));
        scene.setDrawDistance(drawDistance);
    }

    @Override
    public void drawScenePaint(int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, SceneTilePaint paint, int tileZ, int tileX, int tileY, int zoom, int centerX, int centerY) {
        if (paint.getBufferLen() > 0) {
            x = tileX * 128;
            y = 0;
            z = tileY * 128;
            GpuIntBuffer b = this.modelBufferUnordered;
            ++this.unorderedModels;
            b.ensureCapacity(8);
            IntBuffer buffer = b.getBuffer();
            buffer.put(paint.getBufferOffset());
            buffer.put(paint.getUvBufferOffset());
            buffer.put(2);
            buffer.put(this.targetBufferOffset);
            buffer.put(Integer.MIN_VALUE);
            buffer.put(x).put(y).put(z);
            this.targetBufferOffset += 6;
        }
    }

    @Override
    public void drawSceneModel(int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, SceneTileModel model, int tileZ, int tileX, int tileY, int zoom, int centerX, int centerY) {
        if (model.getBufferLen() > 0) {
            x = tileX * 128;
            y = 0;
            z = tileY * 128;
            GpuIntBuffer b = this.modelBufferUnordered;
            ++this.unorderedModels;
            b.ensureCapacity(8);
            IntBuffer buffer = b.getBuffer();
            buffer.put(model.getBufferOffset());
            buffer.put(model.getUvBufferOffset());
            buffer.put(model.getBufferLen() / 3);
            buffer.put(this.targetBufferOffset);
            buffer.put(Integer.MIN_VALUE);
            buffer.put(x).put(y).put(z);
            this.targetBufferOffset += model.getBufferLen();
        }
    }

    @Override
    public void draw() {
        AntiAliasingMode antiAliasingMode;
        boolean aaEnabled;
        if (this.jawtWindow.getAWTComponent() != this.client.getCanvas()) {
            log.warn("Canvas invalidated!");
            this.shutDown();
            this.startUp();
            return;
        }
        if (this.client.getGameState() == GameState.LOADING || this.client.getGameState() == GameState.HOPPING) {
            return;
        }
        int canvasHeight = this.client.getCanvasHeight();
        int canvasWidth = this.client.getCanvasWidth();
        int viewportHeight = this.client.getViewportHeight();
        int viewportWidth = this.client.getViewportWidth();
        if (viewportWidth > 0 && viewportHeight > 0 && (viewportWidth != this.lastViewportWidth || viewportHeight != this.lastViewportHeight)) {
            this.createProjectionMatrix(0.0f, viewportWidth, viewportHeight, 0.0f, 0.0f, 13312.0f);
            this.lastViewportWidth = viewportWidth;
            this.lastViewportHeight = viewportHeight;
        }
        boolean bl = aaEnabled = (antiAliasingMode = this.config.antiAliasingMode()) != AntiAliasingMode.DISABLED;
        if (aaEnabled) {
            int stretchedCanvasHeight;
            this.gl.glEnable(32925);
            Dimension stretchedDimensions = this.client.getStretchedDimensions();
            int stretchedCanvasWidth = this.client.isStretchedEnabled() ? stretchedDimensions.width : canvasWidth;
            int n = stretchedCanvasHeight = this.client.isStretchedEnabled() ? stretchedDimensions.height : canvasHeight;
            if (this.lastStretchedCanvasWidth != stretchedCanvasWidth || this.lastStretchedCanvasHeight != stretchedCanvasHeight || this.lastAntiAliasingMode != antiAliasingMode) {
                this.shutdownSceneFbo();
                int maxSamples = GLUtil.glGetInteger(this.gl, 36183);
                int samples = Math.min(antiAliasingMode.getSamples(), maxSamples);
                this.initSceneFbo(stretchedCanvasWidth, stretchedCanvasHeight, samples);
                this.lastStretchedCanvasWidth = stretchedCanvasWidth;
                this.lastStretchedCanvasHeight = stretchedCanvasHeight;
            }
            this.gl.glBindFramebuffer(36009, this.fboSceneHandle);
        } else {
            this.gl.glDisable(32925);
            this.shutdownSceneFbo();
        }
        this.lastAntiAliasingMode = antiAliasingMode;
        int sky = this.client.getSkyboxColor();
        this.gl.glClearColor((float)(sky >> 16 & 0xFF) / 255.0f, (float)(sky >> 8 & 0xFF) / 255.0f, (float)(sky & 0xFF) / 255.0f, 1.0f);
        this.gl.glClear(16384);
        this.vertexBuffer.flip();
        this.uvBuffer.flip();
        this.modelBuffer.flip();
        this.modelBufferSmall.flip();
        this.modelBufferUnordered.flip();
        int bufferId = GLUtil.glGenBuffers(this.gl);
        int uvBufferId = GLUtil.glGenBuffers(this.gl);
        int modelBufferId = GLUtil.glGenBuffers(this.gl);
        int modelBufferSmallId = GLUtil.glGenBuffers(this.gl);
        int modelBufferUnorderedId = GLUtil.glGenBuffers(this.gl);
        IntBuffer vertexBuffer = this.vertexBuffer.getBuffer();
        FloatBuffer uvBuffer = this.uvBuffer.getBuffer();
        IntBuffer modelBuffer = this.modelBuffer.getBuffer();
        IntBuffer modelBufferSmall = this.modelBufferSmall.getBuffer();
        IntBuffer modelBufferUnordered = this.modelBufferUnordered.getBuffer();
        this.gl.glBindBuffer(34962, bufferId);
        this.gl.glBufferData(34962, vertexBuffer.limit() * 4, vertexBuffer, 35040);
        this.gl.glBindBuffer(34962, uvBufferId);
        this.gl.glBufferData(34962, uvBuffer.limit() * 4, uvBuffer, 35040);
        this.gl.glBindBuffer(34962, modelBufferId);
        this.gl.glBufferData(34962, modelBuffer.limit() * 4, modelBuffer, 35040);
        this.gl.glBindBuffer(34962, modelBufferSmallId);
        this.gl.glBufferData(34962, modelBufferSmall.limit() * 4, modelBufferSmall, 35040);
        this.gl.glBindBuffer(34962, modelBufferUnorderedId);
        this.gl.glBufferData(34962, modelBufferUnordered.limit() * 4, modelBufferUnordered, 35040);
        this.gl.glBindBuffer(34962, 0);
        int outBufferId = GLUtil.glGenBuffers(this.gl);
        this.gl.glBindBuffer(34962, outBufferId);
        this.gl.glBufferData(34962, this.targetBufferOffset * 16, null, 35040);
        int outUvBufferId = GLUtil.glGenBuffers(this.gl);
        this.gl.glBindBuffer(34962, outUvBufferId);
        this.gl.glBufferData(34962, this.targetBufferOffset * 16, null, 35040);
        this.gl.glBindBuffer(35345, this.uniformBufferId);
        this.uniformBuffer.clear();
        this.uniformBuffer.put(this.client.getCameraYaw()).put(this.client.getCameraPitch()).put(this.centerX).put(this.centerY).put(this.client.getScale()).put(this.client.getCameraX2()).put(this.client.getCameraY2()).put(this.client.getCameraZ2());
        this.uniformBuffer.flip();
        this.gl.glBufferSubData(35345, 0L, this.uniformBuffer.limit() * 4, this.uniformBuffer);
        this.gl.glBindBuffer(35345, 0);
        TextureProvider textureProvider = this.client.getTextureProvider();
        if (textureProvider != null && this.bufferId != -1) {
            this.gl.glUniformBlockBinding(this.glSmallComputeProgram, this.uniBlockSmall, 0);
            this.gl.glUniformBlockBinding(this.glComputeProgram, this.uniBlockLarge, 0);
            this.gl.glBindBufferBase(35345, 0, this.uniformBufferId);
            this.gl.glUseProgram(this.glUnorderedComputeProgram);
            this.gl.glBindBufferBase(37074, 0, modelBufferUnorderedId);
            this.gl.glBindBufferBase(37074, 1, this.bufferId);
            this.gl.glBindBufferBase(37074, 2, bufferId);
            this.gl.glBindBufferBase(37074, 3, outBufferId);
            this.gl.glBindBufferBase(37074, 4, outUvBufferId);
            this.gl.glBindBufferBase(37074, 5, this.uvBufferId);
            this.gl.glBindBufferBase(37074, 6, uvBufferId);
            this.gl.glDispatchCompute(this.unorderedModels, 1, 1);
            this.gl.glUseProgram(this.glSmallComputeProgram);
            this.gl.glBindBufferBase(37074, 0, modelBufferSmallId);
            this.gl.glBindBufferBase(37074, 1, this.bufferId);
            this.gl.glBindBufferBase(37074, 2, bufferId);
            this.gl.glBindBufferBase(37074, 3, outBufferId);
            this.gl.glBindBufferBase(37074, 4, outUvBufferId);
            this.gl.glBindBufferBase(37074, 5, this.uvBufferId);
            this.gl.glBindBufferBase(37074, 6, uvBufferId);
            this.gl.glDispatchCompute(this.smallModels, 1, 1);
            this.gl.glUseProgram(this.glComputeProgram);
            this.gl.glBindBufferBase(37074, 0, modelBufferId);
            this.gl.glBindBufferBase(37074, 1, this.bufferId);
            this.gl.glBindBufferBase(37074, 2, bufferId);
            this.gl.glBindBufferBase(37074, 3, outBufferId);
            this.gl.glBindBufferBase(37074, 4, outUvBufferId);
            this.gl.glBindBufferBase(37074, 5, this.uvBufferId);
            this.gl.glBindBufferBase(37074, 6, uvBufferId);
            this.gl.glDispatchCompute(this.largeModels, 1, 1);
            this.gl.glMemoryBarrier(8192);
            if (this.textureArrayId == -1) {
                this.textureArrayId = this.textureManager.initTextureArray(textureProvider, this.gl);
            }
            Texture[] textures = textureProvider.getTextures();
            int renderHeightOff = this.client.getViewportYOffset();
            int renderWidthOff = this.client.getViewportXOffset();
            int renderCanvasHeight = canvasHeight;
            int renderViewportHeight = viewportHeight;
            int renderViewportWidth = viewportWidth;
            if (this.client.isStretchedEnabled()) {
                Dimension dim = this.client.getStretchedDimensions();
                renderCanvasHeight = dim.height;
                double scaleFactorY = dim.getHeight() / (double)canvasHeight;
                double scaleFactorX = dim.getWidth() / (double)canvasWidth;
                boolean padding = true;
                renderViewportHeight = (int)Math.ceil(scaleFactorY * (double)renderViewportHeight) + 2;
                renderViewportWidth = (int)Math.ceil(scaleFactorX * (double)renderViewportWidth) + 2;
                renderHeightOff = (int)Math.floor(scaleFactorY * (double)renderHeightOff) - 1;
                renderWidthOff = (int)Math.floor(scaleFactorX * (double)renderWidthOff) - 1;
            }
            this.glDpiAwareViewport(renderWidthOff, renderCanvasHeight - renderViewportHeight - renderHeightOff, renderViewportWidth, renderViewportHeight);
            this.gl.glUseProgram(this.glProgram);
            int drawDistance = Math.max(0, Math.min(90, this.config.drawDistance()));
            int fogDepth = this.config.fogDepth();
            this.gl.glUniform1i(this.uniUseFog, fogDepth > 0 ? 1 : 0);
            this.gl.glUniform4f(this.uniFogColor, (float)(sky >> 16 & 0xFF) / 255.0f, (float)(sky >> 8 & 0xFF) / 255.0f, (float)(sky & 0xFF) / 255.0f, 1.0f);
            this.gl.glUniform1i(this.uniFogDepth, fogDepth);
            this.gl.glUniform1i(this.uniDrawDistance, drawDistance * 128);
            this.gl.glUniform1f(this.uniBrightness, (float)textureProvider.getBrightness());
            this.gl.glUniform1f(this.uniSmoothBanding, this.config.smoothBanding() ? 0.0f : 1.0f);
            for (int id = 0; id < textures.length; ++id) {
                Texture texture = textures[id];
                if (texture == null) continue;
                textureProvider.load(id);
                this.textureOffsets[id * 2] = texture.getU();
                this.textureOffsets[id * 2 + 1] = texture.getV();
            }
            this.gl.glUniformBlockBinding(this.glProgram, this.uniBlockMain, 0);
            this.gl.glUniform1i(this.uniTextures, 1);
            this.gl.glUniform2fv(this.uniTextureOffsets, 128, this.textureOffsets, 0);
            this.gl.glEnable(2884);
            this.gl.glEnable(3042);
            this.gl.glBlendFunc(770, 771);
            this.gl.glBindVertexArray(this.vaoHandle);
            this.gl.glEnableVertexAttribArray(0);
            this.gl.glBindBuffer(34962, outBufferId);
            this.gl.glVertexAttribIPointer(0, 4, 5124, 0, 0L);
            this.gl.glEnableVertexAttribArray(1);
            this.gl.glBindBuffer(34962, outUvBufferId);
            this.gl.glVertexAttribPointer(1, 4, 5126, false, 0, 0L);
            this.gl.glDrawArrays(4, 0, this.targetBufferOffset);
            this.gl.glDisable(3042);
            this.gl.glDisable(2884);
            this.gl.glUseProgram(0);
        }
        if (aaEnabled) {
            this.gl.glBindFramebuffer(36008, this.fboSceneHandle);
            this.gl.glBindFramebuffer(36009, 0);
            this.gl.glBlitFramebuffer(0, 0, this.lastStretchedCanvasWidth, this.lastStretchedCanvasHeight, 0, 0, this.lastStretchedCanvasWidth, this.lastStretchedCanvasHeight, 16384, 9728);
            this.gl.glBindFramebuffer(36008, 0);
        }
        vertexBuffer.clear();
        uvBuffer.clear();
        modelBuffer.clear();
        modelBufferSmall.clear();
        modelBufferUnordered.clear();
        this.targetBufferOffset = 0;
        this.unorderedModels = 0;
        this.largeModels = 0;
        this.smallModels = 0;
        this.tempOffset = 0;
        this.tempUvOffset = 0;
        GLUtil.glDeleteBuffer(this.gl, bufferId);
        GLUtil.glDeleteBuffer(this.gl, uvBufferId);
        GLUtil.glDeleteBuffer(this.gl, modelBufferId);
        GLUtil.glDeleteBuffer(this.gl, modelBufferSmallId);
        GLUtil.glDeleteBuffer(this.gl, modelBufferUnorderedId);
        GLUtil.glDeleteBuffer(this.gl, outBufferId);
        GLUtil.glDeleteBuffer(this.gl, outUvBufferId);
        this.drawUi(canvasHeight, canvasWidth);
        this.glDrawable.swapBuffers();
        this.drawManager.processDrawComplete(this::screenshot);
    }

    private void drawUi(int canvasHeight, int canvasWidth) {
        BufferProvider bufferProvider = this.client.getBufferProvider();
        int[] pixels = bufferProvider.getPixels();
        int width = bufferProvider.getWidth();
        int height = bufferProvider.getHeight();
        this.gl.glEnable(3042);
        this.vertexBuffer.clear();
        this.vertexBuffer.ensureCapacity(pixels.length);
        IntBuffer interfaceBuffer = this.vertexBuffer.getBuffer();
        interfaceBuffer.put(pixels);
        this.vertexBuffer.flip();
        this.gl.glBlendFunc(1, 771);
        this.gl.glBindTexture(3553, this.interfaceTexture);
        if (canvasWidth != this.lastCanvasWidth || canvasHeight != this.lastCanvasHeight) {
            this.gl.glTexImage2D(3553, 0, 6408, width, height, 0, 32993, 33639, interfaceBuffer);
            this.lastCanvasWidth = canvasWidth;
            this.lastCanvasHeight = canvasHeight;
        } else {
            this.gl.glTexSubImage2D(3553, 0, 0, 0, width, height, 32993, 33639, interfaceBuffer);
        }
        if (this.client.isStretchedEnabled()) {
            Dimension dim = this.client.getStretchedDimensions();
            this.glDpiAwareViewport(0, 0, dim.width, dim.height);
        } else {
            this.glDpiAwareViewport(0, 0, canvasWidth, canvasHeight);
        }
        this.gl.glUseProgram(this.glUiProgram);
        this.gl.glUniform1i(this.uniTex, 0);
        if (this.client.isStretchedEnabled()) {
            int function = this.client.isStretchedFast() ? 9728 : 9729;
            this.gl.glTexParameteri(3553, 10241, function);
            this.gl.glTexParameteri(3553, 10240, function);
        }
        this.gl.glBindVertexArray(this.vaoUiHandle);
        this.gl.glDrawArrays(6, 0, 4);
        this.gl.glBindTexture(3553, 0);
        this.gl.glBindVertexArray(0);
        this.gl.glUseProgram(0);
        this.gl.glBlendFunc(770, 771);
        this.gl.glDisable(3042);
        this.vertexBuffer.clear();
    }

    private Image screenshot() {
        int width = this.client.getCanvasWidth();
        int height = this.client.getCanvasHeight();
        if (this.client.isStretchedEnabled()) {
            Dimension dim = this.client.getStretchedDimensions();
            width = dim.width;
            height = dim.height;
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.nativeOrder());
        this.gl.glReadBuffer(1028);
        this.gl.glReadPixels(0, 0, width, height, 6408, 5121, buffer);
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int r = buffer.get() & 0xFF;
                int g = buffer.get() & 0xFF;
                int b = buffer.get() & 0xFF;
                buffer.get();
                pixels[(height - y - 1) * width + x] = r << 16 | g << 8 | b;
            }
        }
        return image;
    }

    @Override
    public void animate(Texture texture, int diff) {
        this.textureManager.animate(texture, diff);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.uploadScene();
    }

    private void uploadScene() {
        this.vertexBuffer.clear();
        this.uvBuffer.clear();
        this.sceneUploader.upload(this.client.getScene(), this.vertexBuffer, this.uvBuffer);
        this.vertexBuffer.flip();
        this.uvBuffer.flip();
        IntBuffer vertexBuffer = this.vertexBuffer.getBuffer();
        FloatBuffer uvBuffer = this.uvBuffer.getBuffer();
        if (this.bufferId != -1) {
            GLUtil.glDeleteBuffer(this.gl, this.bufferId);
            this.bufferId = -1;
        }
        if (this.uvBufferId != -1) {
            GLUtil.glDeleteBuffer(this.gl, this.uvBufferId);
            this.uvBufferId = -1;
        }
        this.bufferId = GLUtil.glGenBuffers(this.gl);
        this.uvBufferId = GLUtil.glGenBuffers(this.gl);
        this.gl.glBindBuffer(34962, this.bufferId);
        this.gl.glBufferData(34962, vertexBuffer.limit() * 4, vertexBuffer, 35046);
        this.gl.glBindBuffer(34962, this.uvBufferId);
        this.gl.glBufferData(34962, uvBuffer.limit() * 4, uvBuffer, 35046);
        this.gl.glBindBuffer(34962, 0);
        vertexBuffer.clear();
        uvBuffer.clear();
    }

    private boolean isVisible(Model model, int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int _x, int _y, int _z, long hash) {
        int var21;
        int var22;
        int var19;
        int var18;
        int var20;
        int var17;
        int var15;
        int var16;
        int XYZMag = model.getXYZMag();
        int zoom = this.client.get3dZoom();
        int modelHeight = model.getModelHeight();
        int Rasterizer3D_clipMidX2 = this.client.getRasterizer3D_clipMidX2();
        int Rasterizer3D_clipNegativeMidX = this.client.getRasterizer3D_clipNegativeMidX();
        int Rasterizer3D_clipNegativeMidY = this.client.getRasterizer3D_clipNegativeMidY();
        int Rasterizer3D_clipMidY2 = this.client.getRasterizer3D_clipMidY2();
        int var11 = yawCos * _z - yawSin * _x >> 16;
        int var12 = pitchSin * _y + pitchCos * var11 >> 16;
        int var13 = pitchCos * XYZMag >> 16;
        int var14 = var12 + var13;
        return var14 > 50 && (var16 = ((var15 = _z * yawSin + yawCos * _x >> 16) - XYZMag) * zoom) / var14 < Rasterizer3D_clipMidX2 && (var17 = (var15 + XYZMag) * zoom) / var14 > Rasterizer3D_clipNegativeMidX && (var20 = ((var18 = pitchCos * _y - var11 * pitchSin >> 16) + (var19 = pitchSin * XYZMag >> 16)) * zoom) / var14 > Rasterizer3D_clipNegativeMidY && (var22 = (var18 - (var21 = (pitchCos * modelHeight >> 16) + var19)) * zoom) / var14 < Rasterizer3D_clipMidY2;
    }

    @Override
    public void draw(Renderable renderable, int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, long hash) {
        if (renderable instanceof Model && ((Model)renderable).getSceneId() == this.sceneUploader.sceneId) {
            Model model = (Model)renderable;
            model.calculateBoundsCylinder();
            model.calculateExtreme(orientation);
            if (!this.isVisible(model, orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, hash)) {
                return;
            }
            this.client.checkClickbox(model, orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, hash);
            int tc = Math.min(4096, model.getTrianglesCount());
            int uvOffset = model.getUvBufferOffset();
            GpuIntBuffer b = this.bufferForTriangles(tc);
            b.ensureCapacity(8);
            IntBuffer buffer = b.getBuffer();
            buffer.put(model.getBufferOffset());
            buffer.put(uvOffset);
            buffer.put(tc);
            buffer.put(this.targetBufferOffset);
            buffer.put(Integer.MIN_VALUE | model.getRadius() << 12 | orientation);
            buffer.put(x + this.client.getCameraX2()).put(y + this.client.getCameraY2()).put(z + this.client.getCameraZ2());
            this.targetBufferOffset += tc * 3;
        } else {
            Model model;
            Model model2 = model = renderable instanceof Model ? (Model)renderable : renderable.getModel();
            if (model != null) {
                model.setModelHeight(model.getModelHeight());
                model.calculateBoundsCylinder();
                model.calculateExtreme(orientation);
                if (!this.isVisible(model, orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, hash)) {
                    return;
                }
                this.client.checkClickbox(model, orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, hash);
                boolean hasUv = model.getFaceTextures() != null;
                int faces = Math.min(4096, model.getTrianglesCount());
                this.vertexBuffer.ensureCapacity(12 * faces);
                this.uvBuffer.ensureCapacity(12 * faces);
                int len = 0;
                for (int i = 0; i < faces; ++i) {
                    len += this.sceneUploader.pushFace(model, i, this.vertexBuffer, this.uvBuffer);
                }
                GpuIntBuffer b = this.bufferForTriangles(faces);
                b.ensureCapacity(8);
                IntBuffer buffer = b.getBuffer();
                buffer.put(this.tempOffset);
                buffer.put(hasUv ? this.tempUvOffset : -1);
                buffer.put(len / 3);
                buffer.put(this.targetBufferOffset);
                buffer.put(model.getRadius() << 12 | orientation);
                buffer.put(x + this.client.getCameraX2()).put(y + this.client.getCameraY2()).put(z + this.client.getCameraZ2());
                this.tempOffset += len;
                if (hasUv) {
                    this.tempUvOffset += len;
                }
                this.targetBufferOffset += len;
            }
        }
    }

    private GpuIntBuffer bufferForTriangles(int triangles) {
        if (triangles < 512) {
            ++this.smallModels;
            return this.modelBufferSmall;
        }
        ++this.largeModels;
        return this.modelBuffer;
    }

    private int getScaledValue(double scale, int value) {
        return SurfaceScaleUtils.scale(value, (float)scale);
    }

    private void glDpiAwareViewport(int x, int y, int width, int height) {
        AffineTransform t = ((Graphics2D)this.canvas.getGraphics()).getTransform();
        this.gl.glViewport(this.getScaledValue(t.getScaleX(), x), this.getScaledValue(t.getScaleY(), y), this.getScaledValue(t.getScaleX(), width), this.getScaledValue(t.getScaleY(), height));
    }
}

