/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import com.jogamp.opengl.GL4;
import java.io.InputStream;
import java.util.Scanner;
import net.runelite.client.plugins.gpu.ShaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GLUtil {
    private static final Logger log = LoggerFactory.getLogger(GLUtil.class);
    private static final int ERR_LEN = 1024;
    private static final int[] buf = new int[1];

    GLUtil() {
    }

    static int glGetInteger(GL4 gl, int pname) {
        gl.glGetIntegerv(pname, buf, 0);
        return buf[0];
    }

    static int glGetShader(GL4 gl, int shader, int pname) {
        gl.glGetShaderiv(shader, pname, buf, 0);
        assert (buf[0] > -1);
        return buf[0];
    }

    static int glGetProgram(GL4 gl, int program, int pname) {
        gl.glGetProgramiv(program, pname, buf, 0);
        assert (buf[0] > -1);
        return buf[0];
    }

    static String glGetShaderInfoLog(GL4 gl, int shader) {
        byte[] err = new byte[1024];
        gl.glGetShaderInfoLog(shader, 1024, buf, 0, err, 0);
        return new String(err);
    }

    static String glGetProgramInfoLog(GL4 gl, int program) {
        byte[] err = new byte[1024];
        gl.glGetProgramInfoLog(program, 1024, buf, 0, err, 0);
        return new String(err);
    }

    static int glGenVertexArrays(GL4 gl) {
        gl.glGenVertexArrays(1, buf, 0);
        return buf[0];
    }

    static void glDeleteVertexArrays(GL4 gl, int vertexArray) {
        GLUtil.buf[0] = vertexArray;
        gl.glDeleteVertexArrays(1, buf, 0);
    }

    static int glGenBuffers(GL4 gl) {
        gl.glGenBuffers(1, buf, 0);
        return buf[0];
    }

    static void glDeleteBuffer(GL4 gl, int buffer) {
        GLUtil.buf[0] = buffer;
        gl.glDeleteBuffers(1, buf, 0);
    }

    static int glGenTexture(GL4 gl) {
        gl.glGenTextures(1, buf, 0);
        return buf[0];
    }

    static void glDeleteTexture(GL4 gl, int texture) {
        GLUtil.buf[0] = texture;
        gl.glDeleteTextures(1, buf, 0);
    }

    static int glGenFrameBuffer(GL4 gl) {
        gl.glGenFramebuffers(1, buf, 0);
        return buf[0];
    }

    static void glDeleteFrameBuffer(GL4 gl, int frameBuffer) {
        GLUtil.buf[0] = frameBuffer;
        gl.glDeleteFramebuffers(1, buf, 0);
    }

    static int glGenRenderbuffer(GL4 gl) {
        gl.glGenRenderbuffers(1, buf, 0);
        return buf[0];
    }

    static void glDeleteRenderbuffers(GL4 gl, int renderBuffer) {
        GLUtil.buf[0] = renderBuffer;
        gl.glDeleteRenderbuffers(1, buf, 0);
    }

    static void loadShaders(GL4 gl, int glProgram, int glVertexShader, int glGeometryShader, int glFragmentShader, String vertexShaderStr, String geomShaderStr, String fragShaderStr) throws ShaderException {
        GLUtil.compileAndAttach(gl, glProgram, glVertexShader, vertexShaderStr);
        if (glGeometryShader != -1) {
            GLUtil.compileAndAttach(gl, glProgram, glGeometryShader, geomShaderStr);
        }
        GLUtil.compileAndAttach(gl, glProgram, glFragmentShader, fragShaderStr);
        gl.glLinkProgram(glProgram);
        if (GLUtil.glGetProgram(gl, glProgram, 35714) == 0) {
            String err = GLUtil.glGetProgramInfoLog(gl, glProgram);
            throw new ShaderException(err);
        }
        gl.glValidateProgram(glProgram);
        if (GLUtil.glGetProgram(gl, glProgram, 35715) == 0) {
            String err = GLUtil.glGetProgramInfoLog(gl, glProgram);
            throw new ShaderException(err);
        }
    }

    static void loadComputeShader(GL4 gl, int glProgram, int glComputeShader, String str) throws ShaderException {
        GLUtil.compileAndAttach(gl, glProgram, glComputeShader, str);
        gl.glLinkProgram(glProgram);
        if (GLUtil.glGetProgram(gl, glProgram, 35714) == 0) {
            String err = GLUtil.glGetProgramInfoLog(gl, glProgram);
            throw new ShaderException(err);
        }
        gl.glValidateProgram(glProgram);
        if (GLUtil.glGetProgram(gl, glProgram, 35715) == 0) {
            String err = GLUtil.glGetProgramInfoLog(gl, glProgram);
            throw new ShaderException(err);
        }
    }

    private static void compileAndAttach(GL4 gl, int program, int shader, String source) throws ShaderException {
        gl.glShaderSource(shader, 1, new String[]{source}, null);
        gl.glCompileShader(shader);
        if (GLUtil.glGetShader(gl, shader, 35713) != 1) {
            String err = GLUtil.glGetShaderInfoLog(gl, shader);
            throw new ShaderException(err);
        }
        gl.glAttachShader(program, shader);
    }

    static String inputStreamToString(InputStream in) {
        Scanner scanner = new Scanner(in).useDelimiter("\\A");
        return scanner.next();
    }
}

