/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.friendnotes;

import com.google.common.base.Strings;
import com.google.common.collect.ObjectArrays;
import java.awt.Color;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Friend;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Nameable;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NameableNameChanged;
import net.runelite.api.events.RemovedFriend;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.friendnotes.FriendNoteOverlay;
import net.runelite.client.plugins.friendnotes.HoveredFriend;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Friend Notes", description="Store notes about your friends")
public class FriendNotesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FriendNotesPlugin.class);
    private static final String CONFIG_GROUP = "friendNotes";
    private static final int CHARACTER_LIMIT = 128;
    private static final String KEY_PREFIX = "note_";
    private static final String ADD_NOTE = "Add Note";
    private static final String EDIT_NOTE = "Edit Note";
    private static final String NOTE_PROMPT_FORMAT = "%s's Notes<br>" + ColorUtil.prependColorTag("(Limit %s Characters)", new Color(0, 0, 170));
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private FriendNoteOverlay overlay;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    private HoveredFriend hoveredFriend = null;

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
    }

    private void setFriendNote(String displayName, String note) {
        if (Strings.isNullOrEmpty(note)) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, KEY_PREFIX + displayName);
        } else {
            this.configManager.setConfiguration(CONFIG_GROUP, KEY_PREFIX + displayName, note);
        }
    }

    @Nullable
    private String getFriendNote(String displayName) {
        return this.configManager.getConfiguration(CONFIG_GROUP, KEY_PREFIX + displayName);
    }

    private void migrateFriendNote(String currentDisplayName, String prevDisplayName) {
        String prevNote;
        String currentNote = this.getFriendNote(currentDisplayName);
        if (currentNote == null && (prevNote = this.getFriendNote(prevDisplayName)) != null) {
            log.debug("Update friend's username: '{}' -> '{}'", (Object)prevDisplayName, (Object)currentDisplayName);
            this.setFriendNote(prevDisplayName, null);
            this.setFriendNote(currentDisplayName, prevNote);
        }
    }

    private void setHoveredFriend(String displayName) {
        String note;
        this.hoveredFriend = null;
        if (!Strings.isNullOrEmpty(displayName) && (note = this.getFriendNote(displayName)) != null) {
            this.hoveredFriend = new HoveredFriend(displayName, note);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        int groupId = WidgetInfo.TO_GROUP(event.getActionParam1());
        if (groupId == WidgetInfo.FRIENDS_LIST.getGroupId() && event.getOption().equals("Message")) {
            this.setHoveredFriend(Text.toJagexName(Text.removeTags(event.getTarget())));
            MenuEntry addNote = new MenuEntry();
            addNote.setOption(this.hoveredFriend == null || this.hoveredFriend.getNote() == null ? ADD_NOTE : EDIT_NOTE);
            addNote.setType(MenuAction.RUNELITE.getId());
            addNote.setTarget(event.getTarget());
            addNote.setParam0(event.getActionParam0());
            addNote.setParam1(event.getActionParam1());
            MenuEntry[] menuEntries = ObjectArrays.concat(this.client.getMenuEntries(), addNote);
            this.client.setMenuEntries(menuEntries);
        } else if (this.hoveredFriend != null) {
            this.hoveredFriend = null;
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (WidgetInfo.TO_GROUP(event.getWidgetId()) == WidgetInfo.FRIENDS_LIST.getGroupId()) {
            if (Strings.isNullOrEmpty(event.getMenuTarget())) {
                return;
            }
            if (event.getMenuOption().equals(ADD_NOTE) || event.getMenuOption().equals(EDIT_NOTE)) {
                event.consume();
                String sanitizedTarget = Text.toJagexName(Text.removeTags(event.getMenuTarget()));
                String note = this.getFriendNote(sanitizedTarget);
                this.chatboxPanelManager.openTextInput(String.format(NOTE_PROMPT_FORMAT, sanitizedTarget, 128)).value(Strings.nullToEmpty(note)).onDone(content -> {
                    if (content == null) {
                        return;
                    }
                    content = Text.removeTags(content).trim();
                    log.debug("Set note for '{}': '{}'", (Object)sanitizedTarget, content);
                    this.setFriendNote(sanitizedTarget, (String)content);
                }).build();
            }
        }
    }

    @Subscribe
    public void onNameableNameChanged(NameableNameChanged event) {
        Nameable nameable = event.getNameable();
        if (nameable instanceof Friend) {
            Friend friend = (Friend)nameable;
            String name = friend.getName();
            String prevName = friend.getPrevName();
            if (prevName != null) {
                this.migrateFriendNote(Text.toJagexName(name), Text.toJagexName(prevName));
            }
        }
    }

    @Subscribe
    public void onRemovedFriend(RemovedFriend event) {
        String displayName = Text.toJagexName(event.getName());
        log.debug("Remove friend: '{}'", (Object)displayName);
        this.setFriendNote(displayName, null);
    }

    public HoveredFriend getHoveredFriend() {
        return this.hoveredFriend;
    }
}

