/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.friendlist;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.VarPlayer;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Friend List", description="Add extra information to the friend and ignore lists")
public class FriendListPlugin
extends Plugin {
    private static final int MAX_FRIENDS_P2P = 400;
    private static final int MAX_FRIENDS_F2P = 200;
    private static final int MAX_IGNORES_P2P = 400;
    private static final int MAX_IGNORES_F2P = 100;
    @Inject
    private Client client;

    @Override
    protected void shutDown() {
        int world = this.client.getWorld();
        this.setFriendsListTitle("Friends List - World " + world);
        this.setIgnoreListTitle("Ignore List - World " + world);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        int ignoreCount;
        int world = this.client.getWorld();
        boolean isMember = this.client.getVar(VarPlayer.MEMBERSHIP_DAYS) > 0;
        int friendCount = this.client.getFriendsCount();
        if (friendCount >= 0) {
            int limit = isMember ? 400 : 200;
            String title = "Friends - W" + world + " (" + friendCount + "/" + limit + ")";
            this.setFriendsListTitle(title);
        }
        if ((ignoreCount = this.client.getIgnoreCount()) >= 0) {
            int limit = isMember ? 400 : 100;
            String title = "Ignores - W" + world + " (" + ignoreCount + "/" + limit + ")";
            this.setIgnoreListTitle(title);
        }
    }

    private void setFriendsListTitle(String title) {
        Widget friendListTitleWidget = this.client.getWidget(WidgetInfo.FRIEND_CHAT_TITLE);
        if (friendListTitleWidget != null) {
            friendListTitleWidget.setText(title);
        }
    }

    private void setIgnoreListTitle(String title) {
        Widget ignoreTitleWidget = this.client.getWidget(WidgetInfo.IGNORE_TITLE);
        if (ignoreTitleWidget != null) {
            ignoreTitleWidget.setText(title);
        }
    }
}

