/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.fishing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.plugins.fishing.FishingConfig;
import net.runelite.client.plugins.fishing.FishingPlugin;
import net.runelite.client.plugins.fishing.FishingSpot;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

class FishingSpotMinimapOverlay
extends Overlay {
    private final FishingPlugin plugin;
    private final FishingConfig config;
    private boolean hidden;

    @Inject
    public FishingSpotMinimapOverlay(FishingPlugin plugin, FishingConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.plugin = plugin;
        this.config = config;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.hidden) {
            return null;
        }
        for (NPC npc : this.plugin.getFishingSpots()) {
            Color color;
            FishingSpot spot = FishingSpot.getSPOTS().get(npc.getId());
            if (spot == null || this.config.onlyCurrentSpot() && this.plugin.getCurrentSpot() != null && this.plugin.getCurrentSpot() != spot) continue;
            Color color2 = color = npc.getGraphic() == 1387 ? Color.RED : Color.CYAN;
            Point minimapLocation = npc.getMinimapLocation();
            if (minimapLocation == null) continue;
            OverlayUtil.renderMinimapLocation(graphics, minimapLocation, color.darker());
        }
        return null;
    }

    void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

