/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.fishing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Skill;
import net.runelite.client.plugins.fishing.FishingConfig;
import net.runelite.client.plugins.fishing.FishingPlugin;
import net.runelite.client.plugins.xptracker.XpTrackerService;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

class FishingOverlay
extends Overlay {
    private static final String FISHING_SPOT = "Fishing spot";
    private final Client client;
    private final FishingPlugin plugin;
    private final FishingConfig config;
    private final XpTrackerService xpTrackerService;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    public FishingOverlay(Client client2, FishingPlugin plugin, FishingConfig config, XpTrackerService xpTrackerService) {
        super(plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.client = client2;
        this.plugin = plugin;
        this.config = config;
        this.xpTrackerService = xpTrackerService;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Fishing overlay"));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (!this.config.showFishingStats() || this.plugin.getSession().getLastFishCaught() == null) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        if (this.client.getLocalPlayer().getInteracting() != null && this.client.getLocalPlayer().getInteracting().getName().contains(FISHING_SPOT)) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Fishing").color(Color.GREEN).build());
        } else {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("NOT fishing").color(Color.RED).build());
        }
        int actions = this.xpTrackerService.getActions(Skill.FISHING);
        if (actions > 0) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Caught fish:").right(Integer.toString(actions)).build());
            if (actions > 2) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Fish/hr:").right(Integer.toString(this.xpTrackerService.getActionsHr(Skill.FISHING))).build());
            }
        }
        return this.panelComponent.render(graphics);
    }
}

