/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.fightcaves;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.client.plugins.fightcaves.FightCavesConfig;
import net.runelite.client.plugins.fightcaves.FightCavesPlugin;
import net.runelite.client.plugins.fightcaves.WaveDisplayMode;
import net.runelite.client.plugins.fightcaves.WaveMonster;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

class WaveOverlay
extends Overlay {
    private static final Color HEADER_COLOR = ColorScheme.BRAND_ORANGE;
    private final FightCavesConfig config;
    private final FightCavesPlugin plugin;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private WaveOverlay(FightCavesConfig config, FightCavesPlugin plugin) {
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.config = config;
        this.plugin = plugin;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Map waveContents;
        if (!this.plugin.inFightCave() || this.plugin.getCurrentWave() < 0) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        int currentWave = this.plugin.getCurrentWave();
        int waveIndex = currentWave - 1;
        if (this.config.waveDisplay() == WaveDisplayMode.CURRENT || this.config.waveDisplay() == WaveDisplayMode.BOTH) {
            waveContents = FightCavesPlugin.getWAVES().get(waveIndex);
            this.addWaveInfo("Wave " + this.plugin.getCurrentWave(), waveContents);
        }
        if ((this.config.waveDisplay() == WaveDisplayMode.NEXT || this.config.waveDisplay() == WaveDisplayMode.BOTH) && currentWave != 63) {
            waveContents = FightCavesPlugin.getWAVES().get(waveIndex + 1);
            this.addWaveInfo("Next wave", waveContents);
        }
        return this.panelComponent.render(graphics);
    }

    private void addWaveInfo(String headerText, Map<WaveMonster, Integer> waveContents) {
        this.panelComponent.getChildren().add(TitleComponent.builder().text(headerText).color(HEADER_COLOR).build());
        for (LineComponent line : WaveOverlay.buildWaveLines(waveContents)) {
            this.panelComponent.getChildren().add(line);
        }
    }

    private static Collection<LineComponent> buildWaveLines(Map<WaveMonster, Integer> wave) {
        ArrayList<Map.Entry<WaveMonster, Integer>> monsters = new ArrayList<Map.Entry<WaveMonster, Integer>>(wave.entrySet());
        monsters.sort(Map.Entry.comparingByKey());
        ArrayList<LineComponent> outputLines = new ArrayList<LineComponent>();
        for (Map.Entry entry : monsters) {
            WaveMonster monster = (WaveMonster)((Object)entry.getKey());
            int quantity = (Integer)entry.getValue();
            LineComponent line = LineComponent.builder().left(FightCavesPlugin.formatMonsterQuantity(monster, quantity)).build();
            outputLines.add(line);
        }
        return outputLines;
    }
}

