/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.fightcaves;

import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.fightcaves.FightCavesConfig;
import net.runelite.client.plugins.fightcaves.WaveMonster;
import net.runelite.client.plugins.fightcaves.WaveOverlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.apache.commons.lang3.ArrayUtils;

@PluginDescriptor(name="Fight Caves", description="Displays current and upcoming wave monsters in the Fight Caves", tags={"bosses", "combat", "minigame", "overlay", "pve", "pvm", "jad", "fire", "cape", "wave"}, enabledByDefault=false)
public class FightCavesPlugin
extends Plugin {
    private static final Pattern WAVE_PATTERN = Pattern.compile(".*Wave: (\\d+).*");
    private static final int FIGHT_CAVE_REGION = 9551;
    private static final int MAX_MONSTERS_OF_TYPE_PER_WAVE = 2;
    static final int MAX_WAVE = 63;
    static final List<EnumMap<WaveMonster, Integer>> WAVES = new ArrayList<EnumMap<WaveMonster, Integer>>();
    private int currentWave = -1;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private WaveOverlay waveOverlay;

    @Provides
    FightCavesConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(FightCavesConfig.class);
    }

    @Override
    public void startUp() {
        this.overlayManager.add(this.waveOverlay);
    }

    @Override
    public void shutDown() {
        this.overlayManager.remove(this.waveOverlay);
        this.currentWave = -1;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (!this.inFightCave()) {
            this.currentWave = -1;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Matcher waveMatcher = WAVE_PATTERN.matcher(event.getMessage());
        if (event.getType() != ChatMessageType.GAMEMESSAGE || !this.inFightCave() || !waveMatcher.matches()) {
            return;
        }
        this.currentWave = Integer.parseInt(waveMatcher.group(1));
    }

    boolean inFightCave() {
        return ArrayUtils.contains(this.client.getMapRegions(), 9551);
    }

    static String formatMonsterQuantity(WaveMonster monster, int quantity) {
        return String.format("%dx %s", new Object[]{quantity, monster});
    }

    public static List<EnumMap<WaveMonster, Integer>> getWAVES() {
        return WAVES;
    }

    public int getCurrentWave() {
        return this.currentWave;
    }

    static {
        WaveMonster[] waveMonsters = WaveMonster.values();
        EnumMap<WaveMonster, Integer> waveOne = new EnumMap<WaveMonster, Integer>(WaveMonster.class);
        waveOne.put(waveMonsters[0], 1);
        WAVES.add(waveOne);
        for (int wave = 1; wave < 63; ++wave) {
            Object prevWave = WAVES.get(wave - 1).clone();
            int maxMonsterOrdinal = -1;
            for (int i = 0; i < waveMonsters.length; ++i) {
                int ordinalMonsterQuantity = prevWave.getOrDefault((Object)waveMonsters[i], 0);
                if (ordinalMonsterQuantity != 2) continue;
                maxMonsterOrdinal = i;
                break;
            }
            if (maxMonsterOrdinal >= 0) {
                ((EnumMap)prevWave).remove((Object)waveMonsters[maxMonsterOrdinal]);
            }
            int addedMonsterOrdinal = maxMonsterOrdinal >= 0 ? maxMonsterOrdinal + 1 : 0;
            WaveMonster addedMonster = waveMonsters[addedMonsterOrdinal];
            int addedMonsterQuantity = prevWave.getOrDefault((Object)addedMonster, 0);
            ((EnumMap)prevWave).put(addedMonster, addedMonsterQuantity + 1);
            WAVES.add((EnumMap<WaveMonster, Integer>)prevWave);
        }
    }
}

