/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.experiencedrop;

import com.google.inject.Provides;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.Varbits;
import net.runelite.api.events.ExperienceChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetHiddenChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.experiencedrop.DefaultColors;
import net.runelite.client.plugins.experiencedrop.PrayerType;
import net.runelite.client.plugins.experiencedrop.XpDropConfig;
import net.runelite.client.plugins.experiencedrop.XpPrayer;

@PluginDescriptor(name="XP Drop", description="Enable customization of the way XP drops are displayed", tags={"experience", "levels", "tick"})
public class XpDropPlugin
extends Plugin {
    private static final int XPDROP_PADDING = 2;
    @Inject
    private Client client;
    @Inject
    private XpDropConfig config;
    private int tickCounter = 0;
    private int previousExpGained;
    private boolean hasDropped = false;
    private boolean correctPrayer;
    private Skill lastSkill = null;
    private Map<Skill, Integer> previousSkillExpTable = new EnumMap<Skill, Integer>(Skill.class);
    private PrayerType currentTickPrayer;

    @Provides
    XpDropConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(XpDropConfig.class);
    }

    @Subscribe
    public void onWidgetHiddenChanged(WidgetHiddenChanged event) {
        PrayerType prayer;
        Widget widget = event.getWidget();
        int group = WidgetInfo.TO_GROUP(widget.getId());
        if (group != 122) {
            return;
        }
        if (widget.isHidden()) {
            return;
        }
        if (this.config.hideSkillIcons()) {
            if (widget.getSpriteId() > 0) {
                widget.setHidden(true);
                return;
            }
            if (!widget.getText().isEmpty()) {
                int width = 0;
                for (Widget w : widget.getParent().getDynamicChildren()) {
                    if (w.getSpriteId() == -1) continue;
                    if (width > 0) {
                        width += 2;
                    }
                    width += w.getWidth();
                }
                int xpDropPosition = this.client.getVar(Varbits.EXPERIENCE_TRACKER_POSITION);
                switch (xpDropPosition) {
                    case 2: {
                        int cur = widget.getRelativeX();
                        widget.setRelativeX(cur -= width);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        int cur = widget.getRelativeX();
                        widget.setRelativeX(cur -= width / 2);
                    }
                }
            }
        }
        if ((prayer = this.currentTickPrayer) == null) {
            this.resetTextColor(widget);
            return;
        }
        String text = widget.getText();
        IntStream spriteIDs = Arrays.stream(widget.getParent().getDynamicChildren()).mapToInt(Widget::getSpriteId);
        if (text != null) {
            int color = widget.getTextColor();
            switch (prayer) {
                case MELEE: {
                    if (!spriteIDs.anyMatch(id -> id == 197 || id == 198 || id == 199 || this.correctPrayer)) break;
                    color = this.config.getMeleePrayerColor().getRGB();
                    this.correctPrayer = true;
                    break;
                }
                case RANGE: {
                    if (!spriteIDs.anyMatch(id -> id == 200 || this.correctPrayer)) break;
                    color = this.config.getRangePrayerColor().getRGB();
                    this.correctPrayer = true;
                    break;
                }
                case MAGIC: {
                    if (!spriteIDs.anyMatch(id -> id == 202 || this.correctPrayer)) break;
                    color = this.config.getMagePrayerColor().getRGB();
                    this.correctPrayer = true;
                }
            }
            widget.setTextColor(color);
        }
    }

    private void resetTextColor(Widget widget) {
        int defaultColorIdx = this.client.getVar(Varbits.EXPERIENCE_DROP_COLOR);
        int defaultColor = DefaultColors.values()[defaultColorIdx].getColor().getRGB();
        widget.setTextColor(defaultColor);
    }

    private PrayerType getActivePrayerType() {
        for (XpPrayer prayer : XpPrayer.values()) {
            if (!this.client.isPrayerActive(prayer.getPrayer())) continue;
            return prayer.getType();
        }
        return null;
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.currentTickPrayer = this.getActivePrayerType();
        this.correctPrayer = false;
        int fakeTickDelay = this.config.fakeXpDropDelay();
        if (fakeTickDelay == 0 || this.lastSkill == null) {
            return;
        }
        if (this.hasDropped) {
            this.hasDropped = false;
            this.tickCounter = 0;
            return;
        }
        if (++this.tickCounter % fakeTickDelay != 0) {
            return;
        }
        this.client.runScript(2091, this.lastSkill.ordinal(), this.previousExpGained);
    }

    @Subscribe
    public void onExperienceChanged(ExperienceChanged event) {
        Skill skill = event.getSkill();
        int xp = this.client.getSkillExperience(skill);
        this.lastSkill = skill;
        Integer previous = this.previousSkillExpTable.put(skill, xp);
        if (previous != null) {
            this.previousExpGained = xp - previous;
            this.hasDropped = true;
        }
    }
}

