/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.examine;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.examine.CacheKey;
import net.runelite.client.plugins.examine.ExamineType;
import net.runelite.client.plugins.examine.PendingExamine;
import net.runelite.client.util.StackFormatter;
import net.runelite.http.api.examine.ExamineClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Examine", description="Send examine information to the API", tags={"npcs", "items", "inventory", "objects"})
public class ExaminePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ExaminePlugin.class);
    private static final float HIGH_ALCHEMY_CONSTANT = 0.6f;
    private static final Pattern X_PATTERN = Pattern.compile("^\\d+ x ");
    private final Deque<PendingExamine> pending = new ArrayDeque<PendingExamine>();
    private final Cache<CacheKey, Boolean> cache = CacheBuilder.newBuilder().maximumSize(128L).build();
    @Inject
    private ExamineClient examineClient;
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ScheduledExecutorService executor;

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.pending.clear();
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        int id;
        ExamineType type;
        if (!event.getMenuOption().equals("Examine")) {
            return;
        }
        int quantity = -1;
        switch (event.getMenuAction()) {
            case EXAMINE_ITEM: {
                type = ExamineType.ITEM;
                id = event.getId();
                int widgetId = event.getWidgetId();
                int widgetGroup = WidgetInfo.TO_GROUP(widgetId);
                int widgetChild = WidgetInfo.TO_CHILD(widgetId);
                Widget widget = this.client.getWidget(widgetGroup, widgetChild);
                WidgetItem widgetItem = widget.getWidgetItem(event.getActionParam());
                quantity = widgetItem != null ? widgetItem.getQuantity() : 1;
                break;
            }
            case EXAMINE_ITEM_BANK_EQ: {
                type = ExamineType.ITEM_BANK_EQ;
                int[] qi = this.findItemFromWidget(event.getWidgetId(), event.getActionParam());
                if (qi == null) {
                    log.debug("Examine for item with unknown widget: {}", (Object)event);
                    return;
                }
                quantity = qi[0];
                id = qi[1];
                break;
            }
            case EXAMINE_OBJECT: {
                type = ExamineType.OBJECT;
                id = event.getId();
                break;
            }
            case EXAMINE_NPC: {
                type = ExamineType.NPC;
                id = event.getId();
                break;
            }
            default: {
                return;
            }
        }
        PendingExamine pendingExamine = new PendingExamine();
        pendingExamine.setType(type);
        pendingExamine.setId(id);
        pendingExamine.setQuantity(quantity);
        pendingExamine.setCreated(Instant.now());
        this.pending.push(pendingExamine);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        ItemComposition itemComposition;
        ExamineType type;
        switch (event.getType()) {
            case ITEM_EXAMINE: {
                type = ExamineType.ITEM;
                break;
            }
            case OBJECT_EXAMINE: {
                type = ExamineType.OBJECT;
                break;
            }
            case NPC_EXAMINE: {
                type = ExamineType.NPC;
                break;
            }
            case GAMEMESSAGE: {
                type = ExamineType.ITEM_BANK_EQ;
                break;
            }
            default: {
                return;
            }
        }
        if (this.pending.isEmpty()) {
            log.debug("Got examine without a pending examine?");
            return;
        }
        PendingExamine pendingExamine = this.pending.pop();
        if (pendingExamine.getType() != type) {
            log.debug("Type mismatch for pending examine: {} != {}", (Object)pendingExamine.getType(), (Object)type);
            this.pending.clear();
            return;
        }
        log.debug("Got examine for {} {}: {}", new Object[]{pendingExamine.getType(), pendingExamine.getId(), event.getMessage()});
        if (pendingExamine.getType() == ExamineType.ITEM || pendingExamine.getType() == ExamineType.ITEM_BANK_EQ) {
            int itemId = pendingExamine.getId();
            int itemQuantity = pendingExamine.getQuantity();
            itemComposition = this.itemManager.getItemComposition(itemId);
            if (itemComposition != null) {
                int id = this.itemManager.canonicalize(itemComposition.getId());
                this.executor.submit(() -> this.getItemPrice(id, itemComposition, itemQuantity));
            }
        } else {
            itemComposition = null;
        }
        if (itemComposition != null && itemComposition.isTradeable()) {
            return;
        }
        if (type == ExamineType.ITEM && X_PATTERN.matcher(event.getMessage()).lookingAt()) {
            return;
        }
        CacheKey key = new CacheKey(type, pendingExamine.getId());
        Boolean cached = this.cache.getIfPresent(key);
        if (cached != null) {
            return;
        }
        this.cache.put(key, Boolean.TRUE);
    }

    private int[] findItemFromWidget(int widgetId, int actionParam) {
        Widget[] children;
        int widgetChild;
        int widgetGroup = WidgetInfo.TO_GROUP(widgetId);
        Widget widget = this.client.getWidget(widgetGroup, widgetChild = WidgetInfo.TO_CHILD(widgetId));
        if (widget == null) {
            return null;
        }
        if (WidgetInfo.EQUIPMENT.getGroupId() == widgetGroup) {
            Widget widgetItem = widget.getChild(1);
            if (widgetItem != null) {
                return new int[]{widgetItem.getItemQuantity(), widgetItem.getItemId()};
            }
        } else if (WidgetInfo.SMITHING_INVENTORY_ITEMS_CONTAINER.getGroupId() == widgetGroup) {
            Widget widgetItem = widget.getChild(2);
            if (widgetItem != null) {
                return new int[]{widgetItem.getItemQuantity(), widgetItem.getItemId()};
            }
        } else if (WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER.getGroupId() == widgetGroup || WidgetInfo.RUNE_POUCH_ITEM_CONTAINER.getGroupId() == widgetGroup) {
            Widget widgetItem = widget.getChild(actionParam);
            if (widgetItem != null) {
                return new int[]{widgetItem.getItemQuantity(), widgetItem.getItemId()};
            }
        } else if (WidgetInfo.BANK_ITEM_CONTAINER.getGroupId() == widgetGroup) {
            Widget[] children2 = widget.getDynamicChildren();
            if (actionParam < children2.length) {
                Widget widgetItem = children2[actionParam];
                return new int[]{widgetItem.getItemQuantity(), widgetItem.getItemId()};
            }
        } else if (WidgetInfo.SHOP_ITEMS_CONTAINER.getGroupId() == widgetGroup) {
            Widget[] children3 = widget.getDynamicChildren();
            if (actionParam < children3.length) {
                Widget widgetItem = children3[actionParam];
                return new int[]{1, widgetItem.getItemId()};
            }
        } else if (WidgetInfo.CLUE_SCROLL_REWARD_ITEM_CONTAINER.getGroupId() == widgetGroup) {
            Widget[] children4 = widget.getDynamicChildren();
            if (actionParam < children4.length) {
                Widget widgetItem = children4[actionParam];
                return new int[]{widgetItem.getItemQuantity(), widgetItem.getItemId()};
            }
        } else if (WidgetInfo.LOOTING_BAG_CONTAINER.getGroupId() == widgetGroup && actionParam < (children = widget.getDynamicChildren()).length) {
            Widget widgetItem = children[actionParam];
            return new int[]{widgetItem.getItemQuantity(), widgetItem.getItemId()};
        }
        return null;
    }

    private void getItemPrice(int id, ItemComposition itemComposition, int quantity) {
        int alchPrice;
        quantity = Math.max(1, quantity);
        int itemCompositionPrice = itemComposition.getPrice();
        int gePrice = this.itemManager.getItemPrice(id);
        int n = alchPrice = itemCompositionPrice <= 0 ? 0 : Math.round((float)itemCompositionPrice * 0.6f);
        if (gePrice > 0 || alchPrice > 0) {
            ChatMessageBuilder message = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Price of ").append(ChatColorType.HIGHLIGHT);
            if (quantity > 1) {
                message.append(StackFormatter.formatNumber(quantity)).append(" x ");
            }
            message.append(itemComposition.getName()).append(ChatColorType.NORMAL).append(":");
            if (gePrice > 0) {
                message.append(ChatColorType.NORMAL).append(" GE average ").append(ChatColorType.HIGHLIGHT).append(StackFormatter.formatNumber(gePrice * quantity));
                if (quantity > 1) {
                    message.append(ChatColorType.NORMAL).append(" (").append(ChatColorType.HIGHLIGHT).append(StackFormatter.formatNumber(gePrice)).append(ChatColorType.NORMAL).append("ea)");
                }
            }
            if (alchPrice > 0) {
                message.append(ChatColorType.NORMAL).append(" HA value ").append(ChatColorType.HIGHLIGHT).append(StackFormatter.formatNumber(alchPrice * quantity));
                if (quantity > 1) {
                    message.append(ChatColorType.NORMAL).append(" (").append(ChatColorType.HIGHLIGHT).append(StackFormatter.formatNumber(alchPrice)).append(ChatColorType.NORMAL).append("ea)");
                }
            }
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.ITEM_EXAMINE).runeLiteFormattedMessage(message.build()).build());
        }
    }

    private void submitExamine(PendingExamine examine, String text) {
        int id = examine.getId();
        switch (examine.getType()) {
            case ITEM: {
                this.examineClient.submitItem(id, text);
                break;
            }
            case OBJECT: {
                this.examineClient.submitObject(id, text);
                break;
            }
            case NPC: {
                this.examineClient.submitNpc(id, text);
            }
        }
    }
}

