/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.entityhider;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.entityhider.EntityHiderConfig;

@PluginDescriptor(name="Entity Hider", description="Hide players, NPCs, and/or projectiles", tags={"npcs", "players", "projectiles"}, enabledByDefault=false)
public class EntityHiderPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private EntityHiderConfig config;

    @Provides
    EntityHiderConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(EntityHiderConfig.class);
    }

    @Override
    protected void startUp() {
        this.updateConfig();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        this.updateConfig();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.client.setIsHidingEntities(this.isPlayerRegionAllowed());
        }
    }

    private void updateConfig() {
        this.client.setIsHidingEntities(this.isPlayerRegionAllowed());
        this.client.setPlayersHidden(this.config.hidePlayers());
        this.client.setPlayersHidden2D(this.config.hidePlayers2D());
        this.client.setFriendsHidden(this.config.hideFriends());
        this.client.setClanMatesHidden(this.config.hideClanMates());
        this.client.setLocalPlayerHidden(this.config.hideLocalPlayer());
        this.client.setLocalPlayerHidden2D(this.config.hideLocalPlayer2D());
        this.client.setNPCsHidden(this.config.hideNPCs());
        this.client.setNPCsHidden2D(this.config.hideNPCs2D());
        this.client.setAttackersHidden(this.config.hideAttackers());
        this.client.setProjectilesHidden(this.config.hideProjectiles());
    }

    @Override
    protected void shutDown() throws Exception {
        this.client.setIsHidingEntities(false);
        this.client.setPlayersHidden(false);
        this.client.setPlayersHidden2D(false);
        this.client.setFriendsHidden(false);
        this.client.setClanMatesHidden(false);
        this.client.setLocalPlayerHidden(false);
        this.client.setLocalPlayerHidden2D(false);
        this.client.setNPCsHidden(false);
        this.client.setNPCsHidden2D(false);
        this.client.setAttackersHidden(false);
        this.client.setProjectilesHidden(false);
    }

    private boolean isPlayerRegionAllowed() {
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null) {
            return true;
        }
        int playerRegionID = WorldPoint.fromLocalInstance(this.client, localPlayer.getLocalLocation()).getRegionID();
        return playerRegionID != 9520;
    }
}

