/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.emojis;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.inject.Inject;
import joptsimple.internal.Strings;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IndexedSprite;
import net.runelite.api.MessageNode;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.emojis.Emoji;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Emojis", description="Replaces common emoticons such as :) with their corresponding emoji in the chat", enabledByDefault=false)
public class EmojiPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EmojiPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    private int modIconsStart = -1;

    @Override
    protected void startUp() {
        this.loadEmojiIcons();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.loadEmojiIcons();
        }
    }

    private void loadEmojiIcons() {
        IndexedSprite[] modIcons = this.client.getModIcons();
        if (this.modIconsStart != -1 || modIcons == null) {
            return;
        }
        Emoji[] emojis = Emoji.values();
        IndexedSprite[] newModIcons = Arrays.copyOf(modIcons, modIcons.length + emojis.length);
        this.modIconsStart = modIcons.length;
        for (int i = 0; i < emojis.length; ++i) {
            Emoji emoji = emojis[i];
            try {
                IndexedSprite sprite;
                BufferedImage image = emoji.loadImage();
                newModIcons[this.modIconsStart + i] = sprite = ImageUtil.getImageIndexedSprite(image, this.client);
                continue;
            }
            catch (Exception ex) {
                log.warn("Failed to load the sprite for emoji " + emoji, ex);
            }
        }
        log.debug("Adding emoji icons");
        this.client.setModIcons(newModIcons);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.modIconsStart == -1) {
            return;
        }
        switch (chatMessage.getType()) {
            case PUBLICCHAT: 
            case MODCHAT: 
            case FRIENDSCHAT: 
            case PRIVATECHAT: 
            case PRIVATECHATOUT: 
            case MODPRIVATECHAT: {
                break;
            }
            default: {
                return;
            }
        }
        String message = chatMessage.getMessage();
        String updatedMessage = this.updateMessage(message);
        if (updatedMessage == null) {
            return;
        }
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(updatedMessage);
        this.chatMessageManager.update(messageNode);
        this.client.refreshChat();
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (!(event.getActor() instanceof Player)) {
            return;
        }
        String message = event.getOverheadText();
        String updatedMessage = this.updateMessage(message);
        if (updatedMessage == null) {
            return;
        }
        event.getActor().setOverheadText(updatedMessage);
    }

    @Nullable
    private String updateMessage(String message) {
        String[] messageWords = message.split(" ");
        boolean editedMessage = false;
        for (int i = 0; i < messageWords.length; ++i) {
            Emoji emoji = Emoji.getEmoji(messageWords[i]);
            if (emoji == null) continue;
            int emojiId = this.modIconsStart + emoji.ordinal();
            messageWords[i] = "<img=" + emojiId + ">";
            editedMessage = true;
        }
        if (!editedMessage) {
            return null;
        }
        return Strings.join(messageWords, " ");
    }
}

