/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.discord;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ComparisonChain;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.discord.DiscordPresence;
import net.runelite.client.discord.DiscordService;
import net.runelite.client.plugins.discord.DiscordConfig;
import net.runelite.client.plugins.discord.DiscordGameEventType;
import net.runelite.client.ws.PartyService;

class DiscordState {
    private final UUID partyId = UUID.randomUUID();
    private final List<EventWithTime> events = new ArrayList<EventWithTime>();
    private final DiscordService discordService;
    private final DiscordConfig config;
    private PartyService party;
    private final RuneLiteProperties properties;
    private DiscordPresence lastPresence;

    @Inject
    private DiscordState(DiscordService discordService, DiscordConfig config, PartyService party, RuneLiteProperties properties) {
        this.discordService = discordService;
        this.config = config;
        this.party = party;
        this.properties = properties;
    }

    void reset() {
        this.discordService.clearPresence();
        this.events.clear();
        this.lastPresence = null;
    }

    void refresh() {
        if (this.lastPresence == null) {
            return;
        }
        DiscordPresence.DiscordPresenceBuilder presenceBuilder = DiscordPresence.builder().state(this.lastPresence.getState()).details(this.lastPresence.getDetails()).largeImageText(this.lastPresence.getLargeImageText()).startTimestamp(this.lastPresence.getStartTimestamp()).smallImageKey(this.lastPresence.getSmallImageKey()).partyMax(this.lastPresence.getPartyMax()).partySize(this.party.getMembers().size());
        if (this.party.isOwner()) {
            presenceBuilder.partyId(this.partyId.toString());
            presenceBuilder.joinSecret(this.party.getPartyId().toString());
        }
        this.discordService.updatePresence(presenceBuilder.build());
    }

    void triggerEvent(DiscordGameEventType eventType) {
        DiscordPresence presence;
        EventWithTime event;
        Optional<EventWithTime> foundEvent = this.events.stream().filter(e -> e.type == eventType).findFirst();
        if (foundEvent.isPresent()) {
            event = foundEvent.get();
        } else {
            event = new EventWithTime(eventType, this.config.hideElapsedTime() ? null : Instant.now());
            this.events.add(event);
        }
        event.setUpdated(Instant.now());
        if (event.getType().isShouldClear()) {
            this.events.removeIf(e -> e.getType() != eventType && e.getType().isShouldClear());
        }
        this.events.sort((a, b) -> ComparisonChain.start().compare(b.getType().getPriority(), a.getType().getPriority()).compare(b.getUpdated(), a.getUpdated()).result());
        event = this.events.get(0);
        String imageKey = null;
        String state = null;
        String details = null;
        for (EventWithTime eventWithTime : this.events) {
            if (imageKey == null) {
                imageKey = eventWithTime.getType().getImageKey();
            }
            if (details == null) {
                details = eventWithTime.getType().getDetails();
            }
            if (state == null) {
                state = eventWithTime.getType().getState();
            }
            if (imageKey == null || details == null || state == null) continue;
            break;
        }
        String versionShortHand = this.properties.getVersion().replace("-SNAPSHOT", "+");
        details = "zenyte.com";
        DiscordPresence.DiscordPresenceBuilder presenceBuilder = DiscordPresence.builder().state(MoreObjects.firstNonNull(state, "")).details(MoreObjects.firstNonNull(details, "")).largeImageText(this.properties.getTitle() + " v" + versionShortHand).startTimestamp(event.getStart()).smallImageKey(imageKey).partyMax(15).partySize(this.party.getMembers().size());
        if (this.party.isOwner()) {
            presenceBuilder.partyId(this.partyId.toString());
            presenceBuilder.joinSecret(this.party.getPartyId().toString());
        }
        if (!(presence = presenceBuilder.build()).equals(this.lastPresence)) {
            this.lastPresence = presence;
            this.discordService.updatePresence(presence);
        }
    }

    void checkForTimeout() {
        Duration actionTimeout = Duration.ofMinutes(this.config.actionTimeout());
        Instant now = Instant.now();
        this.events.removeIf(event -> event.getType().isShouldTimeout() && now.isAfter(event.getUpdated().plus(actionTimeout)));
    }

    private class EventWithTime {
        private final DiscordGameEventType type;
        private final Instant start;
        private Instant updated;

        public EventWithTime(DiscordGameEventType type, Instant start) {
            this.type = type;
            this.start = start;
        }

        public DiscordGameEventType getType() {
            return this.type;
        }

        public Instant getStart() {
            return this.start;
        }

        public Instant getUpdated() {
            return this.updated;
        }

        public void setUpdated(Instant updated) {
            this.updated = updated;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventWithTime)) {
                return false;
            }
            EventWithTime other = (EventWithTime)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DiscordGameEventType this$type = this.getType();
            DiscordGameEventType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Instant this$start = this.getStart();
            Instant other$start = other.getStart();
            if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
                return false;
            }
            Instant this$updated = this.getUpdated();
            Instant other$updated = other.getUpdated();
            return !(this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EventWithTime;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DiscordGameEventType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Instant $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
            Instant $updated = this.getUpdated();
            result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
            return result;
        }

        public String toString() {
            return "DiscordState.EventWithTime(type=" + this.getType() + ", start=" + this.getStart() + ", updated=" + this.getUpdated() + ")";
        }
    }
}

