/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.devtools;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.runelite.api.Client;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.devtools.DevToolsConfig;
import net.runelite.client.plugins.devtools.DevToolsOverlay;
import net.runelite.client.plugins.devtools.DevToolsPlugin;
import net.runelite.client.plugins.devtools.WidgetInfoTableModel;
import net.runelite.client.plugins.devtools.WidgetItemNode;
import net.runelite.client.plugins.devtools.WidgetTreeNode;
import net.runelite.client.ui.ClientUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WidgetInspector
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(WidgetInspector.class);
    private final Client client;
    private final ClientThread clientThread;
    private final DevToolsConfig config;
    private final DevToolsOverlay overlay;
    private final DevToolsPlugin plugin;
    private final JTree widgetTree;
    private final WidgetInfoTableModel infoTableModel;
    private final JCheckBox alwaysOnTop;
    private static final Map<Integer, WidgetInfo> widgetIdMap = new HashMap<Integer, WidgetInfo>();

    @Inject
    private WidgetInspector(Client client2, ClientThread clientThread, WidgetInfoTableModel infoTableModel, DevToolsConfig config, EventBus eventBus, DevToolsOverlay overlay, final DevToolsPlugin plugin) {
        this.client = client2;
        this.clientThread = clientThread;
        this.infoTableModel = infoTableModel;
        this.config = config;
        this.overlay = overlay;
        this.plugin = plugin;
        eventBus.register(this);
        this.setTitle("RuneLite Widget Inspector");
        this.setIconImage(ClientUI.ICON);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WidgetInspector.this.close();
                plugin.getWidgetInspector().setActive(false);
            }
        });
        this.setLayout(new BorderLayout());
        this.widgetTree = new JTree(new DefaultMutableTreeNode());
        this.widgetTree.setRootVisible(false);
        this.widgetTree.setShowsRootHandles(true);
        this.widgetTree.getSelectionModel().addTreeSelectionListener(e -> {
            Object selected = this.widgetTree.getLastSelectedPathComponent();
            if (selected instanceof WidgetTreeNode) {
                WidgetTreeNode node = (WidgetTreeNode)selected;
                Widget widget = node.getWidget();
                overlay.setWidget(widget);
                overlay.setItemIndex(widget.getItemId());
                this.refreshInfo();
                log.debug("Set widget to {} and item index to {}", (Object)widget, (Object)widget.getItemId());
            } else if (selected instanceof WidgetItemNode) {
                WidgetItemNode node = (WidgetItemNode)selected;
                overlay.setItemIndex(node.getWidgetItem().getIndex());
                log.debug("Set item index to {}", (Object)node.getWidgetItem().getIndex());
            }
        });
        JScrollPane treeScrollPane = new JScrollPane(this.widgetTree);
        treeScrollPane.setPreferredSize(new Dimension(200, 400));
        JTable widgetInfo = new JTable(infoTableModel);
        JScrollPane infoScrollPane = new JScrollPane(widgetInfo);
        infoScrollPane.setPreferredSize(new Dimension(400, 400));
        JPanel bottomPanel = new JPanel();
        this.add((Component)bottomPanel, "South");
        JButton refreshWidgetsBtn = new JButton("Refresh");
        refreshWidgetsBtn.addActionListener(e -> this.refreshWidgets());
        bottomPanel.add(refreshWidgetsBtn);
        this.alwaysOnTop = new JCheckBox("Always on top");
        this.alwaysOnTop.addItemListener(ev -> config.inspectorAlwaysOnTop(this.alwaysOnTop.isSelected()));
        this.onConfigChanged(null);
        bottomPanel.add(this.alwaysOnTop);
        JButton revalidateWidget = new JButton("Revalidate");
        revalidateWidget.addActionListener(ev -> clientThread.invokeLater(() -> {
            if (overlay.getWidget() == null) {
                return;
            }
            overlay.getWidget().revalidate();
        }));
        bottomPanel.add(revalidateWidget);
        JSplitPane split = new JSplitPane(1, treeScrollPane, infoScrollPane);
        this.add((Component)split, "Center");
        this.pack();
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged ev) {
        boolean onTop = this.config.inspectorAlwaysOnTop();
        this.setAlwaysOnTop(onTop);
        this.alwaysOnTop.setSelected(onTop);
    }

    private void refreshWidgets() {
        this.clientThread.invokeLater(() -> {
            Widget[] rootWidgets = this.client.getWidgetRoots();
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            this.overlay.setWidget(null);
            this.overlay.setItemIndex(-1);
            for (Widget widget : rootWidgets) {
                DefaultMutableTreeNode childNode = this.addWidget("R", widget);
                if (childNode == null) continue;
                root.add(childNode);
            }
            SwingUtilities.invokeLater(() -> {
                this.overlay.setWidget(null);
                this.overlay.setItemIndex(-1);
                this.refreshInfo();
                this.widgetTree.setModel(new DefaultTreeModel(root));
            });
        });
    }

    private DefaultMutableTreeNode addWidget(String type, Widget widget) {
        Collection<WidgetItem> items;
        DefaultMutableTreeNode childNode;
        if (widget == null || widget.isHidden()) {
            return null;
        }
        WidgetTreeNode node = new WidgetTreeNode(type, widget);
        Widget[] childComponents = widget.getDynamicChildren();
        if (childComponents != null) {
            for (Widget component : childComponents) {
                childNode = this.addWidget("D", component);
                if (childNode == null) continue;
                node.add(childNode);
            }
        }
        if ((childComponents = widget.getStaticChildren()) != null) {
            for (Widget component : childComponents) {
                childNode = this.addWidget("S", component);
                if (childNode == null) continue;
                node.add(childNode);
            }
        }
        if ((childComponents = widget.getNestedChildren()) != null) {
            for (Widget component : childComponents) {
                childNode = this.addWidget("N", component);
                if (childNode == null) continue;
                node.add(childNode);
            }
        }
        if ((items = widget.getWidgetItems()) != null) {
            for (WidgetItem item : items) {
                if (item == null) continue;
                node.add(new WidgetItemNode(item));
            }
        }
        return node;
    }

    private void refreshInfo() {
        this.infoTableModel.setWidget(this.overlay.getWidget());
    }

    static WidgetInfo getWidgetInfo(int packedId) {
        if (widgetIdMap.isEmpty()) {
            WidgetInfo[] widgets;
            for (WidgetInfo w : widgets = WidgetInfo.values()) {
                widgetIdMap.put(w.getPackedId(), w);
            }
        }
        return widgetIdMap.get(packedId);
    }

    public void open() {
        this.setVisible(true);
        this.toFront();
        this.repaint();
    }

    public void close() {
        this.overlay.setWidget(null);
        this.overlay.setItemIndex(-1);
        this.setVisible(false);
    }
}

