/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.devtools;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.BoostedLevelChanged;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.ExperienceChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.kit.KitType;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.devtools.CameraOverlay;
import net.runelite.client.plugins.devtools.DevToolsButton;
import net.runelite.client.plugins.devtools.DevToolsConfig;
import net.runelite.client.plugins.devtools.DevToolsOverlay;
import net.runelite.client.plugins.devtools.DevToolsPanel;
import net.runelite.client.plugins.devtools.LocationOverlay;
import net.runelite.client.plugins.devtools.SceneOverlay;
import net.runelite.client.plugins.devtools.WorldMapLocationOverlay;
import net.runelite.client.plugins.devtools.WorldMapRegionOverlay;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Developer Tools", tags={"panel"}, developerPlugin=true)
public class DevToolsPlugin
extends Plugin {
    private static final List<MenuAction> EXAMINE_MENU_ACTIONS = ImmutableList.of(MenuAction.EXAMINE_ITEM, MenuAction.EXAMINE_ITEM_GROUND, MenuAction.EXAMINE_NPC, MenuAction.EXAMINE_OBJECT);
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private DevToolsOverlay overlay;
    @Inject
    private LocationOverlay locationOverlay;
    @Inject
    private SceneOverlay sceneOverlay;
    @Inject
    private CameraOverlay cameraOverlay;
    @Inject
    private WorldMapLocationOverlay worldMapLocationOverlay;
    @Inject
    private WorldMapRegionOverlay mapRegionOverlay;
    @Inject
    private EventBus eventBus;
    private DevToolsButton players;
    private DevToolsButton npcs;
    private DevToolsButton groundItems;
    private DevToolsButton groundObjects;
    private DevToolsButton gameObjects;
    private DevToolsButton graphicsObjects;
    private DevToolsButton walls;
    private DevToolsButton decorations;
    private DevToolsButton inventory;
    private DevToolsButton projectiles;
    private DevToolsButton location;
    private DevToolsButton chunkBorders;
    private DevToolsButton mapSquares;
    private DevToolsButton validMovement;
    private DevToolsButton lineOfSight;
    private DevToolsButton cameraPosition;
    private DevToolsButton worldMapLocation;
    private DevToolsButton tileLocation;
    private DevToolsButton interacting;
    private DevToolsButton examine;
    private DevToolsButton detachedCamera;
    private DevToolsButton widgetInspector;
    private DevToolsButton varInspector;
    private NavigationButton navButton;

    @Provides
    DevToolsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(DevToolsConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.players = new DevToolsButton("Players");
        this.npcs = new DevToolsButton("NPCs");
        this.groundItems = new DevToolsButton("Ground Items");
        this.groundObjects = new DevToolsButton("Ground Objects");
        this.gameObjects = new DevToolsButton("Game Objects");
        this.graphicsObjects = new DevToolsButton("Graphics Objects");
        this.walls = new DevToolsButton("Walls");
        this.decorations = new DevToolsButton("Decorations");
        this.inventory = new DevToolsButton("Inventory");
        this.projectiles = new DevToolsButton("Projectiles");
        this.location = new DevToolsButton("Location");
        this.worldMapLocation = new DevToolsButton("World Map Location");
        this.tileLocation = new DevToolsButton("Tile Location");
        this.cameraPosition = new DevToolsButton("Camera Position");
        this.chunkBorders = new DevToolsButton("Chunk Borders");
        this.mapSquares = new DevToolsButton("Map Squares");
        this.lineOfSight = new DevToolsButton("Line Of Sight");
        this.validMovement = new DevToolsButton("Valid Movement");
        this.interacting = new DevToolsButton("Interacting");
        this.examine = new DevToolsButton("Examine");
        this.detachedCamera = new DevToolsButton("Detached Camera");
        this.widgetInspector = new DevToolsButton("Widget Inspector");
        this.varInspector = new DevToolsButton("Var Inspector");
        this.overlayManager.add(this.overlay);
        this.overlayManager.add(this.locationOverlay);
        this.overlayManager.add(this.sceneOverlay);
        this.overlayManager.add(this.cameraOverlay);
        this.overlayManager.add(this.worldMapLocationOverlay);
        this.overlayManager.add(this.mapRegionOverlay);
        DevToolsPanel panel = this.injector.getInstance(DevToolsPanel.class);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), "devtools_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Developer Tools").icon(icon).priority(1).panel(panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.overlayManager.remove(this.locationOverlay);
        this.overlayManager.remove(this.sceneOverlay);
        this.overlayManager.remove(this.cameraOverlay);
        this.overlayManager.remove(this.worldMapLocationOverlay);
        this.overlayManager.remove(this.mapRegionOverlay);
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        String[] args = commandExecuted.getArguments();
        switch (commandExecuted.getCommand()) {
            case "logger": {
                String message;
                Logger logger = (Logger)LoggerFactory.getLogger("ROOT");
                Level currentLoggerLevel = logger.getLevel();
                if (args.length < 1) {
                    message = "Logger level is currently set to " + currentLoggerLevel;
                } else {
                    Level newLoggerLevel = Level.toLevel(args[0], currentLoggerLevel);
                    logger.setLevel(newLoggerLevel);
                    message = "Logger level has been set to " + newLoggerLevel;
                }
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, null);
                break;
            }
            case "getvarp": {
                int varp = Integer.parseInt(args[0]);
                int value = this.client.getVarpValue(this.client.getVarps(), varp);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "VarPlayer " + varp + ": " + value, null);
                break;
            }
            case "setvarp": {
                int varp = Integer.parseInt(args[0]);
                int value = Integer.parseInt(args[1]);
                this.client.setVarpValue(this.client.getVarps(), varp, value);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Set VarPlayer " + varp + " to " + value, null);
                VarbitChanged varbitChanged = new VarbitChanged();
                varbitChanged.setIndex(varp);
                this.eventBus.post(varbitChanged);
                break;
            }
            case "getvarb": {
                int varbit = Integer.parseInt(args[0]);
                int value = this.client.getVarbitValue(this.client.getVarps(), varbit);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Varbit " + varbit + ": " + value, null);
                break;
            }
            case "setvarb": {
                int varbit = Integer.parseInt(args[0]);
                int value = Integer.parseInt(args[1]);
                this.client.setVarbitValue(this.client.getVarps(), varbit, value);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Set varbit " + varbit + " to " + value, null);
                this.eventBus.post(new VarbitChanged());
                break;
            }
            case "addxp": {
                int level;
                Skill skill = Skill.valueOf(args[0].toUpperCase());
                int xp = Integer.parseInt(args[1]);
                int totalXp = this.client.getSkillExperience(skill) + xp;
                this.client.getBoostedSkillLevels()[skill.ordinal()] = level = Math.min(Experience.getLevelForXp(totalXp), 99);
                this.client.getRealSkillLevels()[skill.ordinal()] = level;
                this.client.getSkillExperiences()[skill.ordinal()] = totalXp;
                this.client.queueChangedSkill(skill);
                ExperienceChanged experienceChanged = new ExperienceChanged();
                experienceChanged.setSkill(skill);
                this.eventBus.post(experienceChanged);
                break;
            }
            case "setstat": {
                Skill skill = Skill.valueOf(args[0].toUpperCase());
                int level = Integer.parseInt(args[1]);
                level = Ints.constrainToRange(level, 1, 99);
                int xp = Experience.getXpForLevel(level);
                this.client.getBoostedSkillLevels()[skill.ordinal()] = level;
                this.client.getRealSkillLevels()[skill.ordinal()] = level;
                this.client.getSkillExperiences()[skill.ordinal()] = xp;
                this.client.queueChangedSkill(skill);
                ExperienceChanged experienceChanged = new ExperienceChanged();
                experienceChanged.setSkill(skill);
                this.eventBus.post(experienceChanged);
                BoostedLevelChanged boostedLevelChanged = new BoostedLevelChanged();
                boostedLevelChanged.setSkill(skill);
                this.eventBus.post(boostedLevelChanged);
                break;
            }
            case "anim": {
                int id = Integer.parseInt(args[0]);
                Player localPlayer = this.client.getLocalPlayer();
                localPlayer.setAnimation(id);
                localPlayer.setActionFrame(0);
                break;
            }
            case "gfx": {
                int id = Integer.parseInt(args[0]);
                Player localPlayer = this.client.getLocalPlayer();
                localPlayer.setGraphic(id);
                localPlayer.setSpotAnimFrame(0);
                break;
            }
            case "transform": {
                int id = Integer.parseInt(args[0]);
                Player player = this.client.getLocalPlayer();
                player.getPlayerComposition().setTransformedNpcId(id);
                player.setIdlePoseAnimation(-1);
                player.setPoseAnimation(-1);
                break;
            }
            case "cape": {
                int id = Integer.parseInt(args[0]);
                Player player = this.client.getLocalPlayer();
                player.getPlayerComposition().getEquipmentIds()[KitType.CAPE.getIndex()] = id + 512;
                player.getPlayerComposition().setHash();
                break;
            }
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (!this.examine.isActive()) {
            return;
        }
        MenuAction action = MenuAction.of(event.getType());
        if (EXAMINE_MENU_ACTIONS.contains((Object)action)) {
            MenuEntry[] entries = this.client.getMenuEntries();
            MenuEntry entry = entries[entries.length - 1];
            int identifier = event.getIdentifier();
            Object info = "ID: ";
            if (action == MenuAction.EXAMINE_NPC) {
                NPC npc = this.client.getCachedNPCs()[identifier];
                info = (String)info + npc.getId();
            } else {
                info = (String)info + identifier;
                if (action == MenuAction.EXAMINE_OBJECT) {
                    WorldPoint point = WorldPoint.fromScene(this.client, entry.getParam0(), entry.getParam1(), this.client.getPlane());
                    info = (String)info + " X: " + point.getX() + " Y: " + point.getY();
                }
            }
            entry.setTarget(entry.getTarget() + " " + ColorUtil.prependColorTag("(" + (String)info + ")", JagexColors.MENU_TARGET));
            this.client.setMenuEntries(entries);
        }
    }

    public Client getClient() {
        return this.client;
    }

    public ClientToolbar getClientToolbar() {
        return this.clientToolbar;
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public DevToolsOverlay getOverlay() {
        return this.overlay;
    }

    public LocationOverlay getLocationOverlay() {
        return this.locationOverlay;
    }

    public SceneOverlay getSceneOverlay() {
        return this.sceneOverlay;
    }

    public CameraOverlay getCameraOverlay() {
        return this.cameraOverlay;
    }

    public WorldMapLocationOverlay getWorldMapLocationOverlay() {
        return this.worldMapLocationOverlay;
    }

    public WorldMapRegionOverlay getMapRegionOverlay() {
        return this.mapRegionOverlay;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public DevToolsButton getPlayers() {
        return this.players;
    }

    public DevToolsButton getNpcs() {
        return this.npcs;
    }

    public DevToolsButton getGroundItems() {
        return this.groundItems;
    }

    public DevToolsButton getGroundObjects() {
        return this.groundObjects;
    }

    public DevToolsButton getGameObjects() {
        return this.gameObjects;
    }

    public DevToolsButton getGraphicsObjects() {
        return this.graphicsObjects;
    }

    public DevToolsButton getWalls() {
        return this.walls;
    }

    public DevToolsButton getDecorations() {
        return this.decorations;
    }

    public DevToolsButton getInventory() {
        return this.inventory;
    }

    public DevToolsButton getProjectiles() {
        return this.projectiles;
    }

    public DevToolsButton getLocation() {
        return this.location;
    }

    public DevToolsButton getChunkBorders() {
        return this.chunkBorders;
    }

    public DevToolsButton getMapSquares() {
        return this.mapSquares;
    }

    public DevToolsButton getValidMovement() {
        return this.validMovement;
    }

    public DevToolsButton getLineOfSight() {
        return this.lineOfSight;
    }

    public DevToolsButton getCameraPosition() {
        return this.cameraPosition;
    }

    public DevToolsButton getWorldMapLocation() {
        return this.worldMapLocation;
    }

    public DevToolsButton getTileLocation() {
        return this.tileLocation;
    }

    public DevToolsButton getInteracting() {
        return this.interacting;
    }

    public DevToolsButton getExamine() {
        return this.examine;
    }

    public DevToolsButton getDetachedCamera() {
        return this.detachedCamera;
    }

    public DevToolsButton getWidgetInspector() {
        return this.widgetInspector;
    }

    public DevToolsButton getVarInspector() {
        return this.varInspector;
    }

    public NavigationButton getNavButton() {
        return this.navButton;
    }
}

