/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.devtools;

import java.awt.GridLayout;
import javax.inject.Inject;
import javax.swing.JPanel;
import net.runelite.api.Client;
import net.runelite.client.plugins.devtools.DevToolsPlugin;
import net.runelite.client.plugins.devtools.VarInspector;
import net.runelite.client.plugins.devtools.WidgetInspector;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;

class DevToolsPanel
extends PluginPanel {
    private final Client client;
    private final DevToolsPlugin plugin;
    private final WidgetInspector widgetInspector;
    private final VarInspector varInspector;

    @Inject
    private DevToolsPanel(Client client2, DevToolsPlugin plugin, WidgetInspector widgetInspector, VarInspector varInspector) {
        this.client = client2;
        this.plugin = plugin;
        this.widgetInspector = widgetInspector;
        this.varInspector = varInspector;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.add(this.createOptionsPanel());
    }

    private JPanel createOptionsPanel() {
        JPanel container = new JPanel();
        container.setBackground(ColorScheme.DARK_GRAY_COLOR);
        container.setLayout(new GridLayout(0, 2, 3, 3));
        container.add(this.plugin.getPlayers());
        container.add(this.plugin.getNpcs());
        container.add(this.plugin.getGroundItems());
        container.add(this.plugin.getGroundObjects());
        container.add(this.plugin.getGameObjects());
        container.add(this.plugin.getGraphicsObjects());
        container.add(this.plugin.getWalls());
        container.add(this.plugin.getDecorations());
        container.add(this.plugin.getInventory());
        container.add(this.plugin.getProjectiles());
        container.add(this.plugin.getLocation());
        container.add(this.plugin.getWorldMapLocation());
        container.add(this.plugin.getTileLocation());
        container.add(this.plugin.getCameraPosition());
        container.add(this.plugin.getChunkBorders());
        container.add(this.plugin.getMapSquares());
        container.add(this.plugin.getLineOfSight());
        container.add(this.plugin.getValidMovement());
        container.add(this.plugin.getInteracting());
        container.add(this.plugin.getExamine());
        container.add(this.plugin.getDetachedCamera());
        this.plugin.getDetachedCamera().addActionListener(ev -> {
            this.client.setOculusOrbState(!this.plugin.getDetachedCamera().isActive() ? 1 : 0);
            this.client.setOculusOrbNormalSpeed(!this.plugin.getDetachedCamera().isActive() ? 36 : 12);
        });
        container.add(this.plugin.getWidgetInspector());
        this.plugin.getWidgetInspector().addActionListener(ev -> {
            if (this.plugin.getWidgetInspector().isActive()) {
                this.widgetInspector.close();
            } else {
                this.widgetInspector.open();
            }
        });
        container.add(this.plugin.getVarInspector());
        this.plugin.getVarInspector().addActionListener(ev -> {
            if (this.plugin.getVarInspector().isActive()) {
                this.varInspector.close();
            } else {
                this.varInspector.open();
            }
        });
        return container;
    }
}

