/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.devtools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GraphicsObject;
import net.runelite.api.GroundObject;
import net.runelite.api.Item;
import net.runelite.api.ItemLayer;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Node;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.Projectile;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.plugins.devtools.DevToolsPlugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

@Singleton
class DevToolsOverlay
extends Overlay {
    private static final int ITEM_EMPTY = 6512;
    private static final int ITEM_FILLED = 20594;
    private static final Font FONT = FontManager.getRunescapeFont().deriveFont(1, 16.0f);
    private static final Color RED = new Color(221, 44, 0);
    private static final Color GREEN = new Color(0, 200, 83);
    private static final Color ORANGE = new Color(255, 109, 0);
    private static final Color YELLOW = new Color(255, 214, 0);
    private static final Color CYAN = new Color(0, 184, 212);
    private static final Color BLUE = new Color(41, 98, 255);
    private static final Color DEEP_PURPLE = new Color(98, 0, 234);
    private static final Color PURPLE = new Color(170, 0, 255);
    private static final Color GRAY = new Color(158, 158, 158);
    private static final int MAX_DISTANCE = 2400;
    private final Client client;
    private final DevToolsPlugin plugin;
    private final TooltipManager toolTipManager;
    private Widget widget;
    private int itemIndex = -1;

    @Inject
    private DevToolsOverlay(Client client2, DevToolsPlugin plugin, TooltipManager toolTipManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_MAP);
        this.client = client2;
        this.plugin = plugin;
        this.toolTipManager = toolTipManager;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        graphics.setFont(FONT);
        if (this.plugin.getPlayers().isActive()) {
            this.renderPlayers(graphics);
        }
        if (this.plugin.getNpcs().isActive()) {
            this.renderNpcs(graphics);
        }
        if (this.plugin.getGroundItems().isActive() || this.plugin.getGroundObjects().isActive() || this.plugin.getGameObjects().isActive() || this.plugin.getWalls().isActive() || this.plugin.getDecorations().isActive() || this.plugin.getTileLocation().isActive()) {
            this.renderTileObjects(graphics);
        }
        if (this.plugin.getInventory().isActive()) {
            this.renderInventory(graphics);
        }
        if (this.plugin.getProjectiles().isActive()) {
            this.renderProjectiles(graphics);
        }
        if (this.plugin.getGraphicsObjects().isActive()) {
            this.renderGraphicsObjects(graphics);
        }
        this.renderWidgets(graphics);
        return null;
    }

    private void renderPlayers(Graphics2D graphics) {
        List<Player> players = this.client.getPlayers();
        Player local = this.client.getLocalPlayer();
        for (Player p : players) {
            if (p == local) continue;
            String text = p.getName() + " (A: " + p.getAnimation() + ") (G: " + p.getGraphic() + ")";
            OverlayUtil.renderActorOverlay(graphics, p, text, BLUE);
        }
        String text = local.getName() + " (A: " + local.getAnimation() + ") (G: " + local.getGraphic() + ")";
        OverlayUtil.renderActorOverlay(graphics, local, text, CYAN);
        this.renderPlayerWireframe(graphics, local, CYAN);
    }

    private void renderNpcs(Graphics2D graphics) {
        List<NPC> npcs = this.client.getNpcs();
        for (NPC npc : npcs) {
            Color color;
            NPCComposition composition = npc.getComposition();
            Color color2 = color = composition.getCombatLevel() > 1 ? YELLOW : ORANGE;
            if (composition.getConfigs() != null) {
                NPCComposition transformedComposition = composition.transform();
                if (transformedComposition == null) {
                    color = GRAY;
                } else {
                    composition = transformedComposition;
                }
            }
            String text = String.format("%s (ID: %d) (A: %d) (G: %d)", composition.getName(), composition.getId(), npc.getAnimation(), npc.getGraphic());
            OverlayUtil.renderActorOverlay(graphics, npc, text, color);
        }
    }

    private void renderTileObjects(Graphics2D graphics) {
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        int z = this.client.getPlane();
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Player player;
                Tile tile = tiles[z][x][y];
                if (tile == null || (player = this.client.getLocalPlayer()) == null) continue;
                if (this.plugin.getGroundItems().isActive()) {
                    this.renderGroundItems(graphics, tile, player);
                }
                if (this.plugin.getGroundObjects().isActive()) {
                    this.renderGroundObject(graphics, tile, player);
                }
                if (this.plugin.getGameObjects().isActive()) {
                    this.renderGameObjects(graphics, tile, player);
                }
                if (this.plugin.getWalls().isActive()) {
                    this.renderWallObject(graphics, tile, player);
                }
                if (this.plugin.getDecorations().isActive()) {
                    this.renderDecorObject(graphics, tile, player);
                }
                if (!this.plugin.getTileLocation().isActive()) continue;
                this.renderTileTooltip(graphics, tile);
            }
        }
    }

    private void renderTileTooltip(Graphics2D graphics, Tile tile) {
        Polygon poly = Perspective.getCanvasTilePoly(this.client, tile.getLocalLocation());
        if (poly != null && poly.contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            this.toolTipManager.add(new Tooltip("World Location: " + tile.getWorldLocation().getX() + ", " + tile.getWorldLocation().getY() + ", " + this.client.getPlane()));
            OverlayUtil.renderPolygon(graphics, poly, GREEN);
        }
    }

    private void renderGroundItems(Graphics2D graphics, Tile tile, Player player) {
        ItemLayer itemLayer = tile.getItemLayer();
        if (itemLayer != null && player.getLocalLocation().distanceTo(itemLayer.getLocalLocation()) <= 2400) {
            Node current = itemLayer.getBottom();
            while (current instanceof Item) {
                Item item = (Item)current;
                OverlayUtil.renderTileOverlay(graphics, itemLayer, "ID: " + item.getId() + " Qty:" + item.getQuantity(), RED);
                current = current.getNext();
            }
        }
    }

    private void renderGameObjects(Graphics2D graphics, Tile tile, Player player) {
        GameObject[] gameObjects = tile.getGameObjects();
        if (gameObjects != null) {
            for (GameObject gameObject : gameObjects) {
                Polygon p;
                if (gameObject == null) continue;
                if (player.getLocalLocation().distanceTo(gameObject.getLocalLocation()) <= 2400) {
                    OverlayUtil.renderTileOverlay(graphics, gameObject, "ID: " + gameObject.getId(), GREEN);
                }
                if ((p = gameObject.getConvexHull()) == null) continue;
                graphics.drawPolygon(p);
            }
        }
    }

    private void renderGroundObject(Graphics2D graphics, Tile tile, Player player) {
        GroundObject groundObject = tile.getGroundObject();
        if (groundObject != null && player.getLocalLocation().distanceTo(groundObject.getLocalLocation()) <= 2400) {
            OverlayUtil.renderTileOverlay(graphics, groundObject, "ID: " + groundObject.getId(), PURPLE);
        }
    }

    private void renderWallObject(Graphics2D graphics, Tile tile, Player player) {
        WallObject wallObject = tile.getWallObject();
        if (wallObject != null && player.getLocalLocation().distanceTo(wallObject.getLocalLocation()) <= 2400) {
            OverlayUtil.renderTileOverlay(graphics, wallObject, "ID: " + wallObject.getId(), GRAY);
        }
    }

    private void renderDecorObject(Graphics2D graphics, Tile tile, Player player) {
        DecorativeObject decorObject = tile.getDecorativeObject();
        if (decorObject != null) {
            Polygon p;
            if (player.getLocalLocation().distanceTo(decorObject.getLocalLocation()) <= 2400) {
                OverlayUtil.renderTileOverlay(graphics, decorObject, "ID: " + decorObject.getId(), DEEP_PURPLE);
            }
            if ((p = decorObject.getConvexHull()) != null) {
                graphics.drawPolygon(p);
            }
            if ((p = decorObject.getConvexHull2()) != null) {
                graphics.drawPolygon(p);
            }
        }
    }

    private void renderInventory(Graphics2D graphics) {
        Widget inventoryWidget = this.client.getWidget(WidgetInfo.INVENTORY);
        if (inventoryWidget == null || inventoryWidget.isHidden()) {
            return;
        }
        for (WidgetItem item : inventoryWidget.getWidgetItems()) {
            Rectangle slotBounds = item.getCanvasBounds();
            String idText = "" + item.getId();
            FontMetrics fm = graphics.getFontMetrics();
            Rectangle2D textBounds = fm.getStringBounds(idText, graphics);
            int textX = (int)(slotBounds.getX() + slotBounds.getWidth() / 2.0 - textBounds.getWidth() / 2.0);
            int textY = (int)(slotBounds.getY() + slotBounds.getHeight() / 2.0 + textBounds.getHeight() / 2.0);
            graphics.setColor(new Color(255, 255, 255, 65));
            graphics.fill(slotBounds);
            graphics.setColor(Color.BLACK);
            graphics.drawString(idText, textX + 1, textY + 1);
            graphics.setColor(YELLOW);
            graphics.drawString(idText, textX, textY);
        }
    }

    private void renderProjectiles(Graphics2D graphics) {
        List<Projectile> projectiles = this.client.getProjectiles();
        for (Projectile projectile : projectiles) {
            int y;
            int projectileId = projectile.getId();
            String text = "(ID: " + projectileId + ")";
            int x = (int)projectile.getX();
            LocalPoint projectilePoint = new LocalPoint(x, y = (int)projectile.getY());
            Point textLocation = Perspective.getCanvasTextLocation(this.client, graphics, projectilePoint, text, 0);
            if (textLocation == null) continue;
            OverlayUtil.renderTextLocation(graphics, textLocation, text, Color.RED);
        }
    }

    private void renderGraphicsObjects(Graphics2D graphics) {
        List<GraphicsObject> graphicsObjects = this.client.getGraphicsObjects();
        for (GraphicsObject graphicsObject : graphicsObjects) {
            String infoString;
            Point textLocation;
            LocalPoint lp = graphicsObject.getLocation();
            Polygon poly = Perspective.getCanvasTilePoly(this.client, lp);
            if (poly != null) {
                OverlayUtil.renderPolygon(graphics, poly, Color.MAGENTA);
            }
            if ((textLocation = Perspective.getCanvasTextLocation(this.client, graphics, lp, infoString = "(ID: " + graphicsObject.getId() + ")", 0)) == null) continue;
            OverlayUtil.renderTextLocation(graphics, textLocation, infoString, Color.WHITE);
        }
    }

    private void renderWidgets(Graphics2D graphics) {
        WidgetItem widgetItem;
        if (this.widget == null || this.widget.isHidden()) {
            return;
        }
        Rectangle childBounds = this.widget.getBounds();
        graphics.setColor(CYAN);
        graphics.draw(childBounds);
        if (this.itemIndex == -1) {
            return;
        }
        if (this.widget.getItemId() != 6512 && this.widget.getItemId() != 20594) {
            Rectangle componentBounds = this.widget.getBounds();
            graphics.setColor(ORANGE);
            graphics.draw(componentBounds);
            this.renderWidgetText(graphics, componentBounds, this.widget.getItemId(), YELLOW);
        }
        if ((widgetItem = this.widget.getWidgetItem(this.itemIndex)) == null || widgetItem.getId() == 6512 || widgetItem.getId() == 20594) {
            return;
        }
        Rectangle itemBounds = widgetItem.getCanvasBounds();
        graphics.setColor(ORANGE);
        graphics.draw(itemBounds);
        this.renderWidgetText(graphics, itemBounds, widgetItem.getId(), YELLOW);
    }

    private void renderWidgetText(Graphics2D graphics, Rectangle bounds, int itemId, Color color) {
        if (itemId == -1) {
            return;
        }
        String text = "" + itemId;
        FontMetrics fm = graphics.getFontMetrics();
        Rectangle2D textBounds = fm.getStringBounds(text, graphics);
        int textX = (int)(bounds.getX() + bounds.getWidth() / 2.0 - textBounds.getWidth() / 2.0);
        int textY = (int)(bounds.getY() + bounds.getHeight() / 2.0 + textBounds.getHeight() / 2.0);
        graphics.setColor(Color.BLACK);
        graphics.drawString(text, textX + 1, textY + 1);
        graphics.setColor(color);
        graphics.drawString(text, textX, textY);
    }

    private void renderPlayerWireframe(Graphics2D graphics, Player player, Color color) {
        Polygon[] polys = player.getPolygons();
        if (polys == null) {
            return;
        }
        graphics.setColor(color);
        for (Polygon p : polys) {
            graphics.drawPolygon(p);
        }
    }

    public void setWidget(Widget widget) {
        this.widget = widget;
    }

    public Widget getWidget() {
        return this.widget;
    }

    public void setItemIndex(int itemIndex) {
        this.itemIndex = itemIndex;
    }
}

