/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.devtools;

import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.devtools.DevToolsPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class CameraOverlay
extends Overlay {
    private final Client client;
    private final DevToolsPlugin plugin;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    CameraOverlay(Client client2, DevToolsPlugin plugin) {
        this.client = client2;
        this.plugin = plugin;
        this.panelComponent.setPreferredSize(new Dimension(150, 0));
        this.setPosition(OverlayPosition.TOP_LEFT);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.getCameraPosition().isActive()) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Camera").build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("X").right("" + this.client.getCameraX()).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Y").right("" + this.client.getCameraY()).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Z").right("" + this.client.getCameraZ()).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Pitch").right("" + this.client.getCameraPitch()).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Yaw").right("" + this.client.getCameraYaw()).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Scale").right("" + this.client.getScale()).build());
        return this.panelComponent.render(graphics);
    }
}

