/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.demonicgorilla;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.plugins.demonicgorilla.DemonicGorilla;
import net.runelite.client.plugins.demonicgorilla.DemonicGorillaPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class DemonicGorillaOverlay
extends Overlay {
    private static final Color COLOR_ICON_BACKGROUND = new Color(0, 0, 0, 128);
    private static final Color COLOR_ICON_BORDER = new Color(0, 0, 0, 255);
    private static final Color COLOR_ICON_BORDER_FILL = new Color(219, 175, 0, 255);
    private static final int OVERLAY_ICON_DISTANCE = 50;
    private static final int OVERLAY_ICON_MARGIN = 8;
    private Client client;
    private DemonicGorillaPlugin plugin;
    @Inject
    private SkillIconManager iconManager;

    @Inject
    public DemonicGorillaOverlay(Client client2, DemonicGorillaPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client2;
        this.plugin = plugin;
    }

    private BufferedImage getIcon(DemonicGorilla.AttackStyle attackStyle) {
        switch (attackStyle) {
            case MELEE: {
                return this.iconManager.getSkillImage(Skill.ATTACK);
            }
            case RANGED: {
                return this.iconManager.getSkillImage(Skill.RANGED);
            }
            case MAGIC: {
                return this.iconManager.getSkillImage(Skill.MAGIC);
            }
        }
        return null;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        for (DemonicGorilla gorilla : this.plugin.getGorillas().values()) {
            Point point;
            LocalPoint lp;
            if (gorilla.getNpc().getInteracting() == null || (lp = gorilla.getNpc().getLocalLocation()) == null || (point = Perspective.localToCanvas(this.client, lp, this.client.getPlane(), gorilla.getNpc().getLogicalHeight() + 16)) == null) continue;
            point = new Point(point.getX(), point.getY());
            List<DemonicGorilla.AttackStyle> attackStyles = gorilla.getNextPosibleAttackStyles();
            ArrayList<BufferedImage> icons = new ArrayList<BufferedImage>();
            int totalWidth = (attackStyles.size() - 1) * 8;
            for (DemonicGorilla.AttackStyle attackStyle : attackStyles) {
                BufferedImage icon = this.getIcon(attackStyle);
                icons.add(icon);
                totalWidth += icon.getWidth();
            }
            int bgPadding = 4;
            int currentPosX = 0;
            for (BufferedImage icon : icons) {
                graphics.setStroke(new BasicStroke(2.0f));
                graphics.setColor(COLOR_ICON_BACKGROUND);
                graphics.fillOval(point.getX() - totalWidth / 2 + currentPosX - bgPadding, point.getY() - icon.getHeight() / 2 - 50 - bgPadding, icon.getWidth() + bgPadding * 2, icon.getHeight() + bgPadding * 2);
                graphics.setColor(COLOR_ICON_BORDER);
                graphics.drawOval(point.getX() - totalWidth / 2 + currentPosX - bgPadding, point.getY() - icon.getHeight() / 2 - 50 - bgPadding, icon.getWidth() + bgPadding * 2, icon.getHeight() + bgPadding * 2);
                graphics.drawImage((Image)icon, point.getX() - totalWidth / 2 + currentPosX, point.getY() - icon.getHeight() / 2 - 50, null);
                graphics.setColor(COLOR_ICON_BORDER_FILL);
                Arc2D.Double arc = new Arc2D.Double(point.getX() - totalWidth / 2 + currentPosX - bgPadding, point.getY() - icon.getHeight() / 2 - 50 - bgPadding, icon.getWidth() + bgPadding * 2, icon.getHeight() + bgPadding * 2, 90.0, -360.0 * (double)(3 - gorilla.getAttacksUntilSwitch()) / 3.0, 0);
                graphics.draw(arc);
                currentPosX += icon.getWidth() + 8;
            }
        }
        return null;
    }
}

