/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.defaultworld;

import com.google.inject.Provides;
import java.io.IOException;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.SessionOpen;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.defaultworld.DefaultWorldConfig;
import net.runelite.client.util.WorldUtil;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldClient;
import net.runelite.http.api.worlds.WorldResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Default World", description="Enable a default world to be selected when launching the client", tags={"home"})
public class DefaultWorldPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorldPlugin.class);
    @Inject
    private Client client;
    @Inject
    private DefaultWorldConfig config;
    private final WorldClient worldClient = new WorldClient();
    private int worldCache;
    private boolean worldChangeRequired;

    @Override
    protected void startUp() throws Exception {
        this.worldChangeRequired = true;
        this.applyWorld();
    }

    @Override
    protected void shutDown() throws Exception {
        this.worldChangeRequired = true;
        this.changeWorld(this.worldCache);
    }

    @Provides
    DefaultWorldConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(DefaultWorldConfig.class);
    }

    @Subscribe
    public void onSessionOpen(SessionOpen event) {
        this.worldChangeRequired = true;
        this.applyWorld();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.applyWorld();
    }

    private void changeWorld(int newWorld) {
        int correctedWorld;
        if (!this.worldChangeRequired || this.client.getGameState() != GameState.LOGIN_SCREEN) {
            return;
        }
        this.worldChangeRequired = false;
        int n = correctedWorld = newWorld < 300 ? newWorld + 300 : newWorld;
        if (correctedWorld <= 300 || this.client.getWorld() == correctedWorld) {
            return;
        }
        try {
            WorldResult worldResult = this.worldClient.lookupWorlds();
            World world = worldResult.findWorld(correctedWorld);
            if (world != null) {
                net.runelite.api.World rsWorld = this.client.createWorld();
                rsWorld.setActivity(world.getActivity());
                rsWorld.setAddress(world.getAddress());
                rsWorld.setId(world.getId());
                rsWorld.setPlayerCount(world.getPlayers());
                rsWorld.setLocation(world.getLocation());
                rsWorld.setTypes(WorldUtil.toWorldTypes(world.getTypes()));
                this.client.changeWorld(rsWorld);
                log.debug("Applied new world {}", (Object)correctedWorld);
            } else {
                log.warn("World {} not found.", (Object)correctedWorld);
            }
        }
        catch (IOException e) {
            log.warn("Error looking up world {}. Error: {}", (Object)correctedWorld, (Object)e);
        }
    }

    private void applyWorld() {
        if (this.worldCache == 0) {
            this.worldCache = this.client.getWorld();
            log.debug("Stored old world {}", (Object)this.worldCache);
        }
        int newWorld = this.config.getWorld();
        this.changeWorld(newWorld);
    }
}

