/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.deathindicator;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.deathindicator.DeathIndicatorPlugin;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;

class DeathWorldMapPoint
extends WorldMapPoint {
    private final DeathIndicatorPlugin plugin;
    private final BufferedImage worldmapHintArrow;
    private final Point worldmapHintArrowPoint;

    DeathWorldMapPoint(WorldPoint worldPoint, DeathIndicatorPlugin plugin) {
        super(worldPoint, null);
        this.worldmapHintArrow = new BufferedImage(plugin.getMapArrow().getWidth(), plugin.getMapArrow().getHeight(), 2);
        Graphics graphics = this.worldmapHintArrow.getGraphics();
        graphics.drawImage(plugin.getMapArrow(), 0, 0, null);
        graphics.drawImage(plugin.getBonesImage(), 0, 0, null);
        this.worldmapHintArrowPoint = new Point(this.worldmapHintArrow.getWidth() / 2, this.worldmapHintArrow.getHeight());
        this.plugin = plugin;
        this.setSnapToEdge(true);
        this.setJumpOnClick(true);
        this.setImage(this.worldmapHintArrow);
        this.setImagePoint(this.worldmapHintArrowPoint);
        this.setTooltip("Death Location");
    }

    @Override
    public void onEdgeSnap() {
        this.setImage(this.plugin.getBonesImage());
        this.setImagePoint(null);
        this.setTooltip(null);
    }

    @Override
    public void onEdgeUnsnap() {
        this.setImage(this.worldmapHintArrow);
        this.setImagePoint(this.worldmapHintArrowPoint);
        this.setTooltip("Death Location");
    }
}

