/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.deathindicator;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.LocalPlayerDeath;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.deathindicator.DeathIndicatorConfig;
import net.runelite.client.plugins.deathindicator.DeathWorldMapPoint;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.ui.overlay.infobox.Timer;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Death Indicator", description="Show where you last died, and on what world", tags={"arrow", "hints", "world", "map", "overlay"})
public class DeathIndicatorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DeathIndicatorPlugin.class);
    private static final Set<Integer> RESPAWN_REGIONS = ImmutableSet.of(Integer.valueOf(12850), Integer.valueOf(11828), Integer.valueOf(12342), Integer.valueOf(11062));
    @Inject
    private Client client;
    @Inject
    private DeathIndicatorConfig config;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    private BufferedImage mapArrow;
    private Timer deathTimer;
    private WorldPoint lastDeath;
    private Instant lastDeathTime;
    private int lastDeathWorld;

    @Provides
    DeathIndicatorConfig deathIndicatorConfig(ConfigManager configManager) {
        return configManager.getConfig(DeathIndicatorConfig.class);
    }

    @Override
    protected void startUp() {
        if (!this.hasDied()) {
            return;
        }
        this.resetInfobox();
        if (this.client.getWorld() != this.config.deathWorld()) {
            return;
        }
        if (this.config.showDeathHintArrow() && !this.client.hasHintArrow()) {
            this.client.setHintArrow(new WorldPoint(this.config.deathLocationX(), this.config.deathLocationY(), this.config.deathLocationPlane()));
        }
        if (this.config.showDeathOnWorldMap()) {
            this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
            this.worldMapPointManager.add(new DeathWorldMapPoint(new WorldPoint(this.config.deathLocationX(), this.config.deathLocationY(), this.config.deathLocationPlane()), this));
        }
    }

    @Override
    protected void shutDown() {
        if (this.client.hasHintArrow()) {
            this.client.clearHintArrow();
        }
        if (this.deathTimer != null) {
            this.infoBoxManager.removeInfoBox(this.deathTimer);
            this.deathTimer = null;
        }
        this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
    }

    @Subscribe
    public void onLocalPlayerDeath(LocalPlayerDeath death) {
        if (this.client.isInInstancedRegion()) {
            return;
        }
        this.lastDeath = this.client.getLocalPlayer().getWorldLocation();
        this.lastDeathWorld = this.client.getWorld();
        this.lastDeathTime = Instant.now();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.lastDeath != null && !this.client.getLocalPlayer().getWorldLocation().equals(this.lastDeath)) {
            if (!RESPAWN_REGIONS.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID())) {
                log.debug("Died, but did not respawn in a known respawn location: {}", (Object)this.client.getLocalPlayer().getWorldLocation().getRegionID());
                this.lastDeath = null;
                this.lastDeathTime = null;
                return;
            }
            log.debug("Died! Grave at {}", (Object)this.lastDeath);
            this.config.deathLocationX(this.lastDeath.getX());
            this.config.deathLocationY(this.lastDeath.getY());
            this.config.deathLocationPlane(this.lastDeath.getPlane());
            this.config.timeOfDeath(this.lastDeathTime);
            this.config.deathWorld(this.lastDeathWorld);
            if (this.config.showDeathHintArrow()) {
                this.client.setHintArrow(this.lastDeath);
            }
            if (this.config.showDeathOnWorldMap()) {
                this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
                this.worldMapPointManager.add(new DeathWorldMapPoint(this.lastDeath, this));
            }
            this.resetInfobox();
            this.lastDeath = null;
            this.lastDeathTime = null;
        }
        if (!this.hasDied() || this.client.getWorld() != this.config.deathWorld()) {
            return;
        }
        WorldPoint deathPoint = new WorldPoint(this.config.deathLocationX(), this.config.deathLocationY(), this.config.deathLocationPlane());
        if (deathPoint.equals(this.client.getLocalPlayer().getWorldLocation()) || this.deathTimer != null && this.deathTimer.cull()) {
            this.client.clearHintArrow();
            if (this.deathTimer != null) {
                this.infoBoxManager.removeInfoBox(this.deathTimer);
                this.deathTimer = null;
            }
            this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
            this.resetDeath();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("deathIndicator")) {
            if (!this.config.showDeathHintArrow() && this.hasDied()) {
                this.client.clearHintArrow();
            }
            if (!this.config.showDeathInfoBox() && this.deathTimer != null) {
                this.infoBoxManager.removeInfoBox(this.deathTimer);
                this.deathTimer = null;
            }
            if (!this.config.showDeathOnWorldMap()) {
                this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
            }
            if (!this.hasDied()) {
                this.client.clearHintArrow();
                this.resetInfobox();
                this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (!this.hasDied()) {
            return;
        }
        if (event.getGameState() == GameState.LOGGED_IN) {
            if (this.client.getWorld() == this.config.deathWorld()) {
                WorldPoint deathPoint = new WorldPoint(this.config.deathLocationX(), this.config.deathLocationY(), this.config.deathLocationPlane());
                if (this.config.showDeathHintArrow()) {
                    this.client.setHintArrow(deathPoint);
                }
                if (this.config.showDeathOnWorldMap()) {
                    this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
                    this.worldMapPointManager.add(new DeathWorldMapPoint(deathPoint, this));
                }
            } else {
                this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
            }
        }
    }

    private boolean hasDied() {
        return this.config.timeOfDeath() != null;
    }

    private void resetDeath() {
        this.config.deathLocationX(0);
        this.config.deathLocationY(0);
        this.config.deathLocationPlane(0);
        this.config.deathWorld(0);
        this.config.timeOfDeath(null);
    }

    private void resetInfobox() {
        if (this.deathTimer != null) {
            this.infoBoxManager.removeInfoBox(this.deathTimer);
            this.deathTimer = null;
        }
        if (this.hasDied() && this.config.showDeathInfoBox()) {
            Instant now = Instant.now();
            Duration timeLeft = Duration.ofMinutes(3L).minus(Duration.between(this.config.timeOfDeath(), now));
            if (!timeLeft.isNegative() && !timeLeft.isZero()) {
                this.deathTimer = new Timer(timeLeft.getSeconds(), ChronoUnit.SECONDS, this.getBonesImage(), this);
                this.deathTimer.setTooltip("Died on world: " + this.config.deathWorld());
                this.infoBoxManager.addInfoBox(this.deathTimer);
            }
        }
    }

    BufferedImage getMapArrow() {
        if (this.mapArrow != null) {
            return this.mapArrow;
        }
        this.mapArrow = ImageUtil.getResourceStreamFromClass(this.getClass(), "/util/clue_arrow.png");
        return this.mapArrow;
    }

    BufferedImage getBonesImage() {
        return this.itemManager.getImage(526);
    }
}

