/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.dailytaskindicators;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.VarClientInt;
import net.runelite.api.VarPlayer;
import net.runelite.api.Varbits;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.vars.AccountType;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.dailytaskindicators.DailyTasksConfig;

public class DailyTasksPlugin
extends Plugin {
    private static final int ONE_DAY = 86400000;
    private static final String HERB_BOX_MESSAGE = "You have herb boxes waiting to be collected at NMZ.";
    private static final int HERB_BOX_MAX = 15;
    private static final int HERB_BOX_COST = 9500;
    private static final String STAVES_MESSAGE = "You have battlestaves waiting to be collected from Zaff.";
    private static final String ESSENCE_MESSAGE = "You have essence waiting to be collected from Wizard Cromperty.";
    private static final String RUNES_MESSAGE = "You have random runes waiting to be collected from Lundail.";
    private static final String SAND_MESSAGE = "You have sand waiting to be collected from Bert.";
    private static final int SAND_QUEST_COMPLETE = 160;
    private static final String FLAX_MESSAGE = "You have bowstrings waiting to be converted from flax from the Flax keeper.";
    private static final String BONEMEAL_MESSAGE = "You have bonemeal and slime waiting to be collected from Robin.";
    private static final int BONEMEAL_PER_DIARY = 13;
    private static final String DYNAMITE_MESSAGE = "You have dynamite waiting to be collected from Thirus.";
    private static final String RELOG_MESSAGE = " (May require a relog)";
    @Inject
    private Client client;
    @Inject
    private DailyTasksConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    private long lastReset;
    private boolean loggingIn;

    @Provides
    DailyTasksConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(DailyTasksConfig.class);
    }

    @Override
    public void startUp() {
        this.loggingIn = true;
    }

    @Override
    public void shutDown() {
        this.lastReset = 0L;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGING_IN) {
            this.loggingIn = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        boolean dailyReset;
        long currentTime = System.currentTimeMillis();
        boolean bl = dailyReset = !this.loggingIn && currentTime - this.lastReset > 86400000L;
        if ((dailyReset || this.loggingIn) && this.client.getVar(VarClientInt.MEMBERSHIP_STATUS) == 1) {
            this.lastReset = (long)Math.floor(currentTime / 86400000L) * 86400000L;
            this.loggingIn = false;
            if (this.config.showHerbBoxes()) {
                this.checkHerbBoxes(dailyReset);
            }
            if (this.config.showStaves()) {
                this.checkStaves(dailyReset);
            }
            if (this.config.showEssence()) {
                this.checkEssence(dailyReset);
            }
            if (this.config.showRunes()) {
                this.checkRunes(dailyReset);
            }
            if (this.config.showSand()) {
                this.checkSand(dailyReset);
            }
            if (this.config.showFlax()) {
                this.checkFlax(dailyReset);
            }
            if (this.config.showBonemeal()) {
                this.checkBonemeal(dailyReset);
            }
            if (this.config.showDynamite()) {
                this.checkDynamite(dailyReset);
            }
        }
    }

    private void checkHerbBoxes(boolean dailyReset) {
        if (this.client.getAccountType() == AccountType.NORMAL && this.client.getVar(VarPlayer.NMZ_REWARD_POINTS) >= 9500) {
            if (this.client.getVar(Varbits.DAILY_HERB_BOXES_COLLECTED) < 15) {
                this.sendChatMessage(HERB_BOX_MESSAGE);
            } else if (dailyReset) {
                this.sendChatMessage(HERB_BOX_MESSAGE);
            }
        }
    }

    private void checkStaves(boolean dailyReset) {
        if (this.client.getVar(Varbits.DIARY_VARROCK_EASY) == 1) {
            if (this.client.getVar(Varbits.DAILY_STAVES_COLLECTED) == 0) {
                this.sendChatMessage(STAVES_MESSAGE);
            } else if (dailyReset) {
                this.sendChatMessage("You have battlestaves waiting to be collected from Zaff. (May require a relog)");
            }
        }
    }

    private void checkEssence(boolean dailyReset) {
        if (this.client.getVar(Varbits.DIARY_ARDOUGNE_MEDIUM) == 1) {
            if (this.client.getVar(Varbits.DAILY_ESSENCE_COLLECTED) == 0) {
                this.sendChatMessage(ESSENCE_MESSAGE);
            } else if (dailyReset) {
                this.sendChatMessage(ESSENCE_MESSAGE);
            }
        }
    }

    private void checkRunes(boolean dailyReset) {
        if (this.client.getVar(Varbits.DIARY_WILDERNESS_EASY) == 1) {
            if (this.client.getVar(Varbits.DAILY_RUNES_COLLECTED) == 0) {
                this.sendChatMessage(RUNES_MESSAGE);
            } else if (dailyReset) {
                this.sendChatMessage(RUNES_MESSAGE);
            }
        }
    }

    private void checkSand(boolean dailyReset) {
        if (this.client.getVar(Varbits.QUEST_THE_HAND_IN_THE_SAND) >= 160) {
            if (this.client.getVar(Varbits.DAILY_SAND_COLLECTED) == 0) {
                this.sendChatMessage(SAND_MESSAGE);
            } else if (dailyReset) {
                this.sendChatMessage(SAND_MESSAGE);
            }
        }
    }

    private void checkFlax(boolean dailyReset) {
        if (this.client.getVar(Varbits.DIARY_KANDARIN_EASY) == 1) {
            if (this.client.getVar(Varbits.DAILY_FLAX_STATE) == 0) {
                this.sendChatMessage(FLAX_MESSAGE);
            } else if (dailyReset) {
                this.sendChatMessage(FLAX_MESSAGE);
            }
        }
    }

    private void checkBonemeal(boolean dailyReset) {
        if (this.client.getVar(Varbits.DIARY_MORYTANIA_MEDIUM) == 1) {
            int collected = this.client.getVar(Varbits.DAILY_BONEMEAL_STATE);
            int max = 13;
            if (this.client.getVar(Varbits.DIARY_MORYTANIA_HARD) == 1) {
                max += 13;
                if (this.client.getVar(Varbits.DIARY_MORYTANIA_ELITE) == 1) {
                    max += 13;
                }
            }
            if (collected < max) {
                this.sendChatMessage(BONEMEAL_MESSAGE);
            } else if (dailyReset) {
                this.sendChatMessage(BONEMEAL_MESSAGE);
            }
        }
    }

    private void checkDynamite(boolean dailyReset) {
        if (this.client.getVar(Varbits.DIARY_KOUREND_MEDIUM) == 1) {
            if (this.client.getVar(Varbits.DAILY_DYNAMITE_COLLECTED) == 0) {
                this.sendChatMessage(DYNAMITE_MESSAGE);
            } else if (dailyReset) {
                this.sendChatMessage(DYNAMITE_MESSAGE);
            }
        }
    }

    private void sendChatMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }
}

