/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.customcursor;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.events.ConfigChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.customcursor.CustomCursor;
import net.runelite.client.plugins.customcursor.CustomCursorConfig;
import net.runelite.client.ui.ClientUI;

@PluginDescriptor(name="Custom Cursor", description="Replaces your mouse cursor image", enabledByDefault=false)
public class CustomCursorPlugin
extends Plugin {
    @Inject
    private ClientUI clientUI;
    @Inject
    private CustomCursorConfig config;

    @Provides
    CustomCursorConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(CustomCursorConfig.class);
    }

    @Override
    protected void startUp() {
        this.updateCursor();
    }

    @Override
    protected void shutDown() {
        this.clientUI.resetCursor();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("customcursor") && event.getKey().equals("cursorStyle")) {
            this.updateCursor();
        }
    }

    private void updateCursor() {
        CustomCursor selectedCursor = this.config.selectedCursor();
        this.clientUI.setCursor(selectedCursor.getCursorImage(), selectedCursor.toString());
    }
}

