/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.crystalmathlabs;

import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Crystal Math Labs", description="Automatically updates your stats on Crystal Math Labs when you log out", tags={"cml", "external", "integration"}, enabledByDefault=false)
public class CrystalMathLabs
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CrystalMathLabs.class);
    private static final int XP_THRESHOLD = 1000;
    @Inject
    private Client client;
    private String lastUsername;
    private boolean fetchXp;
    private long lastXp;

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState state = gameStateChanged.getGameState();
        if (state == GameState.LOGGED_IN) {
            if (!Objects.equals(this.client.getUsername(), this.lastUsername)) {
                this.lastUsername = this.client.getUsername();
                this.lastXp = this.getTotalXp();
            }
        } else if (state == GameState.LOGIN_SCREEN) {
            Player local = this.client.getLocalPlayer();
            if (local == null) {
                return;
            }
            long totalXp = this.getTotalXp();
            if (Math.abs(totalXp - this.lastXp) > 1000L) {
                log.debug("Submitting update for {}", (Object)local.getName());
                this.sendUpdateRequest(local.getName());
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.fetchXp) {
            this.lastXp = this.getTotalXp();
            this.fetchXp = false;
        }
    }

    private long getTotalXp() {
        long total = 0L;
        for (Skill skill : Skill.values()) {
            total += (long)this.client.getSkillExperience(skill);
        }
        return total;
    }

    private void sendUpdateRequest(String username) {
        String reformedUsername = username.replace(" ", "_");
        OkHttpClient httpClient = RuneLiteAPI.CLIENT;
        HttpUrl httpUrl = new HttpUrl.Builder().scheme("https").host("crystalmathlabs.com").addPathSegment("tracker").addPathSegment("api.php").addQueryParameter("type", "update").addQueryParameter("player", reformedUsername).build();
        Request request = new Request.Builder().header("User-Agent", "RuneLite").url(httpUrl).build();
        httpClient.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                log.warn("Error submitting CML update, caused by {}.", (Object)e.getMessage());
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
    }
}

