/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cooking;

import com.google.inject.Provides;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.cooking.CookingConfig;
import net.runelite.client.plugins.cooking.CookingOverlay;
import net.runelite.client.plugins.cooking.CookingSession;
import net.runelite.client.plugins.xptracker.XpTrackerPlugin;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Cooking", description="Show cooking statistics", tags={"overlay", "skilling", "cook"})
@PluginDependency(value=XpTrackerPlugin.class)
public class CookingPlugin
extends Plugin {
    @Inject
    private CookingConfig config;
    @Inject
    private CookingOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    private CookingSession session;

    @Provides
    CookingConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(CookingConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.session = null;
        this.overlayManager.add(this.overlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.session = null;
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.session == null || this.config.statTimeout() == 0) {
            return;
        }
        Duration statTimeout = Duration.ofMinutes(this.config.statTimeout());
        Duration sinceCut = Duration.between(this.session.getLastCookingAction(), Instant.now());
        if (sinceCut.compareTo(statTimeout) >= 0) {
            this.session = null;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String message = event.getMessage();
        if (message.startsWith("You successfully cook") || message.startsWith("You successfully bake") || message.startsWith("You manage to cook") || message.startsWith("You roast a") || message.startsWith("You cook") || message.startsWith("You squeeze the grapes into the jug")) {
            if (this.session == null) {
                this.session = new CookingSession();
            }
            this.session.updateLastCookingAction();
            this.session.increaseCookAmount();
        } else if (message.startsWith("You accidentally burn")) {
            if (this.session == null) {
                this.session = new CookingSession();
            }
            this.session.updateLastCookingAction();
            this.session.increaseBurnAmount();
        }
    }

    CookingSession getSession() {
        return this.session;
    }
}

