/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.config;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigDescriptor;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.config.ConfigPanel;
import net.runelite.client.ui.components.IconButton;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.text.similarity.JaroWinklerDistance;

class PluginListItem
extends JPanel {
    private static final JaroWinklerDistance DISTANCE = new JaroWinklerDistance();
    private static final ImageIcon CONFIG_ICON;
    private static final ImageIcon CONFIG_ICON_HOVER;
    private static final ImageIcon ON_SWITCHER;
    private static final ImageIcon OFF_SWITCHER;
    private static final ImageIcon ON_STAR;
    private static final ImageIcon OFF_STAR;
    private final ConfigPanel configPanel;
    @Nullable
    private final Plugin plugin;
    @Nullable
    private final Config config;
    @Nullable
    private final ConfigDescriptor configDescriptor;
    private final String name;
    private final String description;
    private final List<String> keywords = new ArrayList<String>();
    private final IconButton pinButton = new IconButton(OFF_STAR);
    private final IconButton configButton = new IconButton(CONFIG_ICON, CONFIG_ICON_HOVER);
    private final IconButton toggleButton = new IconButton(OFF_SWITCHER);
    private boolean isPluginEnabled = false;
    private boolean isPinned = false;

    PluginListItem(ConfigPanel configPanel, Plugin plugin, PluginDescriptor descriptor, @Nullable Config config, @Nullable ConfigDescriptor configDescriptor) {
        this(configPanel, plugin, config, configDescriptor, descriptor.name(), descriptor.description(), descriptor.tags());
    }

    PluginListItem(ConfigPanel configPanel, Config config, ConfigDescriptor configDescriptor, String name, String description, String ... tags) {
        this(configPanel, null, config, configDescriptor, name, description, tags);
    }

    private PluginListItem(ConfigPanel configPanel, @Nullable Plugin plugin, @Nullable Config config, @Nullable ConfigDescriptor configDescriptor, String name, String description, String ... tags) {
        this.configPanel = configPanel;
        this.plugin = plugin;
        this.config = config;
        this.configDescriptor = configDescriptor;
        this.name = name;
        this.description = description;
        Collections.addAll(this.keywords, name.toLowerCase().split(" "));
        Collections.addAll(this.keywords, description.toLowerCase().split(" "));
        Collections.addAll(this.keywords, tags);
        this.setLayout(new BorderLayout(3, 0));
        this.setPreferredSize(new Dimension(225, 20));
        JLabel nameLabel = new JLabel(name);
        nameLabel.setForeground(Color.WHITE);
        if (!description.isEmpty()) {
            nameLabel.setToolTipText("<html>" + name + ":<br>" + description + "</html>");
        }
        this.add((Component)nameLabel, "Center");
        this.pinButton.setPreferredSize(new Dimension(21, 0));
        this.add((Component)this.pinButton, "Before");
        this.pinButton.addActionListener(e -> {
            this.setPinned(!this.isPinned);
            configPanel.savePinnedPlugins();
            configPanel.openConfigList();
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        this.add((Component)buttonPanel, "After");
        this.configButton.setPreferredSize(new Dimension(25, 0));
        this.configButton.setVisible(false);
        buttonPanel.add(this.configButton);
        if (config != null && !configDescriptor.getItems().stream().allMatch(item -> item.getItem().hidden())) {
            this.configButton.addActionListener(e -> {
                this.configButton.setIcon(CONFIG_ICON);
                configPanel.openGroupConfigPanel(this, config, configDescriptor);
            });
            this.configButton.setVisible(true);
            this.configButton.setToolTipText("Edit plugin configuration");
        }
        this.toggleButton.setPreferredSize(new Dimension(25, 0));
        this.attachToggleButtonListener(this.toggleButton);
        buttonPanel.add(this.toggleButton);
    }

    private void attachToggleButtonListener(IconButton button) {
        if (this.plugin == null) {
            button.setVisible(false);
            return;
        }
        button.addActionListener(e -> {
            if (this.isPluginEnabled) {
                this.configPanel.stopPlugin(this.plugin, this);
            } else {
                this.configPanel.startPlugin(this.plugin, this);
            }
            this.setPluginEnabled(!this.isPluginEnabled);
            this.updateToggleButton(button);
        });
    }

    IconButton createToggleButton() {
        IconButton button = new IconButton(OFF_SWITCHER);
        button.setPreferredSize(new Dimension(25, 0));
        this.updateToggleButton(button);
        this.attachToggleButtonListener(button);
        return button;
    }

    void setPluginEnabled(boolean enabled) {
        this.isPluginEnabled = enabled;
        this.updateToggleButton(this.toggleButton);
    }

    void setPinned(boolean pinned) {
        this.isPinned = pinned;
        this.pinButton.setIcon(pinned ? ON_STAR : OFF_STAR);
        this.pinButton.setToolTipText(pinned ? "Unpin plugin" : "Pin plugin");
    }

    private void updateToggleButton(IconButton button) {
        button.setIcon(this.isPluginEnabled ? ON_SWITCHER : OFF_SWITCHER);
        button.setToolTipText(this.isPluginEnabled ? "Disable plugin" : "Enable plugin");
    }

    boolean matchesSearchTerms(String[] searchTerms) {
        for (String term : searchTerms) {
            if (!this.keywords.stream().noneMatch(t -> t.contains(term) || DISTANCE.apply((CharSequence)t, term) > 0.9)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Nullable
    Config getConfig() {
        return this.config;
    }

    @Nullable
    ConfigDescriptor getConfigDescriptor() {
        return this.configDescriptor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPinned() {
        return this.isPinned;
    }

    static {
        BufferedImage configIcon = ImageUtil.getResourceStreamFromClass(ConfigPanel.class, "config_edit_icon.png");
        BufferedImage onSwitcher = ImageUtil.getResourceStreamFromClass(ConfigPanel.class, "switcher_on.png");
        BufferedImage onStar = ImageUtil.getResourceStreamFromClass(ConfigPanel.class, "star_on.png");
        CONFIG_ICON = new ImageIcon(configIcon);
        ON_SWITCHER = new ImageIcon(onSwitcher);
        ON_STAR = new ImageIcon(onStar);
        CONFIG_ICON_HOVER = new ImageIcon(ImageUtil.grayscaleOffset(configIcon, -100));
        BufferedImage offSwitcherImage = ImageUtil.flipImage(ImageUtil.grayscaleOffset(ImageUtil.grayscaleImage(onSwitcher), 0.61f), true, false);
        OFF_SWITCHER = new ImageIcon(offSwitcherImage);
        BufferedImage offStar = ImageUtil.grayscaleOffset(ImageUtil.grayscaleImage(onStar), 0.77f);
        OFF_STAR = new ImageIcon(offStar);
    }
}

