/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.config;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import net.runelite.client.config.Keybind;
import net.runelite.client.config.ModifierlessKeybind;

public class HotkeyButton
extends JButton {
    private Keybind value;

    public HotkeyButton(Keybind value, final boolean modifierless) {
        this.setValue(value);
        this.addActionListener(e -> this.setValue(Keybind.NOT_SET));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (modifierless) {
                    HotkeyButton.this.setValue(new ModifierlessKeybind(e));
                } else {
                    HotkeyButton.this.setValue(new Keybind(e));
                }
            }
        });
    }

    public void setValue(Keybind value) {
        if (value == null) {
            value = Keybind.NOT_SET;
        }
        this.value = value;
        this.setText(value.toString());
    }

    public Keybind getValue() {
        return this.value;
    }
}

