/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.config;

import java.awt.image.BufferedImage;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.MenuAction;
import net.runelite.client.config.ChatColorConfig;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.events.PluginChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.config.ConfigPanel;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Configuration", loadWhenOutdated=true, hidden=true)
public class ConfigPlugin
extends Plugin {
    @Inject
    private ClientUI clientUI;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ConfigManager configManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private ScheduledExecutorService executorService;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private ChatColorConfig chatColorConfig;
    private ConfigPanel configPanel;
    private NavigationButton navButton;

    @Override
    protected void startUp() throws Exception {
        this.configPanel = new ConfigPanel(this.pluginManager, this.configManager, this.executorService, this.runeLiteConfig, this.chatColorConfig);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), "config_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Configuration").icon(icon).priority(0).panel(this.configPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    @Override
    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onPluginChanged(PluginChanged event) {
        SwingUtilities.invokeLater(this.configPanel::refreshPluginList);
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked overlayMenuClicked) {
        OverlayMenuEntry overlayMenuEntry = overlayMenuClicked.getEntry();
        if (overlayMenuEntry.getMenuAction() == MenuAction.RUNELITE_OVERLAY_CONFIG) {
            Overlay overlay = overlayMenuClicked.getOverlay();
            Plugin plugin = overlay.getPlugin();
            if (plugin == null) {
                return;
            }
            PluginDescriptor descriptor = plugin.getClass().getAnnotation(PluginDescriptor.class);
            SwingUtilities.invokeLater(() -> {
                if (!this.navButton.isSelected()) {
                    this.navButton.getOnSelect().run();
                }
                this.configPanel.openConfigurationPanel(descriptor.name());
            });
        }
    }
}

