/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.config;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.runelite.client.config.ChatColorConfig;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigDescriptor;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigItemDescriptor;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.Keybind;
import net.runelite.client.config.ModifierlessKeybind;
import net.runelite.client.config.Range;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.config.HotkeyButton;
import net.runelite.client.plugins.config.PluginListItem;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.ComboBoxListRenderer;
import net.runelite.client.ui.components.IconButton;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(ConfigPanel.class);
    private static final int SPINNER_FIELD_WIDTH = 6;
    private static final int SCROLLBAR_WIDTH = 17;
    private static final int OFFSET = 6;
    private static final ImageIcon BACK_ICON;
    private static final ImageIcon BACK_ICON_HOVER;
    private static final String RUNELITE_GROUP_NAME;
    private static final String PINNED_PLUGINS_CONFIG_KEY = "pinnedPlugins";
    private static final String RUNELITE_PLUGIN = "RuneLite";
    private static final String CHAT_COLOR_PLUGIN = "Chat Color";
    private final PluginManager pluginManager;
    private final ConfigManager configManager;
    private final ScheduledExecutorService executorService;
    private final RuneLiteConfig runeLiteConfig;
    private final ChatColorConfig chatColorConfig;
    private final List<PluginListItem> pluginList = new ArrayList<PluginListItem>();
    private final IconTextField searchBar = new IconTextField();
    private final JPanel topPanel;
    private final JPanel mainPanel;
    private final JScrollPane scrollPane;
    private boolean showingPluginList = true;
    private int scrollBarPosition = 0;

    ConfigPanel(PluginManager pluginManager, ConfigManager configManager, ScheduledExecutorService executorService, RuneLiteConfig runeLiteConfig, ChatColorConfig chatColorConfig) {
        super(false);
        this.pluginManager = pluginManager;
        this.configManager = configManager;
        this.executorService = executorService;
        this.runeLiteConfig = runeLiteConfig;
        this.chatColorConfig = chatColorConfig;
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(205, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ConfigPanel.this.onSearchBarChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ConfigPanel.this.onSearchBarChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ConfigPanel.this.onSearchBarChanged();
            }
        });
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.topPanel = new JPanel();
        this.topPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.topPanel.setLayout(new BorderLayout(0, 6));
        this.add((Component)this.topPanel, "North");
        this.mainPanel = new FixedWidthPanel();
        this.mainPanel.setBorder(new EmptyBorder(8, 10, 10, 10));
        this.mainPanel.setLayout(new DynamicGridLayout(0, 1, 0, 5));
        this.mainPanel.setAlignmentX(0.0f);
        FixedWidthPanel northPanel = new FixedWidthPanel();
        northPanel.setLayout(new BorderLayout());
        northPanel.add((Component)this.mainPanel, "North");
        this.scrollPane = new JScrollPane(northPanel);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.scrollPane, "Center");
        this.initializePluginList();
        this.refreshPluginList();
    }

    private void initializePluginList() {
        List<String> pinnedPlugins = this.getPinnedPluginNames();
        this.pluginManager.getPlugins().stream().filter(plugin -> !plugin.getClass().getAnnotation(PluginDescriptor.class).hidden()).forEach(plugin -> {
            PluginDescriptor descriptor = plugin.getClass().getAnnotation(PluginDescriptor.class);
            Config config = this.pluginManager.getPluginConfigProxy((Plugin)plugin);
            ConfigDescriptor configDescriptor = config == null ? null : this.configManager.getConfigDescriptor(config);
            PluginListItem listItem = new PluginListItem(this, (Plugin)plugin, descriptor, config, configDescriptor);
            listItem.setPinned(pinnedPlugins.contains(listItem.getName()));
            this.pluginList.add(listItem);
        });
        PluginListItem runeLite = new PluginListItem(this, this.runeLiteConfig, this.configManager.getConfigDescriptor(this.runeLiteConfig), RUNELITE_PLUGIN, "RuneLite client settings", "client");
        runeLite.setPinned(pinnedPlugins.contains(RUNELITE_PLUGIN));
        this.pluginList.add(runeLite);
        PluginListItem chatColor = new PluginListItem(this, this.chatColorConfig, this.configManager.getConfigDescriptor(this.chatColorConfig), CHAT_COLOR_PLUGIN, "Recolor chat text", "colour", "messages");
        chatColor.setPinned(pinnedPlugins.contains(CHAT_COLOR_PLUGIN));
        this.pluginList.add(chatColor);
        this.pluginList.sort(Comparator.comparing(PluginListItem::getName));
    }

    void refreshPluginList() {
        this.pluginList.forEach(listItem -> {
            Plugin plugin = listItem.getPlugin();
            if (plugin != null) {
                listItem.setPluginEnabled(this.pluginManager.isPluginEnabled(plugin));
            }
        });
        if (this.showingPluginList) {
            this.openConfigList();
        }
    }

    void openConfigList() {
        if (this.showingPluginList) {
            this.scrollBarPosition = this.scrollPane.getVerticalScrollBar().getValue();
        }
        this.showingPluginList = true;
        this.topPanel.removeAll();
        this.mainPanel.removeAll();
        this.topPanel.add((Component)this.searchBar, "Center");
        this.onSearchBarChanged();
        this.searchBar.requestFocusInWindow();
        this.validate();
        this.scrollPane.getVerticalScrollBar().setValue(this.scrollBarPosition);
    }

    private void onSearchBarChanged() {
        String text = this.searchBar.getText();
        this.pluginList.forEach(this.mainPanel::remove);
        this.showMatchingPlugins(true, text);
        this.showMatchingPlugins(false, text);
        this.revalidate();
    }

    private void showMatchingPlugins(boolean pinned, String text) {
        if (text.isEmpty()) {
            this.pluginList.stream().filter(item -> pinned == item.isPinned()).forEach(this.mainPanel::add);
            return;
        }
        String[] searchTerms = text.toLowerCase().split(" ");
        this.pluginList.forEach(listItem -> {
            if (pinned == listItem.isPinned() && listItem.matchesSearchTerms(searchTerms)) {
                this.mainPanel.add((Component)listItem);
            }
        });
    }

    void openGroupConfigPanel(final PluginListItem listItem, final Config config, final ConfigDescriptor cd) {
        this.showingPluginList = false;
        this.scrollBarPosition = this.scrollPane.getVerticalScrollBar().getValue();
        this.topPanel.removeAll();
        this.mainPanel.removeAll();
        IconButton topPanelBackButton = new IconButton(BACK_ICON, BACK_ICON_HOVER);
        topPanelBackButton.setPreferredSize(new Dimension(22, 0));
        topPanelBackButton.setBorder(new EmptyBorder(0, 0, 0, 5));
        topPanelBackButton.addActionListener(e -> this.openConfigList());
        topPanelBackButton.setToolTipText("Back");
        this.topPanel.add((Component)topPanelBackButton, "West");
        this.topPanel.add((Component)listItem.createToggleButton(), "East");
        String name = listItem.getName();
        JLabel title = new JLabel(name);
        title.setForeground(Color.WHITE);
        title.setToolTipText("<html>" + name + ":<br>" + listItem.getDescription() + "</html>");
        this.topPanel.add(title);
        for (final ConfigItemDescriptor cid : cd.getItems()) {
            if (cid.getItem().hidden()) continue;
            JPanel item = new JPanel();
            item.setLayout(new BorderLayout());
            item.setMinimumSize(new Dimension(225, 0));
            name = cid.getItem().name();
            JLabel configEntryName = new JLabel(name);
            configEntryName.setForeground(Color.WHITE);
            configEntryName.setToolTipText("<html>" + name + ":<br>" + cid.getItem().description() + "</html>");
            item.add((Component)configEntryName, "Center");
            if (cid.getType() == Boolean.TYPE) {
                JCheckBox checkbox = new JCheckBox();
                checkbox.setBackground(ColorScheme.LIGHT_GRAY_COLOR);
                checkbox.setSelected(Boolean.parseBoolean(this.configManager.getConfiguration(cd.getGroup().value(), cid.getItem().keyName())));
                checkbox.addActionListener(ae -> this.changeConfiguration(listItem, config, checkbox, cd, cid));
                item.add((Component)checkbox, "East");
            }
            if (cid.getType() == Integer.TYPE) {
                int value = Integer.parseInt(this.configManager.getConfiguration(cd.getGroup().value(), cid.getItem().keyName()));
                Range range = cid.getRange();
                int min = 0;
                int max = Integer.MAX_VALUE;
                if (range != null) {
                    min = range.min();
                    max = range.max();
                }
                value = Ints.constrainToRange(value, min, max);
                SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, 1);
                JSpinner spinner = new JSpinner(model);
                JComponent editor = spinner.getEditor();
                JFormattedTextField spinnerTextField = ((JSpinner.DefaultEditor)editor).getTextField();
                spinnerTextField.setColumns(6);
                spinner.addChangeListener(ce -> this.changeConfiguration(listItem, config, spinner, cd, cid));
                item.add((Component)spinner, "East");
            }
            if (cid.getType() == String.class) {
                JTextComponent textField;
                if (cid.getItem().secret()) {
                    textField = new JPasswordField();
                } else {
                    JTextArea textArea = new JTextArea();
                    textArea.setLineWrap(true);
                    textArea.setWrapStyleWord(true);
                    textField = textArea;
                }
                textField.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                textField.setText(this.configManager.getConfiguration(cd.getGroup().value(), cid.getItem().keyName()));
                textField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        ConfigPanel.this.changeConfiguration(listItem, config, textField, cd, cid);
                    }
                });
                item.add((Component)textField, "South");
            }
            if (cid.getType() == Color.class) {
                JButton colorPickerBtn;
                Color existingColor;
                String existing = this.configManager.getConfiguration(cd.getGroup().value(), cid.getItem().keyName());
                if (existing == null) {
                    existingColor = Color.BLACK;
                    colorPickerBtn = new JButton("Pick a color");
                } else {
                    existingColor = ColorUtil.fromString(existing);
                    colorPickerBtn = new JButton(ColorUtil.toHexColor(existingColor).toUpperCase());
                }
                colorPickerBtn.setFocusable(false);
                colorPickerBtn.setBackground(existingColor);
                colorPickerBtn.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        final RuneliteColorPicker colorPicker = new RuneliteColorPicker(SwingUtilities.windowForComponent(ConfigPanel.this), colorPickerBtn.getBackground(), cid.getItem().name(), cid.getAlpha() == null);
                        colorPicker.setLocation(ConfigPanel.this.getLocationOnScreen());
                        colorPicker.setOnColorChange(c -> {
                            colorPickerBtn.setBackground((Color)c);
                            colorPickerBtn.setText(ColorUtil.toHexColor(c).toUpperCase());
                        });
                        colorPicker.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                ConfigPanel.this.changeConfiguration(listItem, config, colorPicker, cd, cid);
                            }
                        });
                        colorPicker.setVisible(true);
                    }
                });
                item.add((Component)colorPickerBtn, "East");
            }
            if (cid.getType() == Dimension.class) {
                JPanel dimensionPanel = new JPanel();
                dimensionPanel.setLayout(new BorderLayout());
                String str = this.configManager.getConfiguration(cd.getGroup().value(), cid.getItem().keyName());
                String[] splitStr = str.split("x");
                int width = Integer.parseInt(splitStr[0]);
                int height = Integer.parseInt(splitStr[1]);
                SpinnerNumberModel widthModel = new SpinnerNumberModel(width, 0, Integer.MAX_VALUE, 1);
                JSpinner widthSpinner = new JSpinner(widthModel);
                JComponent widthEditor = widthSpinner.getEditor();
                JFormattedTextField widthSpinnerTextField = ((JSpinner.DefaultEditor)widthEditor).getTextField();
                widthSpinnerTextField.setColumns(4);
                SpinnerNumberModel heightModel = new SpinnerNumberModel(height, 0, Integer.MAX_VALUE, 1);
                JSpinner heightSpinner = new JSpinner(heightModel);
                JComponent heightEditor = heightSpinner.getEditor();
                JFormattedTextField heightSpinnerTextField = ((JSpinner.DefaultEditor)heightEditor).getTextField();
                heightSpinnerTextField.setColumns(4);
                ChangeListener listener = e -> this.configManager.setConfiguration(cd.getGroup().value(), cid.getItem().keyName(), widthSpinner.getValue() + "x" + heightSpinner.getValue());
                widthSpinner.addChangeListener(listener);
                heightSpinner.addChangeListener(listener);
                dimensionPanel.add((Component)widthSpinner, "West");
                dimensionPanel.add((Component)new JLabel(" x "), "Center");
                dimensionPanel.add((Component)heightSpinner, "East");
                item.add((Component)dimensionPanel, "East");
            }
            if (cid.getType().isEnum()) {
                Class<?> type = cid.getType();
                JComboBox box = new JComboBox(type.getEnumConstants());
                box.setPreferredSize(new Dimension(box.getPreferredSize().width, 25));
                box.setRenderer(new ComboBoxListRenderer());
                box.setForeground(Color.WHITE);
                box.setFocusable(false);
                box.setPrototypeDisplayValue("XXXXXXXX");
                try {
                    Object selectedItem = Enum.valueOf(type, this.configManager.getConfiguration(cd.getGroup().value(), cid.getItem().keyName()));
                    box.setSelectedItem(selectedItem);
                    box.setToolTipText(((Enum)selectedItem).toString());
                }
                catch (IllegalArgumentException ex) {
                    log.debug("invalid seleced item", ex);
                }
                box.addItemListener(e -> {
                    if (e.getStateChange() == 1) {
                        this.changeConfiguration(listItem, config, box, cd, cid);
                        box.setToolTipText(box.getSelectedItem().toString());
                    }
                });
                item.add(box, "East");
            }
            if (cid.getType() == Keybind.class || cid.getType() == ModifierlessKeybind.class) {
                Keybind startingValue = (Keybind)this.configManager.getConfiguration(cd.getGroup().value(), cid.getItem().keyName(), cid.getType());
                final HotkeyButton button = new HotkeyButton(startingValue, cid.getType() == ModifierlessKeybind.class);
                button.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        ConfigPanel.this.changeConfiguration(listItem, config, button, cd, cid);
                    }
                });
                item.add((Component)button, "East");
            }
            this.mainPanel.add(item);
        }
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(e -> {
            int result = JOptionPane.showOptionDialog(resetButton, "Are you sure you want to reset this plugin's configuration?", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
            if (result == 0) {
                this.configManager.setDefaultConfiguration(config, true);
                this.openGroupConfigPanel(listItem, config, cd);
            }
        });
        this.mainPanel.add(resetButton);
        JButton backButton = new JButton("Back");
        backButton.addActionListener(e -> this.openConfigList());
        this.mainPanel.add(backButton);
        this.revalidate();
        this.scrollPane.getVerticalScrollBar().setValue(0);
    }

    private void changeConfiguration(PluginListItem listItem, Config config, Component component, ConfigDescriptor cd, ConfigItemDescriptor cid) {
        int result;
        ConfigItem configItem = cid.getItem();
        if (!Strings.isNullOrEmpty(configItem.warning()) && (result = JOptionPane.showOptionDialog(component, configItem.warning(), "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No")) != 0) {
            this.openGroupConfigPanel(listItem, config, cd);
            return;
        }
        if (component instanceof JCheckBox) {
            JCheckBox checkbox = (JCheckBox)component;
            this.configManager.setConfiguration(cd.getGroup().value(), cid.getItem().keyName(), "" + checkbox.isSelected());
        } else if (component instanceof JSpinner) {
            JSpinner spinner = (JSpinner)component;
            this.configManager.setConfiguration(cd.getGroup().value(), cid.getItem().keyName(), "" + spinner.getValue());
        } else if (component instanceof JTextComponent) {
            JTextComponent textField = (JTextComponent)component;
            this.configManager.setConfiguration(cd.getGroup().value(), cid.getItem().keyName(), textField.getText());
        } else if (component instanceof RuneliteColorPicker) {
            RuneliteColorPicker colorPicker = (RuneliteColorPicker)component;
            this.configManager.setConfiguration(cd.getGroup().value(), cid.getItem().keyName(), "" + colorPicker.getSelectedColor().getRGB());
        } else if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            this.configManager.setConfiguration(cd.getGroup().value(), cid.getItem().keyName(), ((Enum)jComboBox.getSelectedItem()).name());
        } else if (component instanceof HotkeyButton) {
            HotkeyButton hotkeyButton = (HotkeyButton)component;
            this.configManager.setConfiguration(cd.getGroup().value(), cid.getItem().keyName(), hotkeyButton.getValue());
        }
    }

    void startPlugin(Plugin plugin, PluginListItem listItem) {
        this.executorService.submit(() -> {
            this.pluginManager.setPluginEnabled(plugin, true);
            try {
                this.pluginManager.startPlugin(plugin);
            }
            catch (PluginInstantiationException ex) {
                log.warn("Error when starting plugin {}", (Object)plugin.getClass().getSimpleName(), (Object)ex);
            }
            listItem.setPluginEnabled(true);
        });
    }

    void stopPlugin(Plugin plugin, PluginListItem listItem) {
        this.executorService.submit(() -> {
            this.pluginManager.setPluginEnabled(plugin, false);
            try {
                this.pluginManager.stopPlugin(plugin);
            }
            catch (PluginInstantiationException ex) {
                log.warn("Error when stopping plugin {}", (Object)plugin.getClass().getSimpleName(), (Object)ex);
            }
            listItem.setPluginEnabled(false);
        });
    }

    private List<String> getPinnedPluginNames() {
        String config = this.configManager.getConfiguration(RUNELITE_GROUP_NAME, PINNED_PLUGINS_CONFIG_KEY);
        if (config == null) {
            return Collections.emptyList();
        }
        return Text.fromCSV(config);
    }

    void savePinnedPlugins() {
        String value = this.pluginList.stream().filter(PluginListItem::isPinned).map(PluginListItem::getName).collect(Collectors.joining(","));
        this.configManager.setConfiguration(RUNELITE_GROUP_NAME, PINNED_PLUGINS_CONFIG_KEY, value);
    }

    void openConfigurationPanel(String configGroup) {
        for (PluginListItem pluginListItem : this.pluginList) {
            if (!pluginListItem.getName().equals(configGroup)) continue;
            this.openGroupConfigPanel(pluginListItem, pluginListItem.getConfig(), pluginListItem.getConfigDescriptor());
            break;
        }
    }

    @Override
    public void onActivate() {
        super.onActivate();
        if (this.searchBar.getParent() != null) {
            this.searchBar.requestFocusInWindow();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(242, super.getPreferredSize().height);
    }

    static {
        RUNELITE_GROUP_NAME = RuneLiteConfig.class.getAnnotation(ConfigGroup.class).value();
        BufferedImage backIcon = ImageUtil.getResourceStreamFromClass(ConfigPanel.class, "config_back_icon.png");
        BACK_ICON = new ImageIcon(backIcon);
        BACK_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset(backIcon, -100));
    }

    private class FixedWidthPanel
    extends JPanel {
        private FixedWidthPanel() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(225, super.getPreferredSize().height);
        }
    }
}

