/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.combatlevel;

import com.google.inject.Provides;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.WorldType;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.combatlevel.CombatLevelConfig;
import net.runelite.client.plugins.combatlevel.CombatLevelOverlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Combat Level", description="Show a more accurate combat level in Combat Options panel and other combat level functions", tags={"wilderness", "attack", "range"})
public class CombatLevelPlugin
extends Plugin {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.###");
    private static final String CONFIG_GROUP = "combatlevel";
    private static final String ATTACK_RANGE_CONFIG_KEY = "wildernessAttackLevelRange";
    private static final Pattern WILDERNESS_LEVEL_PATTERN = Pattern.compile("^Level: (\\d+)$");
    private static final int SKULL_CONTAINER_ADJUSTED_ORIGINAL_Y = 6;
    private static final int WILDERNESS_LEVEL_TEXT_ADJUSTED_ORIGINAL_Y = 3;
    private static final int MIN_COMBAT_LEVEL = 3;
    private int originalWildernessLevelTextPosition = -1;
    private int originalSkullContainerPosition = -1;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private CombatLevelConfig config;
    @Inject
    private CombatLevelOverlay overlay;
    @Inject
    private OverlayManager overlayManager;

    @Provides
    CombatLevelConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(CombatLevelConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        if (this.config.wildernessAttackLevelRange()) {
            this.appendAttackLevelRangeText();
        }
    }

    @Override
    protected void shutDown() throws Exception {
        String widgetText;
        this.overlayManager.remove(this.overlay);
        Widget combatLevelWidget = this.client.getWidget(WidgetInfo.COMBAT_LEVEL);
        if (combatLevelWidget != null && (widgetText = combatLevelWidget.getText()).contains(".")) {
            combatLevelWidget.setText(widgetText.substring(0, widgetText.indexOf(".")));
        }
        this.shutDownAttackLevelRange();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        Widget combatLevelWidget = this.client.getWidget(WidgetInfo.COMBAT_LEVEL);
        if (combatLevelWidget == null) {
            return;
        }
        double combatLevelPrecise = Experience.getCombatLevelPrecise(this.client.getRealSkillLevel(Skill.ATTACK), this.client.getRealSkillLevel(Skill.STRENGTH), this.client.getRealSkillLevel(Skill.DEFENCE), this.client.getRealSkillLevel(Skill.HITPOINTS), this.client.getRealSkillLevel(Skill.MAGIC), this.client.getRealSkillLevel(Skill.RANGED), this.client.getRealSkillLevel(Skill.PRAYER));
        combatLevelWidget.setText("Combat Lvl: " + DECIMAL_FORMAT.format(combatLevelPrecise));
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!CONFIG_GROUP.equals(event.getGroup()) || !ATTACK_RANGE_CONFIG_KEY.equals(event.getKey())) {
            return;
        }
        if (this.config.wildernessAttackLevelRange()) {
            this.appendAttackLevelRangeText();
        } else {
            this.shutDownAttackLevelRange();
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (this.config.wildernessAttackLevelRange() && "wildernessWidgetTextSet".equals(event.getEventName())) {
            this.appendAttackLevelRangeText();
        }
    }

    private void appendAttackLevelRangeText() {
        Widget wildernessLevelWidget = this.client.getWidget(WidgetInfo.PVP_WILDERNESS_LEVEL);
        if (wildernessLevelWidget == null) {
            return;
        }
        String wildernessLevelText = wildernessLevelWidget.getText();
        Matcher m = WILDERNESS_LEVEL_PATTERN.matcher(wildernessLevelText);
        if (!m.matches() || WorldType.isPvpWorld(this.client.getWorldType())) {
            return;
        }
        Widget skullContainer = this.client.getWidget(WidgetInfo.PVP_SKULL_CONTAINER);
        if (this.originalWildernessLevelTextPosition == -1) {
            this.originalWildernessLevelTextPosition = wildernessLevelWidget.getOriginalY();
        }
        if (this.originalSkullContainerPosition == -1) {
            this.originalSkullContainerPosition = skullContainer.getRelativeY();
        }
        int wildernessLevel = Integer.parseInt(m.group(1));
        int combatLevel = this.client.getLocalPlayer().getCombatLevel();
        wildernessLevelWidget.setText(wildernessLevelText + "<br>" + CombatLevelPlugin.combatAttackRange(combatLevel, wildernessLevel));
        wildernessLevelWidget.setOriginalY(3);
        skullContainer.setOriginalY(6);
        this.clientThread.invoke(wildernessLevelWidget::revalidate);
        this.clientThread.invoke(skullContainer::revalidate);
    }

    private void shutDownAttackLevelRange() {
        if (WorldType.isPvpWorld(this.client.getWorldType())) {
            return;
        }
        Widget wildernessLevelWidget = this.client.getWidget(WidgetInfo.PVP_WILDERNESS_LEVEL);
        if (wildernessLevelWidget != null) {
            String wildernessLevelText = wildernessLevelWidget.getText();
            if (wildernessLevelText.contains("<br>")) {
                wildernessLevelWidget.setText(wildernessLevelText.substring(0, wildernessLevelText.indexOf("<br>")));
            }
            wildernessLevelWidget.setOriginalY(this.originalWildernessLevelTextPosition);
            this.clientThread.invoke(wildernessLevelWidget::revalidate);
        }
        this.originalWildernessLevelTextPosition = -1;
        Widget skullContainer = this.client.getWidget(WidgetInfo.PVP_SKULL_CONTAINER);
        if (skullContainer != null) {
            skullContainer.setOriginalY(this.originalSkullContainerPosition);
            this.clientThread.invoke(skullContainer::revalidate);
        }
        this.originalSkullContainerPosition = -1;
    }

    private static String combatAttackRange(int combatLevel, int wildernessLevel) {
        return Math.max(3, combatLevel - wildernessLevel) + "-" + Math.min(126, combatLevel + wildernessLevel);
    }
}

