/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.combatlevel;

import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.combatlevel.CombatLevelConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;

class CombatLevelOverlay
extends Overlay {
    private static final Color COMBAT_LEVEL_COLOUR = new Color(16750623);
    private static final double PRAY_MULT = 0.125;
    static final double ATT_STR_MULT = 0.325;
    static final double DEF_HP_MULT = 0.25;
    static final double RANGE_MAGIC_LEVEL_MULT = 1.5;
    static final double RANGE_MAGIC_MULT = 0.325;
    private final Client client;
    private final CombatLevelConfig config;
    private final TooltipManager tooltipManager;

    @Inject
    private CombatLevelOverlay(Client client2, CombatLevelConfig config, TooltipManager tooltipManager) {
        this.client = client2;
        this.config = config;
        this.tooltipManager = tooltipManager;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Widget combatLevelWidget = this.client.getWidget(WidgetInfo.COMBAT_LEVEL);
        if (!this.config.showLevelsUntil() || this.client.getLocalPlayer().getCombatLevel() == 126 || combatLevelWidget == null || combatLevelWidget.isHidden()) {
            return null;
        }
        Rectangle combatCanvas = combatLevelWidget.getBounds();
        if (combatCanvas == null) {
            return null;
        }
        if (combatCanvas.contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            this.tooltipManager.add(new Tooltip(this.getLevelsUntilTooltip()));
        }
        return null;
    }

    private String getLevelsUntilTooltip() {
        int attackLevel = this.client.getRealSkillLevel(Skill.ATTACK);
        int strengthLevel = this.client.getRealSkillLevel(Skill.STRENGTH);
        int defenceLevel = this.client.getRealSkillLevel(Skill.DEFENCE);
        int hitpointsLevel = this.client.getRealSkillLevel(Skill.HITPOINTS);
        int magicLevel = this.client.getRealSkillLevel(Skill.MAGIC);
        int rangedLevel = this.client.getRealSkillLevel(Skill.RANGED);
        int prayerLevel = this.client.getRealSkillLevel(Skill.PRAYER);
        double base = 0.25 * ((double)(defenceLevel + hitpointsLevel) + Math.floor(prayerLevel / 2));
        double melee = 0.325 * (double)(attackLevel + strengthLevel);
        double range = 0.325 * Math.floor((double)rangedLevel * 1.5);
        double mage = 0.325 * Math.floor((double)magicLevel * 1.5);
        double max = Math.max(melee, Math.max(range, mage));
        int next = this.client.getLocalPlayer().getCombatLevel() + 1;
        int meleeNeed = CombatLevelOverlay.calcLevels(base + melee, next, 0.325);
        int hpdefNeed = CombatLevelOverlay.calcLevels(base + max, next, 0.25);
        int prayNeed = CombatLevelOverlay.calcLevelsPray(base + max, next, prayerLevel);
        int rangeNeed = CombatLevelOverlay.calcLevelsRM(rangedLevel, next, base);
        int magicNeed = CombatLevelOverlay.calcLevelsRM(magicLevel, next, base);
        StringBuilder sb = new StringBuilder();
        sb.append(ColorUtil.wrapWithColorTag("Next combat level:</br>", COMBAT_LEVEL_COLOUR));
        if (attackLevel + strengthLevel + meleeNeed <= 198) {
            sb.append(meleeNeed).append(" Attack/Strength</br>");
        }
        if (hitpointsLevel + defenceLevel + hpdefNeed <= 198) {
            sb.append(hpdefNeed).append(" Defence/Hitpoints</br>");
        }
        if (rangedLevel + rangeNeed <= 99) {
            sb.append(rangeNeed).append(" Ranged</br>");
        }
        if (magicLevel + magicNeed <= 99) {
            sb.append(magicNeed).append(" Magic</br>");
        }
        if (prayerLevel + prayNeed <= 99) {
            sb.append(prayNeed).append(" Prayer");
        }
        return sb.toString();
    }

    @VisibleForTesting
    static int calcLevels(double start, int end, double multiple) {
        return (int)Math.ceil(CombatLevelOverlay.calcMultipliedLevels(start, end, multiple));
    }

    @VisibleForTesting
    static int calcLevelsPray(double start, int end, int prayerLevel) {
        int neededLevels = (int)Math.floor(CombatLevelOverlay.calcMultipliedLevels(start, end, 0.125));
        if ((prayerLevel + neededLevels) % 2 != 0) {
            return neededLevels + 1;
        }
        return neededLevels;
    }

    private static double calcMultipliedLevels(double start, int end, double multiple) {
        return ((double)end - start) / multiple;
    }

    @VisibleForTesting
    static int calcLevelsRM(double start, int end, double dhp) {
        start = Math.floor(start * 1.5) * 0.325;
        return (int)Math.ceil(((double)end - dhp - start) / 0.48750000000000004);
    }
}

