/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cluescrolls.clues.hotcold;

import com.google.common.annotations.VisibleForTesting;
import java.awt.Rectangle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.cluescrolls.clues.hotcold.HotColdLocation;
import net.runelite.client.plugins.cluescrolls.clues.hotcold.HotColdTemperature;
import net.runelite.client.plugins.cluescrolls.clues.hotcold.HotColdTemperatureChange;

public class HotColdSolver {
    private final Set<HotColdLocation> possibleLocations;
    @Nullable
    private WorldPoint lastWorldPoint;

    public HotColdSolver(Set<HotColdLocation> possibleLocations) {
        this.possibleLocations = possibleLocations;
    }

    public Set<HotColdLocation> signal(@Nonnull WorldPoint worldPoint, @Nonnull HotColdTemperature temperature, @Nullable HotColdTemperatureChange temperatureChange) {
        int maxSquaresAway = temperature.getMaxDistance();
        int minSquaresAway = temperature.getMinDistance();
        Rectangle maxDistanceArea = new Rectangle(worldPoint.getX() - maxSquaresAway, worldPoint.getY() - maxSquaresAway, 2 * maxSquaresAway + 1, 2 * maxSquaresAway + 1);
        Rectangle minDistanceArea = new Rectangle(worldPoint.getX() - minSquaresAway, worldPoint.getY() - minSquaresAway, 2 * minSquaresAway + 1, 2 * minSquaresAway + 1);
        this.possibleLocations.removeIf(entry -> minDistanceArea.contains(entry.getRect()) || !maxDistanceArea.intersects(entry.getRect()));
        if (this.lastWorldPoint != null && temperatureChange != null) {
            switch (temperatureChange) {
                case COLDER: {
                    this.possibleLocations.removeIf(entry -> HotColdSolver.isFirstPointCloserRect(worldPoint, this.lastWorldPoint, entry.getRect()));
                    break;
                }
                case WARMER: {
                    this.possibleLocations.removeIf(entry -> HotColdSolver.isFirstPointCloserRect(this.lastWorldPoint, worldPoint, entry.getRect()));
                    break;
                }
            }
        }
        this.lastWorldPoint = worldPoint;
        return this.getPossibleLocations();
    }

    @VisibleForTesting
    static boolean isFirstPointCloserRect(WorldPoint firstPoint, WorldPoint secondPoint, Rectangle rect) {
        WorldPoint nePoint = new WorldPoint(rect.x + rect.width, rect.y + rect.height, 0);
        if (!HotColdSolver.isFirstPointCloser(firstPoint, secondPoint, nePoint)) {
            return false;
        }
        WorldPoint sePoint = new WorldPoint(rect.x + rect.width, rect.y, 0);
        if (!HotColdSolver.isFirstPointCloser(firstPoint, secondPoint, sePoint)) {
            return false;
        }
        WorldPoint nwPoint = new WorldPoint(rect.x, rect.y + rect.height, 0);
        if (!HotColdSolver.isFirstPointCloser(firstPoint, secondPoint, nwPoint)) {
            return false;
        }
        WorldPoint swPoint = new WorldPoint(rect.x, rect.y, 0);
        return HotColdSolver.isFirstPointCloser(firstPoint, secondPoint, swPoint);
    }

    @VisibleForTesting
    static boolean isFirstPointCloser(WorldPoint firstPoint, WorldPoint secondPoint, WorldPoint worldPoint) {
        return firstPoint.distanceTo2D(worldPoint) < secondPoint.distanceTo2D(worldPoint);
    }

    public Set<HotColdLocation> getPossibleLocations() {
        return this.possibleLocations;
    }

    @Nullable
    public WorldPoint getLastWorldPoint() {
        return this.lastWorldPoint;
    }
}

