/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cluescrolls.clues.emote;

import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.client.plugins.cluescrolls.clues.emote.ItemRequirement;

public class RangeItemRequirement
implements ItemRequirement {
    private String name;
    private int startItemId;
    private int endItemId;

    public RangeItemRequirement(String name, int startItemId, int endItemId) {
        this.name = name;
        this.startItemId = startItemId;
        this.endItemId = endItemId;
    }

    @Override
    public boolean fulfilledBy(int itemId) {
        return itemId >= this.startItemId && itemId <= this.endItemId;
    }

    @Override
    public boolean fulfilledBy(Item[] items) {
        for (Item item : items) {
            if (item.getId() < this.startItemId || item.getId() > this.endItemId) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCollectiveName(Client client2) {
        return this.name;
    }
}

