/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cluescrolls.clues;

import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Set;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Point;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.cluescrolls.ClueScrollPlugin;
import net.runelite.client.plugins.cluescrolls.ClueScrollWorldOverlay;
import net.runelite.client.plugins.cluescrolls.clues.ClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.ObjectClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.emote.ItemRequirement;
import net.runelite.client.plugins.cluescrolls.clues.emote.SingleItemRequirement;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class MapClue
extends ClueScroll
implements ObjectClueScroll {
    private static final Set<MapClue> CLUES = ImmutableSet.of(new MapClue(87, new WorldPoint(3300, 3291, 0)), new MapClue(346, new WorldPoint(3166, 3361, 0)), new MapClue(347, new WorldPoint(3290, 3374, 0)), new MapClue(351, new WorldPoint(3043, 3398, 0)), new MapClue(354, new WorldPoint(2612, 3482, 0)), new MapClue(356, new WorldPoint(3110, 3152, 0)), new MapClue[]{new MapClue(337, new WorldPoint(2970, 3415, 0)), new MapClue(348, new WorldPoint(3091, 3227, 0)), new MapClue(352, new WorldPoint(2907, 3295, 0)), new MapClue(355, new WorldPoint(2658, 3488, 0), 357), new MapClue(360, new WorldPoint(2651, 3231, 0)), new MapClue(361, new WorldPoint(2565, 3248, 0), 354), new MapClue(362, new WorldPoint(2924, 3210, 0)), new MapClue(340, new WorldPoint(2536, 3865, 0)), new MapClue(341, new WorldPoint(3434, 3265, 0)), new MapClue(342, new WorldPoint(2454, 3230, 0)), new MapClue(343, new WorldPoint(2578, 3597, 0)), new MapClue(344, new WorldPoint(2666, 3562, 0)), new MapClue(350, new WorldPoint(3309, 3503, 0), 2620), new MapClue(2729, new WorldPoint(3190, 3963, 0)), new MapClue(353, new WorldPoint(2615, 3078, 0)), new MapClue(357, new WorldPoint(2488, 3308, 0)), new MapClue(358, new WorldPoint(2457, 3182, 0), 18506), new MapClue(359, new WorldPoint(3026, 3628, 0), 354), new MapClue(338, new WorldPoint(3021, 3912, 0)), new MapClue(339, new WorldPoint(2722, 3338, 0)), new MapClue(86, new WorldPoint(2449, 3130, 0)), new MapClue(314, new WorldPoint(2953, 9523, 1), "In the Mogre Camp, near Port Khazard. You require a Diving Apparatus and a Fishbowl Helmet"), new MapClue(317, new WorldPoint(2202, 3062, 0)), new MapClue(318, new WorldPoint(1815, 3852, 0)), new MapClue(316, new WorldPoint(3538, 3208, 0)), new MapClue(102, new WorldPoint(2703, 2716, 0), 6616)});
    private static final ItemRequirement HAS_SPADE = new SingleItemRequirement(952);
    private final int interfaceId;
    private final WorldPoint location;
    private final int objectId;
    private final String description;

    private MapClue(int interfaceId, WorldPoint location) {
        this(interfaceId, location, -1);
    }

    private MapClue(int interfaceId, WorldPoint location, int objectId) {
        this(interfaceId, location, objectId, null);
    }

    private MapClue(int interfaceId, WorldPoint location, String description) {
        this(interfaceId, location, -1, description);
    }

    private MapClue(int interfaceId, WorldPoint location, int objectId, String description) {
        this.interfaceId = interfaceId;
        this.location = location;
        this.objectId = objectId;
        this.description = description;
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, ClueScrollPlugin plugin) {
        panelComponent.getChildren().add(TitleComponent.builder().text("Map Clue").build());
        panelComponent.getChildren().add(LineComponent.builder().left("Click the clue scroll along the edge of your world map to see your destination.").build());
        if (this.objectId != -1) {
            ObjectComposition objectToClick = plugin.getClient().getObjectDefinition(this.getObjectId());
            String objectName = "N/A";
            if (objectToClick != null) {
                objectName = objectToClick.getName();
            }
            panelComponent.getChildren().add(LineComponent.builder().left("Travel to the destination and click the " + objectName + ".").build());
        } else {
            panelComponent.getChildren().add(LineComponent.builder().left("Travel to the destination and dig on the marked tile.").build());
        }
        if (this.description != null) {
            panelComponent.getChildren().add(LineComponent.builder().build());
            panelComponent.getChildren().add(LineComponent.builder().left(this.description).build());
        }
        if (this.objectId == -1 && plugin.getInventoryItems() != null && !HAS_SPADE.fulfilledBy(plugin.getInventoryItems())) {
            panelComponent.getChildren().add(LineComponent.builder().left("").build());
            panelComponent.getChildren().add(LineComponent.builder().left("Requires Spade!").leftColor(Color.RED).build());
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, ClueScrollPlugin plugin) {
        LocalPoint localLocation = LocalPoint.fromWorld(plugin.getClient(), this.getLocation());
        if (localLocation == null) {
            return;
        }
        if (this.objectId != -1) {
            Point mousePosition = plugin.getClient().getMouseCanvasPosition();
            if (plugin.getObjectsToMark() != null) {
                for (TileObject gameObject : plugin.getObjectsToMark()) {
                    OverlayUtil.renderHoverableArea(graphics, gameObject.getClickbox(), mousePosition, ClueScrollWorldOverlay.CLICKBOX_FILL_COLOR, ClueScrollWorldOverlay.CLICKBOX_BORDER_COLOR, ClueScrollWorldOverlay.CLICKBOX_HOVER_BORDER_COLOR);
                    OverlayUtil.renderImageLocation(plugin.getClient(), graphics, gameObject.getLocalLocation(), plugin.getClueScrollImage(), 30);
                }
            }
        } else {
            OverlayUtil.renderTileOverlay(plugin.getClient(), graphics, localLocation, plugin.getSpadeImage(), Color.ORANGE);
        }
    }

    public static MapClue forInterfaceId(int interfaceId) {
        for (MapClue clue : CLUES) {
            if (clue.interfaceId != interfaceId) continue;
            return clue;
        }
        return null;
    }

    @Override
    public int[] getObjectIds() {
        return new int[]{this.objectId};
    }

    public int getInterfaceId() {
        return this.interfaceId;
    }

    @Override
    public WorldPoint getLocation() {
        return this.location;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public String getDescription() {
        return this.description;
    }
}

