/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cluescrolls.clues;

import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Set;
import javax.annotation.Nonnull;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Item;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.cluescrolls.ClueScrollOverlay;
import net.runelite.client.plugins.cluescrolls.ClueScrollPlugin;
import net.runelite.client.plugins.cluescrolls.clues.ClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.LocationClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.TextClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.emote.AllRequirementsCollection;
import net.runelite.client.plugins.cluescrolls.clues.emote.AnyRequirementCollection;
import net.runelite.client.plugins.cluescrolls.clues.emote.Emote;
import net.runelite.client.plugins.cluescrolls.clues.emote.ItemRequirement;
import net.runelite.client.plugins.cluescrolls.clues.emote.RangeItemRequirement;
import net.runelite.client.plugins.cluescrolls.clues.emote.SingleItemRequirement;
import net.runelite.client.plugins.cluescrolls.clues.emote.SlotLimitationRequirement;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class EmoteClue
extends ClueScroll
implements TextClueScroll,
LocationClueScroll {
    private static final Set<EmoteClue> CLUES = ImmutableSet.of(new EmoteClue("Beckon on the east coast of the Kharazi Jungle. Beware of double agents! Equip any vestment stole and a heraldic rune shield.", (Integer)29019, new WorldPoint(2954, 2933, 0), Emote.BECKON, EmoteClue.any("Any stole", EmoteClue.item(10472), EmoteClue.item(10470), EmoteClue.item(10474), EmoteClue.item(12257), EmoteClue.item(12269), EmoteClue.item(12201)), EmoteClue.any("Any heraldic rune shield", EmoteClue.item(7336), EmoteClue.item(7342), EmoteClue.item(7348), EmoteClue.item(7354), EmoteClue.item(7360))), new EmoteClue("Cheer in the Barbarian Agility Arena. Headbang before you talk to me. Equip a steel platebody, maple shortbow and a Wilderness cape.", (Integer)28992, new WorldPoint(2552, 3556, 0), Emote.CHEER, Emote.HEADBANG, EmoteClue.item(1119), EmoteClue.item(853), EmoteClue.range("Any team cape", 4315, 4413)), new EmoteClue("Bow upstairs in the Edgeville Monastery. Equip a completed prayer book.", (Integer)29029, new WorldPoint(3056, 3484, 1), Emote.BOW, EmoteClue.any("Any god book", EmoteClue.item(3840), EmoteClue.item(3844), EmoteClue.item(3842), EmoteClue.item(12610), EmoteClue.item(12608), EmoteClue.item(12612))), new EmoteClue("Cheer in the Shadow dungeon. Equip a rune crossbow, climbing boots and any mitre.", (Integer)29027, new WorldPoint(2629, 5071, 0), Emote.CHEER, EmoteClue.any("Any mitre", EmoteClue.item(10454), EmoteClue.item(10452), EmoteClue.item(10456), EmoteClue.item(12203), EmoteClue.item(12271), EmoteClue.item(12259)), EmoteClue.item(9185), EmoteClue.item(3105), EmoteClue.item(4657)), new EmoteClue("Cheer at the top of the agility pyramid. Beware of double agents! Equip a blue mystic robe top, and any rune heraldic shield.", (Integer)29022, new WorldPoint(3043, 4697, 3), Emote.CHEER, EmoteClue.item(4091), EmoteClue.any("Any rune heraldic shield", EmoteClue.item(7336), EmoteClue.item(7342), EmoteClue.item(7348), EmoteClue.item(7354), EmoteClue.item(7360))), new EmoteClue("Dance in Iban's temple. Beware of double agents! Equip Iban's staff, a black mystic top and a black mystic bottom.", (Integer)29043, new WorldPoint(2011, 4712, 0), Emote.DANCE, EmoteClue.any("Any iban's staff", EmoteClue.item(1409), EmoteClue.item(12658)), EmoteClue.item(4101), EmoteClue.item(4103)), new EmoteClue[]{new EmoteClue("Dance on the Fishing Platform. Equip barrows gloves, an amulet of glory and a dragon med helm.", (Integer)29030, new WorldPoint(2782, 3273, 0), Emote.DANCE, EmoteClue.any("Any amulet of glory", EmoteClue.item(1704), EmoteClue.item(1706), EmoteClue.item(1708), EmoteClue.item(1710), EmoteClue.item(1712), EmoteClue.item(11976), EmoteClue.item(11978)), EmoteClue.item(7462), EmoteClue.item(1149)), new EmoteClue("Flap at the death altar. Beware of double agents! Equip a death tiara, a legend's cape and any ring of wealth.", (Integer)29058, new WorldPoint(2205, 4838, 0), Emote.FLAP, EmoteClue.any("Any ring of wealth", EmoteClue.item(2572), EmoteClue.item(11988), EmoteClue.item(11986), EmoteClue.item(11984), EmoteClue.item(11982), EmoteClue.item(11980), EmoteClue.item(12785), EmoteClue.item(20790), EmoteClue.item(20789), EmoteClue.item(20788), EmoteClue.item(20787), EmoteClue.item(20786)), EmoteClue.item(5547), EmoteClue.item(1052)), new EmoteClue("Headbang in the Fight Arena pub. Equip a pirate bandana, a dragonstone necklace and and a magic longbow.", (Integer)29039, new WorldPoint(2568, 3149, 0), Emote.HEADBANG, EmoteClue.any("Any pirate bandana", EmoteClue.item(7112), EmoteClue.item(7124), EmoteClue.item(7130), EmoteClue.item(7136)), EmoteClue.item(1664), EmoteClue.item(859)), new EmoteClue("Do a jig at the barrow's chest. Beware of double agents! Equip any full barrows set.", (Integer)29042, new WorldPoint(3551, 9694, 0), Emote.JIG, EmoteClue.any("Any full barrows set", EmoteClue.all(EmoteClue.range(4856, 4860), EmoteClue.range(4862, 4866), EmoteClue.range(4868, 4872), EmoteClue.range(4874, 4878)), EmoteClue.all(EmoteClue.range(4880, 4884), EmoteClue.range(4886, 4890), EmoteClue.range(4892, 4896), EmoteClue.range(4898, 4902)), EmoteClue.all(EmoteClue.range(4904, 4908), EmoteClue.range(4910, 4914), EmoteClue.range(4916, 4920), EmoteClue.range(4922, 4926)), EmoteClue.all(EmoteClue.range(4928, 4932), EmoteClue.range(4934, 4938), EmoteClue.range(4940, 4944), EmoteClue.range(4946, 4950)), EmoteClue.all(EmoteClue.range(4952, 4956), EmoteClue.range(4958, 4962), EmoteClue.range(4964, 4968), EmoteClue.range(4970, 4974)), EmoteClue.all(EmoteClue.range(4976, 4980), EmoteClue.range(4982, 4986), EmoteClue.range(4988, 4992), EmoteClue.range(4994, 4998)))), new EmoteClue("Jig at Jiggig. Beware of double agents! Equip a Rune spear, rune platelegs and any rune heraldic helm.", (Integer)29021, new WorldPoint(2477, 3047, 0), Emote.JIG, EmoteClue.range("Any rune heraldic helm", 10286, 10294), EmoteClue.item(1247), EmoteClue.item(1079)), new EmoteClue("Cheer at the games room. Have nothing equipped at all when you do.", null, new WorldPoint(2207, 4952, 0), Emote.CHEER, EmoteClue.emptySlot("Nothing at all", EquipmentInventorySlot.HEAD, EquipmentInventorySlot.CAPE, EquipmentInventorySlot.AMULET, EquipmentInventorySlot.WEAPON, EquipmentInventorySlot.BODY, EquipmentInventorySlot.SHIELD, EquipmentInventorySlot.LEGS, EquipmentInventorySlot.GLOVES, EquipmentInventorySlot.BOOTS, EquipmentInventorySlot.RING, EquipmentInventorySlot.AMMO)), new EmoteClue("Panic on the pier where you catch the Fishing trawler. Have nothing equipped at all when you do.", null, new WorldPoint(2676, 3169, 0), Emote.PANIC, EmoteClue.emptySlot("Nothing at all", EquipmentInventorySlot.HEAD, EquipmentInventorySlot.CAPE, EquipmentInventorySlot.AMULET, EquipmentInventorySlot.WEAPON, EquipmentInventorySlot.BODY, EquipmentInventorySlot.SHIELD, EquipmentInventorySlot.LEGS, EquipmentInventorySlot.GLOVES, EquipmentInventorySlot.BOOTS, EquipmentInventorySlot.RING, EquipmentInventorySlot.AMMO)), new EmoteClue("Panic in the heart of the Haunted Woods. Beware of double agents! Have no items equipped when you do.", null, new WorldPoint(3611, 3492, 0), Emote.PANIC, EmoteClue.emptySlot("Nothing at all", EquipmentInventorySlot.HEAD, EquipmentInventorySlot.CAPE, EquipmentInventorySlot.AMULET, EquipmentInventorySlot.WEAPON, EquipmentInventorySlot.BODY, EquipmentInventorySlot.SHIELD, EquipmentInventorySlot.LEGS, EquipmentInventorySlot.GLOVES, EquipmentInventorySlot.BOOTS, EquipmentInventorySlot.RING, EquipmentInventorySlot.AMMO)), new EmoteClue("Show your anger towards the Statue of Saradomin in Ellamaria's garden. Beware of double agents! Equip a zamorak godsword.", (Integer)29055, new WorldPoint(3230, 3478, 0), Emote.ANGRY, EmoteClue.item(11808)), new EmoteClue("Show your anger at the Wise old man. Beware of double agents! Equip an abyssal whip, a legend's cape and some spined chaps.", (Integer)29059, new WorldPoint(3088, 3254, 0), Emote.ANGRY, EmoteClue.any("Abyssal whip", EmoteClue.item(4151), EmoteClue.item(12773), EmoteClue.item(12774)), EmoteClue.item(1052), EmoteClue.item(6135)), new EmoteClue("Beckon in the Digsite, near the eastern winch. Bow before you talk to me. Equip a green gnome hat, snakeskin boots and an iron pickaxe.", (Integer)28997, new WorldPoint(3370, 3425, 0), Emote.BECKON, Emote.BOW, EmoteClue.item(658), EmoteClue.item(6328), EmoteClue.item(1267)), new EmoteClue("Beckon in Tai Bwo Wannai. Clap before you talk to me. Equip green dragonhide chaps, a ring of dueling and a mithril medium helmet.", (Integer)28990, new WorldPoint(2803, 3073, 0), Emote.BECKON, Emote.CLAP, EmoteClue.item(1099), EmoteClue.any("Ring of dueling", EmoteClue.item(2566), EmoteClue.item(2564), EmoteClue.item(2562), EmoteClue.item(2560), EmoteClue.item(2558), EmoteClue.item(2556), EmoteClue.item(2554), EmoteClue.item(2552)), EmoteClue.item(1143)), new EmoteClue("Beckon in the combat ring of Shayzien. Show your anger before you talk to me. Equip an adamant platebody, adamant full helm and adamant platelegs.", (Integer)29006, new WorldPoint(1545, 3594, 0), Emote.BECKON, Emote.ANGRY, EmoteClue.item(1073), EmoteClue.item(1123), EmoteClue.item(1161)), new EmoteClue("Bow near Lord Iorwerth. Beware of double agents! Equip a new imbued crystal bow.", (Integer)29050, new WorldPoint(2205, 3252, 0), Emote.BOW, EmoteClue.any("Imbued crystal bow", EmoteClue.item(11748), EmoteClue.item(11749), EmoteClue.item(11750), EmoteClue.item(11751), EmoteClue.item(11752), EmoteClue.item(11753), EmoteClue.item(11754), EmoteClue.item(11755), EmoteClue.item(11756), EmoteClue.item(11757), EmoteClue.item(11758))), new EmoteClue("Bow outside the entrance to the Legends' Guild. Equip iron platelegs, an emerald amulet and an oak longbow.", (Integer)28962, new WorldPoint(2729, 3349, 0), Emote.BOW, EmoteClue.item(1067), EmoteClue.item(845), EmoteClue.item(1696)), new EmoteClue("Bow on the ground floor of the Legend's guild. Equip Legend's cape, a dragon battleaxe and an amulet of glory.", (Integer)29037, new WorldPoint(2728, 3377, 0), Emote.BOW, EmoteClue.item(1052), EmoteClue.item(1377), EmoteClue.any("Any amulet of glory", EmoteClue.item(1704), EmoteClue.item(1706), EmoteClue.item(1708), EmoteClue.item(1710), EmoteClue.item(1712), EmoteClue.item(11976), EmoteClue.item(11978))), new EmoteClue("Bow in the ticket office of the Duel Arena. Equip an iron chain body, leather chaps and coif.", (Integer)28982, new WorldPoint(3314, 3241, 0), Emote.BOW, EmoteClue.item(1101), EmoteClue.item(1095), EmoteClue.item(1169)), new EmoteClue("Bow at the top of the lighthouse. Beware of double agents! Equip a blue dragonhide body, blue dragonhide vambraces and no jewelry.", (Integer)29011, new WorldPoint(2511, 3641, 2), Emote.BOW, EmoteClue.item(2499), EmoteClue.item(2487), EmoteClue.emptySlot("No jewelry", EquipmentInventorySlot.AMULET, EquipmentInventorySlot.RING)), new EmoteClue("Blow a kiss between the tables in Shilo Village bank. Beware of double agents! Equip a blue mystic hat, bone spear and rune platebody.", (Integer)29017, new WorldPoint(2851, 2954, 0), Emote.BLOW_KISS, EmoteClue.item(4089), EmoteClue.item(5016), EmoteClue.item(1127)), new EmoteClue("Blow a kiss in the heart of the lava maze. Equip black dragonhide chaps, a spotted cape and a rolling pin.", (Integer)29026, new WorldPoint(3069, 3861, 0), Emote.BLOW_KISS, EmoteClue.item(2497), EmoteClue.any("Spotted cape", EmoteClue.item(10069), EmoteClue.item(10073)), EmoteClue.item(7445)), new EmoteClue("Blow a kiss outside K'ril Tsutsaroth's chamber. Beware of double agents! Equip a zamorak full helm and the shadow sword.", (Integer)29054, new WorldPoint(2925, 5333, 0), Emote.BLOW_KISS, EmoteClue.item(2657), EmoteClue.item(10858)), new EmoteClue("Cheer at the Druids' Circle. Equip a blue wizard hat, a bronze two-handed sword and HAM boots.", (Integer)28973, new WorldPoint(2924, 3478, 0), Emote.CHEER, EmoteClue.item(579), EmoteClue.item(1307), EmoteClue.item(4310)), new EmoteClue("Cheer in the Edgeville general store. Dance before you talk to me. Equip a brown apron, leather boots and leather gloves.", (Integer)29005, new WorldPoint(3083, 3483, 0), Emote.CHEER, Emote.DANCE, EmoteClue.item(1757), EmoteClue.item(1061), EmoteClue.item(1059)), new EmoteClue("Cheer in the Ogre Pen in the Training Camp. Show you are angry before you talk to me. Equip a green dragonhide body and chaps and a steel square shield.", (Integer)28996, new WorldPoint(2527, 3375, 0), Emote.CHEER, Emote.ANGRY, EmoteClue.item(1135), EmoteClue.item(1099), EmoteClue.item(1177)), new EmoteClue("Cheer in the Entrana church. Beware of double agents! Equip a full set of black dragonhide armour.", (Integer)29048, new WorldPoint(2852, 3349, 0), Emote.CHEER, EmoteClue.item(2491), EmoteClue.item(2497), EmoteClue.item(2503)), new EmoteClue("Cheer for the monks at Port Sarim. Equip a coif, steel plateskirt and a sapphire necklace.", (Integer)28964, new WorldPoint(3047, 3237, 0), Emote.CHEER, EmoteClue.item(1169), EmoteClue.item(1083), EmoteClue.item(1656)), new EmoteClue("Clap in the main exam room in the Exam Centre. Equip a white apron, green gnome boots and leather gloves.", (Integer)29018, new WorldPoint(3361, 3339, 0), Emote.CLAP, EmoteClue.item(1005), EmoteClue.item(628), EmoteClue.item(1059)), new EmoteClue("Clap on the causeway to the Wizards' Tower. Equip an iron medium helmet, emerald ring and a white apron.", (Integer)28959, new WorldPoint(3113, 3196, 0), Emote.CLAP, EmoteClue.item(1137), EmoteClue.item(1639), EmoteClue.item(1005)), new EmoteClue("Clap on the top level of the mill, north of East Ardougne. Equip a blue gnome robe top, HAM robe bottom and an unenchanted tiara.", (Integer)28971, new WorldPoint(2635, 3385, 3), Emote.CLAP, EmoteClue.item(640), EmoteClue.item(4300), EmoteClue.item(5525)), new EmoteClue("Clap in Seers court house. Spin before you talk to me. Equip an adamant halberd, blue mystic robe bottom and a diamond ring.", (Integer)29002, new WorldPoint(2735, 3469, 0), Emote.CLAP, Emote.SPIN, EmoteClue.item(3200), EmoteClue.item(4093), EmoteClue.item(1643)), new EmoteClue("Clap in the magic axe hut. Beware of double agents! Equip only some flared trousers.", (Integer)29056, new WorldPoint(3191, 3960, 0), Emote.CLAP, EmoteClue.item(10394), EmoteClue.item(1523), EmoteClue.emptySlot("Nothing else", EquipmentInventorySlot.HEAD, EquipmentInventorySlot.CAPE, EquipmentInventorySlot.AMULET, EquipmentInventorySlot.WEAPON, EquipmentInventorySlot.BODY, EquipmentInventorySlot.SHIELD, EquipmentInventorySlot.GLOVES, EquipmentInventorySlot.BOOTS, EquipmentInventorySlot.RING, EquipmentInventorySlot.AMMO)), new EmoteClue("Clap your hands north of Mount Karuulm Spin before you talk to me. Equip an adamant warhammer, a ring of life and a pair of mithril boots.", (Integer)34647, new WorldPoint(1306, 3839, 0), Emote.CLAP, Emote.SPIN, EmoteClue.item(1345), EmoteClue.item(2570), EmoteClue.item(4127)), new EmoteClue("Cry in the Catherby Ranging shop. Bow before you talk to me. Equip blue gnome boots, a hard leather body and an unblessed silver sickle.", (Integer)28998, new WorldPoint(2823, 3443, 0), Emote.CRY, Emote.BOW, EmoteClue.item(630), EmoteClue.item(1131), EmoteClue.item(2961)), new EmoteClue("Cry on the shore of Catherby beach. Laugh before you talk to me, equip an adamant sq shield, a bone dagger and mithril platebody.", (Integer)29003, new WorldPoint(2852, 3429, 0), Emote.CRY, Emote.LAUGH, EmoteClue.item(1183), EmoteClue.item(8872), EmoteClue.item(1121)), new EmoteClue("Cry on top of the western tree in the Gnome Agility Arena. Indicate 'no' before you talk to me. Equip a steel kiteshield, ring of forging and green dragonhide chaps.", (Integer)28993, new WorldPoint(2473, 3420, 2), Emote.CRY, Emote.NO, EmoteClue.item(1193), EmoteClue.item(2568), EmoteClue.item(1099)), new EmoteClue("Cry in the TzHaar gem store. Beware of double agents! Equip a fire cape and TokTz-Xil-Ul.", (Integer)29049, new WorldPoint(2463, 5149, 0), Emote.CRY, EmoteClue.any("Fire cape", EmoteClue.item(6570), EmoteClue.item(13329)), EmoteClue.item(6522)), new EmoteClue("Cry in the Draynor Village jail. Jump for joy before you talk to me. Equip an adamant sword, a sapphire amulet and an adamant plateskirt.", (Integer)29008, new WorldPoint(3128, 3245, 0), Emote.CRY, Emote.JUMP_FOR_JOY, EmoteClue.item(1287), EmoteClue.item(1694), EmoteClue.item(1091)), new EmoteClue("Dance at the crossroads north of Draynor. Equip an iron chain body, a sapphire ring and a longbow.", (Integer)28968, new WorldPoint(3109, 3294, 0), Emote.DANCE, EmoteClue.item(1101), EmoteClue.item(1637), EmoteClue.item(839)), new EmoteClue("Dance in the Party Room. Equip a steel full helmet, steel platebody and an iron plateskirt.", (Integer)28972, new WorldPoint(3045, 3376, 0), Emote.DANCE, EmoteClue.item(1157), EmoteClue.item(1119), EmoteClue.item(1081)), new EmoteClue("Dance in the shack in Lumbridge Swamp. Equip a bronze dagger, iron full helmet and a gold ring.", (Integer)28958, new WorldPoint(3203, 3169, 0), Emote.DANCE, EmoteClue.item(1205), EmoteClue.item(1153), EmoteClue.item(1635)), new EmoteClue("Dance in the dark caves beneath Lumbridge Swamp. Blow a kiss before you talk to me. Equip an air staff, Bronze full helm and an amulet of power.", (Integer)29000, new WorldPoint(3168, 9571, 0), Emote.DANCE, Emote.BLOW_KISS, EmoteClue.item(1381), EmoteClue.item(1155), EmoteClue.item(1731)), new EmoteClue("Dance at the cat-doored pyramid in Sophanem. Beware of double agents! Equip a ring of life, an uncharged amulet of glory and an adamant two-handed sword.", (Integer)29012, new WorldPoint(3294, 2781, 0), Emote.DANCE, EmoteClue.item(2570), EmoteClue.item(1704), EmoteClue.item(1317)), new EmoteClue("Dance in the centre of Canifis. Bow before you talk to me. Equip a green gnome robe top, mithril plate legs and an iron two-handed sword.", (Integer)28987, new WorldPoint(3492, 3488, 0), Emote.DANCE, Emote.BOW, EmoteClue.item(638), EmoteClue.item(1071), EmoteClue.item(1309)), new EmoteClue("Dance in the King Black Dragon's lair. Beware of double agents! Equip a black dragonhide body, black dragonhide vambs and a black dragon mask.", (Integer)29053, new WorldPoint(2271, 4680, 0), Emote.DANCE, EmoteClue.item(2503), EmoteClue.item(2491), EmoteClue.item(12524)), new EmoteClue("Dance at the entrance to the Grand Exchange. Equip a pink skirt, pink robe top and a body tiara.", (Integer)28985, new WorldPoint(3165, 3467, 0), Emote.DANCE, EmoteClue.item(1013), EmoteClue.item(636), EmoteClue.item(5533)), new EmoteClue("Goblin Salute in the Goblin Village. Beware of double agents! Equip a bandos godsword, a bandos cloak and a bandos platebody.", (Integer)29051, new WorldPoint(2956, 3505, 0), Emote.GOBLIN_SALUTE, EmoteClue.item(12480), EmoteClue.item(12273), EmoteClue.item(11804)), new EmoteClue("Headbang in the mine north of Al Kharid. Equip a desert shirt, leather gloves and leather boots.", (Integer)28965, new WorldPoint(3299, 3289, 0), Emote.HEADBANG, EmoteClue.item(1833), EmoteClue.item(1059), EmoteClue.item(1061)), new EmoteClue("Headbang at the exam center. Beware of double agents! Equip a mystic fire staff, a diamond bracelet and rune boots.", (Integer)28980, new WorldPoint(3362, 3340, 0), Emote.HEADBANG, EmoteClue.item(1401), EmoteClue.item(11092), EmoteClue.item(4131)), new EmoteClue("Headbang at the top of Slayer Tower. Equip a seercull, a combat bracelet and helm of Neitiznot.", (Integer)29031, new WorldPoint(3421, 3537, 2), Emote.HEADBANG, EmoteClue.item(6724), EmoteClue.any("Combat bracelet", EmoteClue.range(11118, 11126), EmoteClue.item(11974), EmoteClue.item(11972)), EmoteClue.item(10828)), new EmoteClue("Dance a jig by the entrance to the Fishing Guild. Equip an emerald ring, a sapphire amulet, and a bronze chain body.", (Integer)28977, new WorldPoint(2610, 3391, 0), Emote.JIG, EmoteClue.item(1639), EmoteClue.item(1694), EmoteClue.item(1103)), new EmoteClue("Dance a jig under Shantay's Awning. Bow before you talk to me. Equip a pointed blue snail helmet, an air staff and a bronze square shield.", (Integer)28999, new WorldPoint(3304, 3124, 0), Emote.JIG, Emote.BOW, EmoteClue.any("Bruise blue snelm (pointed)", EmoteClue.item(3343)), EmoteClue.item(1381), EmoteClue.item(1173)), new EmoteClue("Do a jig in Varrock's rune store. Equip an air tiara and a staff of water.", (Integer)28986, new WorldPoint(3253, 3401, 0), Emote.JIG, EmoteClue.item(5527), EmoteClue.item(1383)), new EmoteClue("Jump for joy at the beehives. Equip a desert shirt, green gnome robe bottoms and a steel axe.", (Integer)28974, new WorldPoint(2759, 3445, 0), Emote.JUMP_FOR_JOY, EmoteClue.item(1833), EmoteClue.item(648), EmoteClue.item(1353)), new EmoteClue("Jump for joy in Yanille bank. Dance a jig before you talk to me. Equip a brown apron, adamantite medium helmet and snakeskin chaps.", (Integer)28994, new WorldPoint(2610, 3092, 0), Emote.JUMP_FOR_JOY, Emote.JIG, EmoteClue.item(1757), EmoteClue.item(1145), EmoteClue.item(6324)), new EmoteClue("Jump for joy in the TzHaar sword shop. Shrug before you talk to me. Equip a Steel longsword, Blue D'hide body and blue mystic gloves.", (Integer)29004, new WorldPoint(2477, 5146, 0), Emote.JUMP_FOR_JOY, Emote.SHRUG, EmoteClue.item(1295), EmoteClue.item(2499), EmoteClue.item(4095)), new EmoteClue("Jump for joy in the Ancient Cavern. Equip a granite shield, splitbark body and any rune heraldic helm.", (Integer)29034, new WorldPoint(1768, 5366, 1), Emote.JUMP_FOR_JOY, EmoteClue.item(3122), EmoteClue.item(3387), EmoteClue.range("Any rune heraldic helm", 10286, 10294)), new EmoteClue("Jump for joy at the Neitiznot rune rock. Equip Rune boots, a proselyte hauberk and a dragonstone ring.", (Integer)29025, new WorldPoint(2375, 3850, 0), Emote.JUMP_FOR_JOY, EmoteClue.item(4131), EmoteClue.item(9674), EmoteClue.item(1645)), new EmoteClue("Jump for joy in the centre of Zul-Andra. Beware of double agents! Equip a dragon 2h sword, bandos boots and an obsidian cape.", (Integer)29041, new WorldPoint(2199, 3056, 0), Emote.JUMP_FOR_JOY, EmoteClue.item(7158), EmoteClue.item(11836), EmoteClue.item(6568)), new EmoteClue("Laugh by the fountain of heroes. Equip splitbark legs, dragon boots and a Rune longsword.", (Integer)29033, new WorldPoint(2920, 9893, 0), Emote.LAUGH, EmoteClue.item(3389), EmoteClue.item(11840), EmoteClue.item(1303)), new EmoteClue("Laugh in Jokul's tent in the Mountain Camp. Beware of double agents! Equip a rune full helmet, blue dragonhide chaps and a fire battlestaff.", (Integer)29015, new WorldPoint(2812, 3681, 0), Emote.LAUGH, EmoteClue.item(1163), EmoteClue.item(2493), EmoteClue.item(1393)), new EmoteClue("Laugh at the crossroads south of the Sinclair Mansion. Equip a cowl, a blue wizard robe top and an iron scimitar.", (Integer)28979, new WorldPoint(2741, 3536, 0), Emote.LAUGH, EmoteClue.item(1167), EmoteClue.item(577), EmoteClue.item(1323)), new EmoteClue("Laugh in front of the gem store in Ardougne market. Equip a Castlewars bracelet, a dragonstone amulet and a ring of forging.", (Integer)29038, new WorldPoint(2666, 3304, 0), Emote.LAUGH, EmoteClue.any("Castle wars bracelet", EmoteClue.range(11079, 11083)), EmoteClue.item(1702), EmoteClue.item(2568)), new EmoteClue("Panic in the Limestone Mine. Equip bronze platelegs, a steel pickaxe and a steel medium helmet.", (Integer)28961, new WorldPoint(3372, 3498, 0), Emote.PANIC, EmoteClue.item(1075), EmoteClue.item(1269), EmoteClue.item(1141)), new EmoteClue("Panic by the mausoleum in Morytania. Wave before you speak to me. Equip a mithril plate skirt, a maple longbow and no boots.", (Integer)28988, new WorldPoint(3504, 3576, 0), Emote.PANIC, Emote.WAVE, EmoteClue.item(1085), EmoteClue.item(851), EmoteClue.emptySlot("No boots", EquipmentInventorySlot.BOOTS)), new EmoteClue("Panic on the Wilderness volcano bridge. Beware of double agents! Equip any headband and crozier.", (Integer)29020, new WorldPoint(3368, 3935, 0), Emote.PANIC, EmoteClue.any("Any headband", EmoteClue.range(2645, 2649), EmoteClue.range(12299, 12307)), EmoteClue.any("Any crozier", EmoteClue.item(12199), EmoteClue.item(12263), EmoteClue.item(12275), EmoteClue.range(10440, 10444))), new EmoteClue("Panic by the pilot on White Wolf Mountain. Beware of double agents! Equip mithril platelegs, a ring of life and a rune axe.", (Integer)29016, new WorldPoint(2847, 3499, 0), Emote.PANIC, EmoteClue.item(1071), EmoteClue.item(2570), EmoteClue.item(1359)), new EmoteClue("Panic by the big egg where no one dare goes and the ground is burnt. Beware of double agents! Equip a dragon med helm, a TokTz-Ket-Xil, a brine sabre, rune platebody and an uncharged amulet of glory.", (Integer)29040, new WorldPoint(3227, 3831, 0), Emote.PANIC, EmoteClue.item(1149), EmoteClue.item(6524), EmoteClue.item(11037), EmoteClue.item(1127), EmoteClue.item(1704)), new EmoteClue("Panic at the area flowers meet snow. Equip Blue D'hide vambs, a dragon spear and a rune plateskirt.", (Integer)29035, new WorldPoint(2776, 3781, 0), Emote.PANIC, EmoteClue.item(2487), EmoteClue.item(1249), EmoteClue.item(1093), EmoteClue.item(4084)), new EmoteClue("Do a push up at the bank of the Warrior's guild. Beware of double agents! Equip a dragon battleaxe, a dragon defender and a slayer helm of any kind.", (Integer)29047, new WorldPoint(2843, 3543, 0), Emote.PUSH_UP, EmoteClue.item(1377), EmoteClue.item(12954), EmoteClue.any("Any slayer helmet", EmoteClue.item(11864), EmoteClue.item(19639), EmoteClue.item(19643), EmoteClue.item(21264), EmoteClue.item(19647), EmoteClue.item(21888), EmoteClue.item(11865), EmoteClue.item(19641), EmoteClue.item(19645), EmoteClue.item(21266), EmoteClue.item(19649), EmoteClue.item(21890), EmoteClue.item(23073), EmoteClue.item(23075))), new EmoteClue("Blow a raspberry at the bank of the Warrior's guild. Beware of double agents! Equip a dragon battleaxe, a dragon defender and a slayer helm of any kind.", (Integer)29047, new WorldPoint(2843, 3543, 0), Emote.RASPBERRY, EmoteClue.item(1377), EmoteClue.item(12954), EmoteClue.any("Any slayer helmet", EmoteClue.item(11864), EmoteClue.item(19639), EmoteClue.item(19643), EmoteClue.item(21264), EmoteClue.item(19647), EmoteClue.item(21888), EmoteClue.item(11865), EmoteClue.item(19641), EmoteClue.item(19645), EmoteClue.item(21266), EmoteClue.item(19649), EmoteClue.item(21890), EmoteClue.item(23073), EmoteClue.item(23075))), new EmoteClue("Blow a raspberry at the monkey cage in Ardougne Zoo. Equip a studded leather body, bronze platelegs and a normal staff with no orb.", (Integer)28975, new WorldPoint(2607, 3282, 0), Emote.RASPBERRY, EmoteClue.item(1133), EmoteClue.item(1075), EmoteClue.item(1379)), new EmoteClue("Blow raspberries outside the entrance to Keep Le Faye. Equip a coif, an iron platebody and leather gloves.", (Integer)28978, new WorldPoint(2757, 3401, 0), Emote.RASPBERRY, EmoteClue.item(1169), EmoteClue.item(1115), EmoteClue.item(1059)), new EmoteClue("Blow a raspberry in the Fishing Guild bank. Beware of double agents! Equip an elemental shield, blue dragonhide chaps and a rune warhammer.", (Integer)29010, new WorldPoint(2588, 3419, 0), Emote.RASPBERRY, EmoteClue.item(2890), EmoteClue.item(2493), EmoteClue.item(1347)), new EmoteClue("Salute in the banana plantation. Beware of double agents! Equip a diamond ring, amulet of power, and nothing on your chest and legs.", (Integer)29014, new WorldPoint(2914, 3168, 0), Emote.SALUTE, EmoteClue.item(1643), EmoteClue.item(1731), EmoteClue.emptySlot("Nothing on chest & legs", EquipmentInventorySlot.BODY, EquipmentInventorySlot.LEGS)), new EmoteClue("Salute in the Warriors' guild bank. Equip only a black salamander.", (Integer)29028, new WorldPoint(2844, 3542, 0), Emote.SALUTE, EmoteClue.item(10148), EmoteClue.emptySlot("Nothing else", EquipmentInventorySlot.HEAD, EquipmentInventorySlot.CAPE, EquipmentInventorySlot.AMULET, EquipmentInventorySlot.BODY, EquipmentInventorySlot.SHIELD, EquipmentInventorySlot.LEGS, EquipmentInventorySlot.GLOVES, EquipmentInventorySlot.BOOTS, EquipmentInventorySlot.RING, EquipmentInventorySlot.AMMO)), new EmoteClue("Salute in the centre of the mess hall. Beware of double agents! Equip a rune halberd rune platebody, and an amulet of strength.", (Integer)29023, new WorldPoint(1646, 3632, 0), Emote.SALUTE, EmoteClue.item(3202), EmoteClue.item(1127), EmoteClue.item(1725)), new EmoteClue("Shrug in the mine near Rimmington. Equip a gold necklace, a gold ring and a bronze spear.", (Integer)28969, new WorldPoint(2976, 3238, 0), Emote.SHRUG, EmoteClue.item(1654), EmoteClue.item(1635), EmoteClue.item(1237)), new EmoteClue("Shrug in Catherby bank. Yawn before you talk to me. Equip a maple longbow, green d'hide chaps and an iron med helm.", (Integer)29001, new WorldPoint(2808, 3440, 0), Emote.SHRUG, Emote.YAWN, EmoteClue.item(851), EmoteClue.item(1099), EmoteClue.item(1137)), new EmoteClue("Shrug in the Zamorak temple found in the Eastern Wilderness. Beware of double agents! Equip rune platelegs, an iron platebody and blue dragonhide vambraces.", (Integer)29009, new WorldPoint(3239, 3611, 0), Emote.SHRUG, EmoteClue.item(1079), EmoteClue.item(1115), EmoteClue.item(2487)), new EmoteClue("Shrug in the Shayzien command tent. Equip a blue mystic robe bottom, a rune kiteshield and any bob shirt.", (Integer)29036, new WorldPoint(1555, 3537, 0), Emote.SHRUG, EmoteClue.item(4093), EmoteClue.item(1201), EmoteClue.range("Any bob shirt", 10316, 10324)), new EmoteClue("Slap your head in the centre of the Kourend catacombs. Beware of double agents! Equip the arclight and the amulet of the damned.", (Integer)29052, new WorldPoint(1663, 10045, 0), Emote.SLAP_HEAD, EmoteClue.item(19675), EmoteClue.any("Amulet of the damned", EmoteClue.item(12853), EmoteClue.item(12851))), new EmoteClue("Spin at the crossroads north of Rimmington. Equip a green gnome hat, cream gnome top and leather chaps.", (Integer)28976, new WorldPoint(2981, 3276, 0), Emote.SPIN, EmoteClue.item(658), EmoteClue.item(642), EmoteClue.item(1095)), new EmoteClue("Spin in Draynor Manor by the fountain. Equip an iron platebody, studded leather chaps and a bronze full helmet.", (Integer)28966, new WorldPoint(3088, 3336, 0), Emote.SPIN, EmoteClue.item(1115), EmoteClue.item(1097), EmoteClue.item(1155)), new EmoteClue("Spin in front of the Soul altar. Beware of double agents! Equip a dragon pickaxe, helm of neitiznot and a pair of rune boots.", (Integer)29046, new WorldPoint(1815, 3856, 0), Emote.SPIN, EmoteClue.any("Dragon pickaxe", EmoteClue.item(11920), EmoteClue.item(12797), EmoteClue.item(13243), EmoteClue.item(13244)), EmoteClue.item(10828), EmoteClue.item(4131)), new EmoteClue("Spin in the Varrock Castle courtyard. Equip a black axe, a coif and a ruby ring.", (Integer)28983, new WorldPoint(3213, 3463, 0), Emote.SPIN, EmoteClue.item(1361), EmoteClue.item(1169), EmoteClue.item(1641)), new EmoteClue("Spin in West Ardougne Church. Equip a dragon spear and red dragonhide chaps.", (Integer)29024, new WorldPoint(2530, 3290, 0), Emote.SPIN, EmoteClue.item(1249), EmoteClue.item(2495)), new EmoteClue("Spin on the bridge by the Barbarian Village. Salute before you talk to me. Equip purple gloves, a steel kiteshield and a mithril full helmet.", (Integer)28989, new WorldPoint(3105, 3420, 0), Emote.SPIN, Emote.SALUTE, EmoteClue.item(2942), EmoteClue.item(1193), EmoteClue.item(1159)), new EmoteClue("Stamp in the Enchanted valley west of the waterfall. Beware of double agents! Equip a dragon axe.", (Integer)29060, new WorldPoint(3030, 4522, 0), Emote.STOMP, EmoteClue.item(6739)), new EmoteClue("Think in middle of the wheat field by the Lumbridge mill. Equip a blue gnome robetop, a turquoise gnome robe bottom and an oak shortbow.", (Integer)28967, new WorldPoint(3159, 3298, 0), Emote.THINK, EmoteClue.item(640), EmoteClue.item(654), EmoteClue.item(843)), new EmoteClue("Think in the centre of the Observatory. Spin before you talk to me. Equip a mithril chain body, green dragonhide chaps and a ruby amulet.", (Integer)28995, new WorldPoint(2439, 3161, 0), Emote.THINK, Emote.SPIN, EmoteClue.item(1109), EmoteClue.item(1099), EmoteClue.item(1698)), new EmoteClue("Wave along the south fence of the Lumber Yard. Equip a hard leather body, leather chaps and a bronze axe.", (Integer)28981, new WorldPoint(3307, 3491, 0), Emote.WAVE, EmoteClue.item(1131), EmoteClue.item(1095), EmoteClue.item(1351)), new EmoteClue("Wave in the Falador gem store. Equip a Mithril pickaxe, Black platebody and an Iron Kiteshield.", (Integer)28984, new WorldPoint(2945, 3335, 0), Emote.WAVE, EmoteClue.item(1273), EmoteClue.item(1125), EmoteClue.item(1191)), new EmoteClue("Wave on Mudskipper Point. Equip a black cape, leather chaps and a steel mace.", (Integer)28963, new WorldPoint(2989, 3110, 0), Emote.WAVE, EmoteClue.item(1019), EmoteClue.item(1095), EmoteClue.item(1424)), new EmoteClue("Wave on the northern wall of Castle Drakan. Beware of double agents! Wear a dragon sq shield, splitbark body and any boater.", (Integer)29044, new WorldPoint(3560, 3385, 0), Emote.WAVE, EmoteClue.item(1187), EmoteClue.item(3387), EmoteClue.any("Any boater", EmoteClue.item(7319), EmoteClue.item(7321), EmoteClue.item(7323), EmoteClue.item(7325), EmoteClue.item(7327), EmoteClue.item(12309), EmoteClue.item(12311), EmoteClue.item(12313))), new EmoteClue("Yawn in the 7th room of Pyramid Plunder. Beware of double agents! Equip a pharaoh sceptre and a full set of menaphite robes.", (Integer)29045, new WorldPoint(1944, 4427, 0), Emote.YAWN, EmoteClue.any("Pharaoh's sceptre", EmoteClue.item(9050), EmoteClue.item(9048), EmoteClue.item(9046), EmoteClue.item(9044), EmoteClue.item(13078), EmoteClue.item(13077), EmoteClue.item(13076), EmoteClue.item(13075), EmoteClue.item(13074)), EmoteClue.any("Full set of menaphite robes", EmoteClue.all(EmoteClue.item(6392), EmoteClue.item(6394), EmoteClue.range(6396, 6398)), EmoteClue.all(EmoteClue.item(6400), EmoteClue.item(6402), EmoteClue.range(6404, 6406)))), new EmoteClue("Yawn in the Varrock library. Equip a green gnome robe top, HAM robe bottom and an iron warhammer.", (Integer)28970, new WorldPoint(3209, 3492, 0), Emote.YAWN, EmoteClue.item(638), EmoteClue.item(4300), EmoteClue.item(1335)), new EmoteClue("Yawn in Draynor Marketplace. Equip studded leather chaps, an iron kiteshield and a steel longsword.", (Integer)28960, new WorldPoint(3083, 3253, 0), Emote.YAWN, EmoteClue.item(1097), EmoteClue.item(1191), EmoteClue.item(1295)), new EmoteClue("Yawn in the Castle Wars lobby. Shrug before you talk to me. Equip a ruby amulet, a mithril scimitar and a Wilderness cape.", (Integer)28991, new WorldPoint(2440, 3092, 0), Emote.YAWN, Emote.SHRUG, EmoteClue.item(1698), EmoteClue.item(1329), EmoteClue.range("Any team cape", 4315, 4413)), new EmoteClue("Yawn in the rogues' general store. Beware of double agents! Equip an adamant square shield, blue dragon vambraces and a rune pickaxe.", (Integer)29013, new WorldPoint(3026, 3701, 0), Emote.YAWN, EmoteClue.item(1183), EmoteClue.item(2487), EmoteClue.item(1275)), new EmoteClue("Yawn at the top of Trollheim. Equip a lava battlestaff, black dragonhide vambraces and a mind shield.", (Integer)29032, new WorldPoint(2887, 3676, 0), Emote.YAWN, EmoteClue.item(3053), EmoteClue.item(2491), EmoteClue.item(9731)), new EmoteClue("Yawn in the centre of Arceuus library. Nod your head before you talk to me. Equip blue dragonhide vambraces, adamant boots and an adamant dagger.", (Integer)29007, new WorldPoint(1632, 3807, 0), Emote.YAWN, Emote.YES, EmoteClue.item(2487), EmoteClue.item(4129), EmoteClue.item(1211)), new EmoteClue("Swing a bullroarer at the top of the watchtower. Beware of double agents! Equip a dragon plateskirt, climbing boots and a dragon chainbody.", (Integer)29057, new WorldPoint(2932, 4712, 0), Emote.BULL_ROARER, EmoteClue.item(4585), EmoteClue.item(3105), EmoteClue.item(3140), EmoteClue.item(716)), new EmoteClue("Blow a raspberry at Gypsy Aris in her tent. Equip a gold ring and a gold necklace.", (Integer)34736, new WorldPoint(3203, 3424, 0), Emote.RASPBERRY, EmoteClue.item(1635), EmoteClue.item(1654)), new EmoteClue("Bow to Brugsen Bursen at the Grand Exchange.", null, new WorldPoint(3164, 3477, 0), Emote.BOW, new ItemRequirement[0]), new EmoteClue("Cheer at Iffie Nitter. Equip a chef hat and a red cape.", (Integer)34737, new WorldPoint(3205, 3416, 0), Emote.CHEER, EmoteClue.item(1949), EmoteClue.item(1007)), new EmoteClue("Clap at Bob's Brilliant Axes. Equip a bronze axe and leather boots.", (Integer)34738, new WorldPoint(3231, 3203, 0), Emote.CLAP, EmoteClue.item(1351), EmoteClue.item(1061)), new EmoteClue("Panic at Al Kharid mine.", null, new WorldPoint(3300, 3314, 0), Emote.PANIC, new ItemRequirement[0]), new EmoteClue("Spin at Flynn's Mace Shop.", null, new WorldPoint(2950, 3387, 0), Emote.SPIN, new ItemRequirement[0])});
    private final String text;
    private final Integer stashUnit;
    private final WorldPoint location;
    private final Emote firstEmote;
    private final Emote secondEmote;
    @Nonnull
    private final ItemRequirement[] itemRequirements;

    private static SingleItemRequirement item(int itemId) {
        return new SingleItemRequirement(itemId);
    }

    private static RangeItemRequirement range(int startItemId, int endItemId) {
        return EmoteClue.range(null, startItemId, endItemId);
    }

    private static RangeItemRequirement range(String name, int startItemId, int endItemId) {
        return new RangeItemRequirement(name, startItemId, endItemId);
    }

    private static AnyRequirementCollection any(String name, ItemRequirement ... requirements) {
        return new AnyRequirementCollection(name, requirements);
    }

    private static AllRequirementsCollection all(ItemRequirement ... requirements) {
        return new AllRequirementsCollection(requirements);
    }

    private static SlotLimitationRequirement emptySlot(String description, EquipmentInventorySlot ... slots) {
        return new SlotLimitationRequirement(description, slots);
    }

    private EmoteClue(String text, Integer stashUnit, WorldPoint location, Emote firstEmote, ItemRequirement ... itemRequirements) {
        this(text, stashUnit, location, firstEmote, (Emote)null, itemRequirements);
    }

    private EmoteClue(String text, Integer stashUnit, WorldPoint location, Emote firstEmote, Emote secondEmote, ItemRequirement ... itemRequirements) {
        this.text = text;
        this.stashUnit = stashUnit;
        this.location = location;
        this.firstEmote = firstEmote;
        this.secondEmote = secondEmote;
        this.itemRequirements = itemRequirements;
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, ClueScrollPlugin plugin) {
        panelComponent.getChildren().add(TitleComponent.builder().text("Emote Clue").build());
        panelComponent.getChildren().add(LineComponent.builder().left("Emotes:").build());
        panelComponent.getChildren().add(LineComponent.builder().left(this.getFirstEmote().getName()).leftColor(ClueScrollOverlay.TITLED_CONTENT_COLOR).build());
        if (this.getSecondEmote() != null) {
            panelComponent.getChildren().add(LineComponent.builder().left(this.getSecondEmote().getName()).leftColor(ClueScrollOverlay.TITLED_CONTENT_COLOR).build());
        }
        if (this.itemRequirements.length > 0) {
            panelComponent.getChildren().add(LineComponent.builder().left("Equip:").build());
            Item[] equipment = plugin.getEquippedItems();
            Item[] inventory = plugin.getInventoryItems();
            if (equipment == null) {
                equipment = new Item[]{};
            }
            if (inventory == null) {
                inventory = new Item[]{};
            }
            Item[] combined = new Item[equipment.length + inventory.length];
            System.arraycopy(equipment, 0, combined, 0, equipment.length);
            System.arraycopy(inventory, 0, combined, equipment.length, inventory.length);
            for (ItemRequirement requirement : this.itemRequirements) {
                boolean equipmentFulfilled = requirement.fulfilledBy(equipment);
                boolean combinedFulfilled = requirement.fulfilledBy(combined);
                panelComponent.getChildren().add(LineComponent.builder().left(requirement.getCollectiveName(plugin.getClient())).leftColor(ClueScrollOverlay.TITLED_CONTENT_COLOR).right(combinedFulfilled ? "\u2713" : "\u2717").rightColor(equipmentFulfilled ? Color.GREEN : (combinedFulfilled ? Color.ORANGE : Color.RED)).build());
            }
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, ClueScrollPlugin plugin) {
        LocalPoint localLocation = LocalPoint.fromWorld(plugin.getClient(), this.getLocation());
        if (localLocation == null) {
            return;
        }
        OverlayUtil.renderTileOverlay(plugin.getClient(), graphics, localLocation, plugin.getEmoteImage(), Color.ORANGE);
    }

    public static EmoteClue forText(String text) {
        for (EmoteClue clue : CLUES) {
            if (!clue.getText().equalsIgnoreCase(text)) continue;
            return clue;
        }
        return null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public Integer getStashUnit() {
        return this.stashUnit;
    }

    @Override
    public WorldPoint getLocation() {
        return this.location;
    }

    public Emote getFirstEmote() {
        return this.firstEmote;
    }

    public Emote getSecondEmote() {
        return this.secondEmote;
    }

    @Nonnull
    public ItemRequirement[] getItemRequirements() {
        return this.itemRequirements;
    }
}

