/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cluescrolls;

import com.google.common.base.MoreObjects;
import com.google.inject.Binder;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.NPC;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Point;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.cluescrolls.ClueScrollConfig;
import net.runelite.client.plugins.cluescrolls.ClueScrollEmoteOverlay;
import net.runelite.client.plugins.cluescrolls.ClueScrollMusicOverlay;
import net.runelite.client.plugins.cluescrolls.ClueScrollOverlay;
import net.runelite.client.plugins.cluescrolls.ClueScrollService;
import net.runelite.client.plugins.cluescrolls.ClueScrollServiceImpl;
import net.runelite.client.plugins.cluescrolls.ClueScrollWorldMapPoint;
import net.runelite.client.plugins.cluescrolls.ClueScrollWorldOverlay;
import net.runelite.client.plugins.cluescrolls.clues.AnagramClue;
import net.runelite.client.plugins.cluescrolls.clues.CipherClue;
import net.runelite.client.plugins.cluescrolls.clues.ClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.CoordinateClue;
import net.runelite.client.plugins.cluescrolls.clues.CrypticClue;
import net.runelite.client.plugins.cluescrolls.clues.EmoteClue;
import net.runelite.client.plugins.cluescrolls.clues.FairyRingClue;
import net.runelite.client.plugins.cluescrolls.clues.FaloTheBardClue;
import net.runelite.client.plugins.cluescrolls.clues.HotColdClue;
import net.runelite.client.plugins.cluescrolls.clues.LocationClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.LocationsClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.MapClue;
import net.runelite.client.plugins.cluescrolls.clues.MusicClue;
import net.runelite.client.plugins.cluescrolls.clues.NpcClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.ObjectClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.TextClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.ThreeStepCrypticClue;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.TextComponent;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clue Scroll", description="Show answers to clue scroll riddles, anagrams, ciphers, and cryptic clues", tags={"arrow", "hints", "world", "map", "coordinates", "emotes"})
public class ClueScrollPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClueScrollPlugin.class);
    private static final Color HIGHLIGHT_BORDER_COLOR = Color.ORANGE;
    private static final Color HIGHLIGHT_HOVER_BORDER_COLOR = HIGHLIGHT_BORDER_COLOR.darker();
    private static final Color HIGHLIGHT_FILL_COLOR = new Color(0, 255, 0, 20);
    private ClueScroll clue;
    private final List<NPC> npcsToMark = new ArrayList<NPC>();
    private final List<TileObject> objectsToMark = new ArrayList<TileObject>();
    private Item[] equippedItems;
    private Item[] inventoryItems;
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClueScrollOverlay clueScrollOverlay;
    @Inject
    private ClueScrollEmoteOverlay clueScrollEmoteOverlay;
    @Inject
    private ClueScrollMusicOverlay clueScrollMusicOverlay;
    @Inject
    private ClueScrollWorldOverlay clueScrollWorldOverlay;
    @Inject
    private ClueScrollConfig config;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    private BufferedImage emoteImage;
    private BufferedImage mapArrow;
    private Integer clueItemId;
    private boolean worldMapPointsSet = false;
    private final TextComponent textComponent = new TextComponent();
    private static final int[] REGION_MIRRORS = new int[]{12894, 8755, 12895, 8756, 13150, 9011, 13151, 9012};

    @Provides
    ClueScrollConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(ClueScrollConfig.class);
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(ClueScrollService.class).to(ClueScrollServiceImpl.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.clueScrollOverlay);
        this.overlayManager.add(this.clueScrollEmoteOverlay);
        this.overlayManager.add(this.clueScrollWorldOverlay);
        this.overlayManager.add(this.clueScrollMusicOverlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.clueScrollOverlay);
        this.overlayManager.remove(this.clueScrollEmoteOverlay);
        this.overlayManager.remove(this.clueScrollWorldOverlay);
        this.overlayManager.remove(this.clueScrollMusicOverlay);
        this.npcsToMark.clear();
        this.inventoryItems = null;
        this.equippedItems = null;
        this.resetClue(true);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        if (this.clue instanceof HotColdClue && ((HotColdClue)this.clue).update(event.getMessage(), this)) {
            this.worldMapPointsSet = false;
        }
        if (!event.getMessage().equals("The strange device cools as you find your treasure.") && !event.getMessage().equals("Well done, you've completed the Treasure Trail!")) {
            return;
        }
        this.resetClue(true);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        MapClue clue = MapClue.forInterfaceId(event.getGroupId());
        if (clue != null) {
            this.updateClue(clue);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        ItemComposition itemComposition;
        if (event.getMenuOption() != null && event.getMenuOption().equals("Read") && (itemComposition = this.itemManager.getItemComposition(event.getId())) != null && itemComposition.getName().startsWith("Clue scroll")) {
            this.clueItemId = itemComposition.getId();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        Stream<Item> items;
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            this.equippedItems = event.getItemContainer().getItems();
            return;
        }
        if (event.getItemContainer() != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        this.inventoryItems = event.getItemContainer().getItems();
        if (this.clue != null && this.clueItemId != null && (items = Arrays.stream(event.getItemContainer().getItems())).noneMatch(item -> this.itemManager.getItemComposition(item.getId()).getId() == this.clueItemId.intValue())) {
            this.resetClue(true);
        }
        if (this.clue instanceof ThreeStepCrypticClue && ((ThreeStepCrypticClue)this.clue).update(this.client, event, this.itemManager)) {
            this.worldMapPointsSet = false;
            this.npcsToMark.clear();
            if (this.config.displayHintArrows()) {
                this.client.clearHintArrow();
            }
            this.checkClueNPCs(this.clue, this.client.getCachedNPCs());
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        NPC npc = event.getNpc();
        this.checkClueNPCs(this.clue, npc);
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        boolean removed = this.npcsToMark.remove(event.getNpc());
        if (removed) {
            if (this.npcsToMark.isEmpty()) {
                this.client.clearHintArrow();
            } else {
                this.client.setHintArrow(this.npcsToMark.get(0));
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("cluescroll") && !this.config.displayHintArrows()) {
            this.client.clearHintArrow();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.resetClue(true);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        WorldPoint location;
        int[] objectIds;
        this.objectsToMark.clear();
        if (this.clue instanceof LocationsClueScroll) {
            WorldPoint[] locations = ((LocationsClueScroll)((Object)this.clue)).getLocations();
            if (locations.length > 0) {
                this.addMapPoints(locations);
            }
            if (this.clue instanceof ObjectClueScroll && (objectIds = ((ObjectClueScroll)((Object)this.clue)).getObjectIds()).length > 0) {
                for (WorldPoint location2 : locations) {
                    if (location2 == null) continue;
                    this.highlightObjectsForLocation(location2, objectIds);
                }
            }
        }
        if (this.clue instanceof LocationClueScroll && (location = ((LocationClueScroll)((Object)this.clue)).getLocation()) != null) {
            if (this.config.displayHintArrows() && (this.client.getHintArrowNpc() == null || !this.npcsToMark.contains(this.client.getHintArrowNpc()))) {
                this.client.setHintArrow(location);
            }
            this.addMapPoints(location);
            if (this.clue instanceof ObjectClueScroll && (objectIds = ((ObjectClueScroll)((Object)this.clue)).getObjectIds()).length > 0) {
                this.highlightObjectsForLocation(location, objectIds);
            }
        }
        this.updateClue(this.findClueScroll());
    }

    public BufferedImage getClueScrollImage() {
        return this.itemManager.getImage(19835);
    }

    public BufferedImage getEmoteImage() {
        if (this.emoteImage != null) {
            return this.emoteImage;
        }
        this.emoteImage = ImageUtil.getResourceStreamFromClass(this.getClass(), "emote.png");
        return this.emoteImage;
    }

    public BufferedImage getSpadeImage() {
        return this.itemManager.getImage(952);
    }

    BufferedImage getMapArrow() {
        if (this.mapArrow != null) {
            return this.mapArrow;
        }
        this.mapArrow = ImageUtil.getResourceStreamFromClass(this.getClass(), "/util/clue_arrow.png");
        return this.mapArrow;
    }

    private void resetClue(boolean withItemId) {
        if (this.clue instanceof LocationsClueScroll) {
            ((LocationsClueScroll)((Object)this.clue)).reset();
        }
        if (withItemId) {
            this.clueItemId = null;
        }
        this.clue = null;
        this.worldMapPointManager.removeIf(ClueScrollWorldMapPoint.class::isInstance);
        this.worldMapPointsSet = false;
        this.npcsToMark.clear();
        if (this.config.displayHintArrows()) {
            this.client.clearHintArrow();
        }
    }

    private ClueScroll findClueScroll() {
        Widget clueScrollText = this.client.getWidget(WidgetInfo.CLUE_SCROLL_TEXT);
        if (clueScrollText == null) {
            return null;
        }
        String text = Text.sanitizeMultilineText(clueScrollText.getText()).toLowerCase();
        if (this.clue instanceof TextClueScroll && ((TextClueScroll)((Object)this.clue)).getText().equalsIgnoreCase(text)) {
            return this.clue;
        }
        if (text.contains("anagram reveals who to speak to next:")) {
            return AnagramClue.forText(text);
        }
        if (text.startsWith("the cipher reveals who to speak to next:")) {
            return CipherClue.forText(text);
        }
        if (text.startsWith("i'd like to hear some music.")) {
            return MusicClue.forText(clueScrollText.getText());
        }
        if (text.contains("degrees") && text.contains("minutes")) {
            return this.coordinatesToWorldPoint(text);
        }
        CrypticClue crypticClue = CrypticClue.forText(text);
        if (crypticClue != null) {
            return crypticClue;
        }
        EmoteClue emoteClue = EmoteClue.forText(text);
        if (emoteClue != null) {
            return emoteClue;
        }
        FairyRingClue fairyRingClue = FairyRingClue.forText(text);
        if (fairyRingClue != null) {
            return fairyRingClue;
        }
        FaloTheBardClue faloTheBardClue = FaloTheBardClue.forText(text);
        if (faloTheBardClue != null) {
            return faloTheBardClue;
        }
        HotColdClue hotColdClue = HotColdClue.forText(text);
        if (hotColdClue != null) {
            return hotColdClue;
        }
        ThreeStepCrypticClue threeStepCrypticClue = ThreeStepCrypticClue.forText(text, clueScrollText.getText());
        if (threeStepCrypticClue != null) {
            return threeStepCrypticClue;
        }
        log.warn("Encountered unhandled clue text: {}", (Object)clueScrollText.getText());
        this.resetClue(true);
        return null;
    }

    private CoordinateClue coordinatesToWorldPoint(String text) {
        String[] splitText = text.split(" ");
        if (splitText.length != 10) {
            log.warn("Splitting \"" + text + "\" did not result in an array of 10 cells");
            return null;
        }
        if (!splitText[1].startsWith("degree") || !splitText[3].startsWith("minute")) {
            log.warn("\"" + text + "\" is not a well formed coordinate string");
            return null;
        }
        int degY = Integer.parseInt(splitText[0]);
        int minY = Integer.parseInt(splitText[2]);
        if (splitText[4].equals("south")) {
            degY *= -1;
            minY *= -1;
        }
        int degX = Integer.parseInt(splitText[5]);
        int minX = Integer.parseInt(splitText[7]);
        if (splitText[9].equals("west")) {
            degX *= -1;
            minX *= -1;
        }
        return new CoordinateClue(text, this.coordinatesToWorldPoint(degX, minX, degY, minY));
    }

    private WorldPoint coordinatesToWorldPoint(int degX, int minX, int degY, int minY) {
        int x2 = 2440;
        int y2 = 3161;
        x2 = (int)((long)x2 + ((long)(degX * 32) + Math.round((double)minX / 1.875)));
        y2 = (int)((long)y2 + ((long)(degY * 32) + Math.round((double)minY / 1.875)));
        return new WorldPoint(x2, y2, 0);
    }

    private void addMapPoints(WorldPoint ... points) {
        if (this.worldMapPointsSet) {
            return;
        }
        this.worldMapPointsSet = true;
        this.worldMapPointManager.removeIf(ClueScrollWorldMapPoint.class::isInstance);
        for (WorldPoint point : points) {
            this.worldMapPointManager.add(new ClueScrollWorldMapPoint(point, this));
        }
    }

    private void highlightObjectsForLocation(WorldPoint location, int ... objectIds) {
        LocalPoint localLocation = LocalPoint.fromWorld(this.client, location);
        if (localLocation == null) {
            return;
        }
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        Tile tile = tiles[this.client.getPlane()][localLocation.getSceneX()][localLocation.getSceneY()];
        this.objectsToMark.clear();
        for (GameObject object : tile.getGameObjects()) {
            if (object == null) continue;
            for (int id : objectIds) {
                ObjectComposition impostor;
                if (object.getId() == id) {
                    this.objectsToMark.add(object);
                    continue;
                }
                ObjectComposition comp = this.client.getObjectDefinition(object.getId());
                ObjectComposition objectComposition = impostor = comp.getImpostorIds() != null ? comp.getImpostor() : comp;
                if (impostor == null || impostor.getId() != id) continue;
                this.objectsToMark.add(object);
            }
        }
    }

    private void checkClueNPCs(ClueScroll clue, NPC ... npcs) {
        if (!(clue instanceof NpcClueScroll)) {
            return;
        }
        NpcClueScroll npcClueScroll = (NpcClueScroll)((Object)clue);
        if (npcClueScroll.getNpcs() == null || npcClueScroll.getNpcs().length == 0) {
            return;
        }
        for (NPC npc : npcs) {
            if (npc == null || npc.getName() == null) continue;
            for (String npcName : npcClueScroll.getNpcs()) {
                if (!Objects.equals(npc.getName(), npcName)) continue;
                this.npcsToMark.add(npc);
            }
        }
        if (!this.npcsToMark.isEmpty() && this.config.displayHintArrows()) {
            this.client.setHintArrow(this.npcsToMark.get(0));
        }
    }

    private void updateClue(ClueScroll clue) {
        if (clue == null || clue == this.clue) {
            return;
        }
        this.resetClue(false);
        this.checkClueNPCs(clue, this.client.getCachedNPCs());
        this.clue = clue;
    }

    void highlightWidget(Graphics2D graphics, Widget toHighlight, Widget container, Rectangle padding, String text) {
        padding = MoreObjects.firstNonNull(padding, new Rectangle());
        Point canvasLocation = toHighlight.getCanvasLocation();
        if (canvasLocation == null) {
            return;
        }
        Point windowLocation = container.getCanvasLocation();
        if (windowLocation.getY() > canvasLocation.getY() + toHighlight.getHeight() || windowLocation.getY() + container.getHeight() < canvasLocation.getY()) {
            return;
        }
        Area widgetArea = new Area(new Rectangle(canvasLocation.getX() - padding.x, Math.max(canvasLocation.getY(), windowLocation.getY()) - padding.y, toHighlight.getWidth() + padding.x + padding.width, Math.min(Math.min(windowLocation.getY() + container.getHeight() - canvasLocation.getY(), toHighlight.getHeight()), Math.min(canvasLocation.getY() + toHighlight.getHeight() - windowLocation.getY(), toHighlight.getHeight())) + padding.y + padding.height));
        OverlayUtil.renderHoverableArea(graphics, widgetArea, this.client.getMouseCanvasPosition(), HIGHLIGHT_FILL_COLOR, HIGHLIGHT_BORDER_COLOR, HIGHLIGHT_HOVER_BORDER_COLOR);
        if (text == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.textComponent.setPosition(new java.awt.Point(canvasLocation.getX() + toHighlight.getWidth() / 2 - fontMetrics.stringWidth(text) / 2, canvasLocation.getY() + fontMetrics.getHeight()));
        this.textComponent.setText(text);
        this.textComponent.render(graphics);
    }

    void scrollToWidget(WidgetInfo list, WidgetInfo scrollbar, Widget ... toHighlight) {
        Widget parent = this.client.getWidget(list);
        int averageCentralY = 0;
        int nonnullCount = 0;
        for (Widget widget : toHighlight) {
            if (widget == null) continue;
            averageCentralY += widget.getRelativeY() + widget.getHeight() / 2;
            ++nonnullCount;
        }
        if (nonnullCount == 0) {
            return;
        }
        int newScroll = Math.max(0, Math.min(parent.getScrollHeight(), (averageCentralY /= nonnullCount) - parent.getHeight() / 2));
        this.client.runScript(72, scrollbar.getId(), list.getId(), newScroll);
    }

    public static WorldPoint getMirrorPoint(WorldPoint worldPoint, boolean toOverworld) {
        int region = worldPoint.getRegionID();
        for (int i = 0; i < REGION_MIRRORS.length; i += 2) {
            int real = REGION_MIRRORS[i];
            int overworld = REGION_MIRRORS[i + 1];
            if (region != (toOverworld ? real : overworld)) continue;
            return WorldPoint.fromRegion(toOverworld ? overworld : real, worldPoint.getRegionX(), worldPoint.getRegionY(), worldPoint.getPlane());
        }
        return worldPoint;
    }

    public ClueScroll getClue() {
        return this.clue;
    }

    public List<NPC> getNpcsToMark() {
        return this.npcsToMark;
    }

    public List<TileObject> getObjectsToMark() {
        return this.objectsToMark;
    }

    public Item[] getEquippedItems() {
        return this.equippedItems;
    }

    public Item[] getInventoryItems() {
        return this.inventoryItems;
    }

    public Client getClient() {
        return this.client;
    }
}

