/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cluescrolls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.cluescrolls.ClueScrollPlugin;
import net.runelite.client.plugins.cluescrolls.clues.ClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.emote.ItemRequirement;
import net.runelite.client.plugins.cluescrolls.clues.emote.SingleItemRequirement;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class ClueScrollOverlay
extends Overlay {
    private static final ItemRequirement HAS_SPADE = new SingleItemRequirement(952);
    public static final Color TITLED_CONTENT_COLOR = new Color(190, 190, 190);
    private final ClueScrollPlugin plugin;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private ClueScrollOverlay(ClueScrollPlugin plugin) {
        super(plugin);
        this.plugin = plugin;
        this.setPriority(OverlayPriority.LOW);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Clue Scroll overlay"));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        ClueScroll clue = this.plugin.getClue();
        if (clue == null) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        this.panelComponent.setPreferredSize(new Dimension(129, 0));
        clue.makeOverlayHint(this.panelComponent, this.plugin);
        if (clue.isRequiresSpade() && this.plugin.getInventoryItems() != null && !HAS_SPADE.fulfilledBy(this.plugin.getInventoryItems())) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("").build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Requires Spade!").leftColor(Color.RED).build());
        }
        return this.panelComponent.render(graphics);
    }
}

