/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.clanchat;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.ChatLineBuffer;
import net.runelite.api.ChatMessageType;
import net.runelite.api.ClanMember;
import net.runelite.api.ClanMemberRank;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MessageNode;
import net.runelite.api.Player;
import net.runelite.api.VarClientStr;
import net.runelite.api.Varbits;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClanChanged;
import net.runelite.api.events.ClanMemberJoined;
import net.runelite.api.events.ClanMemberLeft;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.api.events.VarClientStrChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ClanManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.clanchat.ClanActivityType;
import net.runelite.client.plugins.clanchat.ClanChatConfig;
import net.runelite.client.plugins.clanchat.ClanChatIndicator;
import net.runelite.client.plugins.clanchat.ClanJoinMessage;
import net.runelite.client.plugins.clanchat.ClanMemberActivity;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Clan Chat", description="Add rank icons to users talking in clan chat", tags={"icons", "rank", "recent"})
public class ClanChatPlugin
extends Plugin {
    private static final int MAX_CHATS = 10;
    private static final String CLAN_CHAT_TITLE = "CC";
    private static final String RECENT_TITLE = "Recent CCs";
    private static final int JOIN_LEAVE_DURATION = 20;
    private static final int MESSAGE_DELAY = 10;
    @Inject
    private Client client;
    @Inject
    private ClanManager clanManager;
    @Inject
    private ClanChatConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ClientThread clientThread;
    private List<String> chats = new ArrayList<String>();
    private List<Player> clanMembers = new ArrayList<Player>();
    private ClanChatIndicator clanMemberCounter;
    private final Deque<ClanJoinMessage> clanJoinMessages = new ArrayDeque<ClanJoinMessage>();
    private Map<String, ClanMemberActivity> activityBuffer = new HashMap<String, ClanMemberActivity>();
    private int clanJoinedTick;

    @Provides
    ClanChatConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(ClanChatConfig.class);
    }

    @Override
    public void startUp() {
        this.chats = new ArrayList<String>(Text.fromCSV(this.config.chatsData()));
    }

    @Override
    public void shutDown() {
        this.clanMembers.clear();
        this.removeClanCounter();
        this.resetClanChats();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("clanchat")) {
            if (!this.config.recentChats()) {
                this.resetClanChats();
            }
            if (this.config.showClanCounter()) {
                this.clientThread.invoke(this::addClanCounter);
            } else {
                this.removeClanCounter();
            }
        }
    }

    @Subscribe
    public void onClanMemberJoined(ClanMemberJoined event) {
        ClanMember member = event.getMember();
        if (member.getWorld() == this.client.getWorld()) {
            Player local = this.client.getLocalPlayer();
            String memberName = Text.toJagexName(member.getUsername());
            for (Player player : this.client.getPlayers()) {
                if (player == null || player == local || !memberName.equals(Text.toJagexName(player.getName()))) continue;
                this.clanMembers.add(player);
                this.addClanCounter();
                break;
            }
        }
        if (this.clanJoinedTick == this.client.getTickCount()) {
            return;
        }
        if (!this.config.showJoinLeave() || member.getRank().getValue() < this.config.joinLeaveRank().getValue()) {
            return;
        }
        if (!this.activityBuffer.containsKey(member.getUsername())) {
            ClanMemberActivity joinActivity = new ClanMemberActivity(ClanActivityType.JOINED, member, this.client.getTickCount());
            this.activityBuffer.put(member.getUsername(), joinActivity);
        } else {
            this.activityBuffer.remove(member.getUsername());
        }
    }

    @Subscribe
    public void onClanMemberLeft(ClanMemberLeft event) {
        ClanMember member = event.getMember();
        if (member.getWorld() == this.client.getWorld()) {
            String memberName = Text.toJagexName(member.getUsername());
            Iterator<Player> each = this.clanMembers.iterator();
            while (each.hasNext()) {
                if (!memberName.equals(Text.toJagexName(each.next().getName()))) continue;
                each.remove();
                if (!this.clanMembers.isEmpty()) break;
                this.removeClanCounter();
                break;
            }
        }
        if (!this.config.showJoinLeave() || member.getRank().getValue() < this.config.joinLeaveRank().getValue()) {
            return;
        }
        if (!this.activityBuffer.containsKey(member.getUsername())) {
            ClanMemberActivity leaveActivity = new ClanMemberActivity(ClanActivityType.LEFT, member, this.client.getTickCount());
            this.activityBuffer.put(member.getUsername(), leaveActivity);
        } else {
            this.activityBuffer.remove(member.getUsername());
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        Widget clanChatTitleWidget = this.client.getWidget(WidgetInfo.CLAN_CHAT_TITLE);
        if (clanChatTitleWidget != null) {
            Widget clanChatList = this.client.getWidget(WidgetInfo.CLAN_CHAT_LIST);
            Widget owner = this.client.getWidget(WidgetInfo.CLAN_CHAT_OWNER);
            if (this.client.getClanChatCount() > 0) {
                clanChatTitleWidget.setText("CC (" + this.client.getClanChatCount() + "/2000)");
            } else if (this.config.recentChats() && clanChatList.getChildren() == null && !Strings.isNullOrEmpty(owner.getText())) {
                clanChatTitleWidget.setText(RECENT_TITLE);
                this.loadClanChats();
            }
        }
        if (!this.config.showJoinLeave()) {
            return;
        }
        this.timeoutClanMessages();
        this.addClanActivityMessages();
    }

    private void timeoutClanMessages() {
        if (this.clanJoinMessages.isEmpty()) {
            return;
        }
        boolean removed = false;
        Iterator<ClanJoinMessage> it = this.clanJoinMessages.iterator();
        while (it.hasNext()) {
            ChatLineBuffer ccInfoBuffer;
            ClanJoinMessage clanJoinMessage = it.next();
            MessageNode messageNode = clanJoinMessage.getMessageNode();
            int createdTick = clanJoinMessage.getTick();
            if (this.client.getTickCount() <= createdTick + 20) break;
            it.remove();
            if (clanJoinMessage.getGetMessageId() != messageNode.getId() || (ccInfoBuffer = this.client.getChatLineMap().get(ChatMessageType.FRIENDSCHATNOTIFICATION.getType())) == null) continue;
            ccInfoBuffer.removeMessageNode(messageNode);
            removed = true;
        }
        if (removed) {
            this.clientThread.invoke(() -> this.client.runScript(216, new Object[0]));
        }
    }

    private void addClanActivityMessages() {
        Iterator<ClanMemberActivity> activityIt = this.activityBuffer.values().iterator();
        while (activityIt.hasNext()) {
            ClanMemberActivity activity = activityIt.next();
            if (activity.getTick() >= this.client.getTickCount() - 10) continue;
            activityIt.remove();
            this.addActivityMessage(activity.getMember(), activity.getActivityType());
        }
    }

    private void addActivityMessage(ClanMember member, ClanActivityType activityType) {
        String activityMessage = activityType == ClanActivityType.JOINED ? " has joined." : " has left.";
        ClanMemberRank rank = member.getRank();
        Color textColor = JagexColors.CHAT_CLAN_TEXT_OPAQUE_BACKGROUND;
        Color channelColor = JagexColors.CHAT_CLAN_NAME_OPAQUE_BACKGROUND;
        int rankIcon = -1;
        if (this.client.isResized() && this.client.getVar(Varbits.TRANSPARENT_CHATBOX) == 1) {
            textColor = JagexColors.CHAT_CLAN_TEXT_TRANSPARENT_BACKGROUND;
            channelColor = JagexColors.CHAT_CLAN_NAME_TRANSPARENT_BACKGROUND;
        }
        if (this.config.clanChatIcons() && rank != null && rank != ClanMemberRank.UNRANKED) {
            rankIcon = this.clanManager.getIconNumber(rank);
        }
        ChatMessageBuilder message = new ChatMessageBuilder().append("[").append(channelColor, this.client.getClanChatName());
        if (rankIcon > -1) {
            message.append(" ").img(rankIcon);
        }
        message.append("] ").append(textColor, member.getUsername() + activityMessage);
        String messageString = message.build();
        this.client.addChatMessage(ChatMessageType.FRIENDSCHATNOTIFICATION, "", messageString, "");
        ChatLineBuffer chatLineBuffer = this.client.getChatLineMap().get(ChatMessageType.FRIENDSCHATNOTIFICATION.getType());
        MessageNode[] lines = chatLineBuffer.getLines();
        MessageNode line = lines[0];
        ClanJoinMessage clanJoinMessage = new ClanJoinMessage(line, line.getId(), this.client.getTickCount());
        this.clanJoinMessages.addLast(clanJoinMessage);
    }

    @Subscribe
    public void onVarClientStrChanged(VarClientStrChanged strChanged) {
        if (strChanged.getIndex() == VarClientStr.RECENT_CLAN_CHAT.getIndex() && this.config.recentChats()) {
            this.updateRecentChat(this.client.getVar(VarClientStr.RECENT_CLAN_CHAT));
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (this.client.getGameState() != GameState.LOADING && this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.client.getClanChatCount() <= 0) {
            return;
        }
        switch (chatMessage.getType()) {
            case PRIVATECHAT: 
            case MODPRIVATECHAT: {
                if (this.config.privateMessageIcons()) break;
                return;
            }
            case PUBLICCHAT: 
            case MODCHAT: {
                if (this.config.publicChatIcons()) break;
                return;
            }
            case FRIENDSCHAT: {
                if (this.config.clanChatIcons()) break;
                return;
            }
            default: {
                return;
            }
        }
        this.insertClanRankIcon(chatMessage);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged state) {
        GameState gameState = state.getGameState();
        if (gameState == GameState.LOGIN_SCREEN || gameState == GameState.CONNECTION_LOST || gameState == GameState.HOPPING) {
            this.clanMembers.clear();
            this.removeClanCounter();
            this.clanJoinMessages.clear();
        }
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned event) {
        Player local = this.client.getLocalPlayer();
        Player player = event.getPlayer();
        if (player != local && player.isClanMember()) {
            this.clanMembers.add(player);
            this.addClanCounter();
        }
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned event) {
        if (this.clanMembers.remove(event.getPlayer()) && this.clanMembers.isEmpty()) {
            this.removeClanCounter();
        }
    }

    @Subscribe
    public void onClanChanged(ClanChanged event) {
        if (event.isJoined()) {
            this.clanJoinedTick = this.client.getTickCount();
        } else {
            this.clanMembers.clear();
            this.removeClanCounter();
        }
        this.activityBuffer.clear();
    }

    int getClanAmount() {
        return this.clanMembers.size();
    }

    private void insertClanRankIcon(ChatMessage message) {
        ClanMemberRank rank = this.clanManager.getRank(message.getName());
        if (rank != null && rank != ClanMemberRank.UNRANKED) {
            int iconNumber = this.clanManager.getIconNumber(rank);
            String img = "<img=" + iconNumber + ">";
            if (message.getType() == ChatMessageType.FRIENDSCHAT) {
                message.getMessageNode().setSender(message.getMessageNode().getSender() + " " + img);
            } else {
                message.getMessageNode().setName(img + message.getMessageNode().getName());
            }
            this.client.refreshChat();
        }
    }

    private void resetClanChats() {
        Widget clanChatList = this.client.getWidget(WidgetInfo.CLAN_CHAT_LIST);
        Widget clanChatTitleWidget = this.client.getWidget(WidgetInfo.CLAN_CHAT_TITLE);
        if (clanChatList == null) {
            return;
        }
        if (this.client.getClanChatCount() == 0) {
            clanChatList.setChildren(null);
        }
        clanChatTitleWidget.setText(CLAN_CHAT_TITLE);
    }

    private void loadClanChats() {
        Widget clanChatList = this.client.getWidget(WidgetInfo.CLAN_CHAT_LIST);
        if (clanChatList == null) {
            return;
        }
        int y = 2;
        clanChatList.setChildren(null);
        for (String chat : Lists.reverse(this.chats)) {
            Widget widget = clanChatList.createChild(-1, 4);
            widget.setFontId(494);
            widget.setTextColor(0xFFFFFF);
            widget.setText(chat);
            widget.setOriginalHeight(14);
            widget.setOriginalWidth(142);
            widget.setOriginalY(y);
            widget.setOriginalX(20);
            widget.revalidate();
            y += 14;
        }
    }

    private void updateRecentChat(String s) {
        if (Strings.isNullOrEmpty(s)) {
            return;
        }
        s = Text.toJagexName(s);
        this.chats.removeIf(s::equalsIgnoreCase);
        this.chats.add(s);
        while (this.chats.size() > 10) {
            this.chats.remove(0);
        }
        this.config.chatsData(Text.toCSV(this.chats));
    }

    private void removeClanCounter() {
        this.infoBoxManager.removeInfoBox(this.clanMemberCounter);
        this.clanMemberCounter = null;
    }

    private void addClanCounter() {
        if (!this.config.showClanCounter() || this.clanMemberCounter != null || this.clanMembers.isEmpty()) {
            return;
        }
        BufferedImage image = this.spriteManager.getSprite(904, 0);
        this.clanMemberCounter = new ClanChatIndicator(image, this);
        this.infoBoxManager.addInfoBox(this.clanMemberCounter);
    }
}

