/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.chatnotifications;

import com.google.common.base.Strings;
import com.google.inject.Provides;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MessageNode;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.Notifier;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.chatnotifications.ChatNotificationsConfig;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Chat Notifications", description="Highlight and notify you of chat messages", tags={"duel", "messages", "notifications", "trade", "username"}, enabledByDefault=false)
public class ChatNotificationsPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ChatNotificationsConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private Notifier notifier;
    @Inject
    private RuneLiteProperties runeLiteProperties;
    private Pattern usernameMatcher = null;
    private String usernameReplacer = "";
    private Pattern highlightMatcher = null;

    @Provides
    ChatNotificationsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(ChatNotificationsConfig.class);
    }

    @Override
    public void startUp() {
        this.updateHighlights();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGIN_SCREEN: 
            case HOPPING: {
                this.usernameMatcher = null;
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("chatnotification")) {
            this.updateHighlights();
        }
    }

    private void updateHighlights() {
        this.highlightMatcher = null;
        if (!this.config.highlightWordsString().trim().equals("")) {
            List<String> items = Text.fromCSV(this.config.highlightWordsString());
            String joined = items.stream().map(Pattern::quote).collect(Collectors.joining("|"));
            this.highlightMatcher = Pattern.compile("\\b(" + joined + ")\\b", 2);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        Matcher matcher;
        MessageNode messageNode = chatMessage.getMessageNode();
        String nodeValue = Text.removeTags(messageNode.getValue());
        boolean update = false;
        switch (chatMessage.getType()) {
            case TRADEREQ: {
                if (!chatMessage.getMessage().contains("wishes to trade with you.") || !this.config.notifyOnTrade()) break;
                this.notifier.notify(chatMessage.getMessage());
                break;
            }
            case CHALREQ_TRADE: {
                if (!chatMessage.getMessage().contains("wishes to duel with you.") || !this.config.notifyOnDuel()) break;
                this.notifier.notify(chatMessage.getMessage());
                break;
            }
            case CONSOLE: {
                if (!chatMessage.getName().equals(this.runeLiteProperties.getTitle())) break;
                return;
            }
        }
        if (this.usernameMatcher == null && this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getName() != null) {
            String username = this.client.getLocalPlayer().getName();
            this.usernameMatcher = Pattern.compile("\\b(" + Pattern.quote(username) + ")\\b", 2);
            this.usernameReplacer = "<col" + ChatColorType.HIGHLIGHT.name() + "><u>" + username + "</u><col" + ChatColorType.NORMAL.name() + ">";
        }
        if (this.config.highlightOwnName() && this.usernameMatcher != null && (matcher = this.usernameMatcher.matcher(messageNode.getValue())).find()) {
            messageNode.setValue(matcher.replaceAll(this.usernameReplacer));
            update = true;
            if (this.config.notifyOnOwnName()) {
                this.sendNotification(chatMessage);
            }
        }
        if (this.highlightMatcher != null) {
            matcher = this.highlightMatcher.matcher(nodeValue);
            boolean found = false;
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String value = matcher.group();
                matcher.appendReplacement(stringBuffer, "<col" + ChatColorType.HIGHLIGHT + ">" + value + "<col" + ChatColorType.NORMAL + ">");
                update = true;
                found = true;
            }
            if (found) {
                matcher.appendTail(stringBuffer);
                messageNode.setValue(stringBuffer.toString());
                if (this.config.notifyOnHighlight()) {
                    this.sendNotification(chatMessage);
                }
            }
        }
        if (update) {
            messageNode.setRuneLiteFormatMessage(messageNode.getValue());
            this.chatMessageManager.update(messageNode);
        }
    }

    private void sendNotification(ChatMessage message) {
        String name = Text.removeTags(message.getName());
        String sender = message.getSender();
        StringBuilder stringBuilder = new StringBuilder();
        if (!Strings.isNullOrEmpty(sender)) {
            stringBuilder.append('[').append(sender).append("] ");
        }
        if (!Strings.isNullOrEmpty(name)) {
            stringBuilder.append(name).append(": ");
        }
        stringBuilder.append(Text.removeTags(message.getMessage()));
        String notification = stringBuilder.toString();
        this.notifier.notify(notification);
    }
}

