/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.chaticons;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.chaticons.ChatIconsConfig;

@PluginDescriptor(name="Chat Icons", description="Manages chat icon settings")
public class ChatIconsPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ChatIconsConfig config;

    @Provides
    ChatIconsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(ChatIconsConfig.class);
    }

    @Subscribe
    public void onChatMessage(ChatMessage message) {
        String name = message.getName();
        if (name == null) {
            return;
        }
        if (this.config.hideMemberIcons() && name.contains("<member=")) {
            name = name.replaceAll("<member=([0-9]|10)>", "");
        }
        if (!this.config.displayAllIcons()) {
            name = name.replaceAll("<irm=([0-9]|10)>", "");
        }
        message.getMessageNode().setName(name);
        this.client.refreshChat();
    }
}

