/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.chathistory;

import com.google.common.collect.EvictingQueue;
import com.google.inject.Provides;
import java.awt.event.KeyEvent;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Queue;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.VarClientInt;
import net.runelite.api.VarClientStr;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.vars.InputType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.chathistory.ChatHistoryConfig;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Chat History", description="Retain your chat history when logging in/out or world hopping", tags={"chat", "history", "retain", "cycle", "pm"})
public class ChatHistoryPlugin
extends Plugin
implements KeyListener {
    private static final String WELCOME_MESSAGE = "Welcome to Zenyte.";
    private static final String CLEAR_HISTORY = "Clear history";
    private static final String CLEAR_PRIVATE = "<col=ffff00>Private:";
    private static final int CYCLE_HOTKEY = 9;
    private static final int FRIENDS_MAX_SIZE = 5;
    private Queue<QueuedMessage> messageQueue;
    private Deque<String> friends;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatHistoryConfig config;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ChatMessageManager chatMessageManager;

    @Provides
    ChatHistoryConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(ChatHistoryConfig.class);
    }

    @Override
    protected void startUp() {
        this.messageQueue = EvictingQueue.create(100);
        this.friends = new ArrayDeque<String>(6);
        this.keyManager.registerKeyListener(this);
    }

    @Override
    protected void shutDown() {
        this.messageQueue.clear();
        this.messageQueue = null;
        this.friends.clear();
        this.friends = null;
        this.keyManager.unregisterKeyListener(this);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getMessage().equals(WELCOME_MESSAGE)) {
            QueuedMessage queuedMessage;
            if (!this.config.retainChatHistory()) {
                return;
            }
            while ((queuedMessage = this.messageQueue.poll()) != null) {
                this.chatMessageManager.queue(queuedMessage);
            }
            return;
        }
        switch (chatMessage.getType()) {
            case PRIVATECHATOUT: 
            case PRIVATECHAT: 
            case MODPRIVATECHAT: {
                String name = Text.removeTags(chatMessage.getName());
                if (!this.friends.remove(name) && this.friends.size() >= 5) {
                    this.friends.remove();
                }
                this.friends.add(name);
            }
            case PUBLICCHAT: 
            case MODCHAT: 
            case FRIENDSCHAT: 
            case CONSOLE: {
                QueuedMessage queuedMessage = QueuedMessage.builder().type(chatMessage.getType()).name(chatMessage.getName()).sender(chatMessage.getSender()).value(ChatHistoryPlugin.nbsp(chatMessage.getMessage())).runeLiteFormattedMessage(ChatHistoryPlugin.nbsp(chatMessage.getMessageNode().getRuneLiteFormatMessage())).timestamp(chatMessage.getTimestamp()).build();
                if (this.messageQueue.contains(queuedMessage)) break;
                this.messageQueue.offer(queuedMessage);
            }
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        String menuOption = event.getMenuOption();
        if (menuOption.contains(CLEAR_HISTORY)) {
            if (menuOption.startsWith(CLEAR_PRIVATE)) {
                this.messageQueue.removeIf(e -> e.getType() == ChatMessageType.PRIVATECHAT || e.getType() == ChatMessageType.PRIVATECHATOUT || e.getType() == ChatMessageType.MODPRIVATECHAT);
                this.friends.clear();
            } else {
                this.messageQueue.removeIf(e -> e.getType() == ChatMessageType.PUBLICCHAT || e.getType() == ChatMessageType.MODCHAT);
            }
        }
    }

    private static String nbsp(String message) {
        if (message != null) {
            return message.replace(' ', '\u00a0');
        }
        return null;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() != 9 || !this.config.pmTargetCycling()) {
            return;
        }
        if (this.client.getVar(VarClientInt.INPUT_TYPE) != InputType.PRIVATE_MESSAGE.getType()) {
            return;
        }
        this.clientThread.invoke(() -> {
            String target = this.findPreviousFriend();
            if (target == null) {
                return;
            }
            String currentMessage = this.client.getVar(VarClientStr.INPUT_TEXT);
            this.client.runScript(107, target);
            this.client.setVar(VarClientStr.INPUT_TEXT, currentMessage);
            this.client.runScript(222, "");
        });
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private String findPreviousFriend() {
        String currentTarget = this.client.getVar(VarClientStr.PRIVATE_MESSAGE_TARGET);
        if (currentTarget == null || this.friends.isEmpty()) {
            return null;
        }
        Iterator<String> it = this.friends.descendingIterator();
        while (it.hasNext()) {
            String friend = it.next();
            if (!friend.equals(currentTarget)) continue;
            return it.hasNext() ? it.next() : this.friends.getLast();
        }
        return this.friends.getLast();
    }
}

