/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.chatfilter;

import com.google.common.base.Splitter;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.chatfilter.ChatFilterConfig;
import net.runelite.client.plugins.chatfilter.JagexPrintableCharMatcher;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;

@PluginDescriptor(name="Chat Filter", description="Censor user configurable words or patterns from chat", enabledByDefault=false)
public class ChatFilterPlugin
extends Plugin {
    private static final Splitter NEWLINE_SPLITTER = Splitter.on("\n").omitEmptyStrings().trimResults();
    private static final String CENSOR_MESSAGE = "Hey, everyone, I just tried to say something very silly!";
    private final JagexPrintableCharMatcher jagexPrintableCharMatcher = new JagexPrintableCharMatcher();
    private final List<Pattern> filteredPatterns = new ArrayList<Pattern>();
    @Inject
    private Client client;
    @Inject
    private ChatFilterConfig config;

    @Provides
    ChatFilterConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(ChatFilterConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.updateFilteredPatterns();
    }

    @Override
    protected void shutDown() throws Exception {
        this.filteredPatterns.clear();
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!"chatFilterCheck".equals(event.getEventName())) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        int intStackSize = this.client.getIntStackSize();
        ChatMessageType chatMessageType = ChatMessageType.of(intStack[intStackSize - 1]);
        switch (chatMessageType) {
            case PUBLICCHAT: 
            case MODCHAT: 
            case AUTOTYPER: 
            case PRIVATECHAT: 
            case MODPRIVATECHAT: 
            case FRIENDSCHAT: {
                break;
            }
            default: {
                return;
            }
        }
        String[] stringStack = this.client.getStringStack();
        int stringStackSize = this.client.getStringStackSize();
        String message = stringStack[stringStackSize - 1];
        String censoredMessage = this.censorMessage(message);
        if (censoredMessage == null) {
            intStack[intStackSize - 2] = 0;
        } else {
            stringStack[stringStackSize - 1] = censoredMessage;
        }
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (!(event.getActor() instanceof Player)) {
            return;
        }
        String message = this.censorMessage(event.getOverheadText());
        if (message == null) {
            message = " ";
        }
        event.getActor().setOverheadText(message);
    }

    String censorMessage(String message) {
        String strippedMessage = this.jagexPrintableCharMatcher.retainFrom(message).replace('\u00a0', ' ');
        boolean filtered = false;
        for (Pattern pattern : this.filteredPatterns) {
            Matcher m = pattern.matcher(strippedMessage);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                switch (this.config.filterType()) {
                    case CENSOR_WORDS: {
                        m.appendReplacement(sb, StringUtils.repeat("*", m.group(0).length()));
                        filtered = true;
                        break;
                    }
                    case CENSOR_MESSAGE: {
                        return CENSOR_MESSAGE;
                    }
                    case REMOVE_MESSAGE: {
                        return null;
                    }
                }
            }
            m.appendTail(sb);
            strippedMessage = sb.toString();
        }
        return filtered ? strippedMessage : message;
    }

    void updateFilteredPatterns() {
        this.filteredPatterns.clear();
        Text.fromCSV(this.config.filteredWords()).stream().map(s -> Pattern.compile(Pattern.quote(s), 2)).forEach(this.filteredPatterns::add);
        NEWLINE_SPLITTER.splitToList(this.config.filteredRegex()).stream().map(s -> {
            try {
                return Pattern.compile(s, 2);
            }
            catch (PatternSyntaxException ex) {
                return null;
            }
        }).filter(Objects::nonNull).forEach(this.filteredPatterns::add);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"chatfilter".equals(event.getGroup())) {
            return;
        }
        this.updateFilteredPatterns();
    }
}

