/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.chatcommands;

import java.awt.event.KeyEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.VarClientStr;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.input.KeyListener;
import net.runelite.client.plugins.chatcommands.ChatCommandsConfig;

@Singleton
public class ChatKeyboardListener
implements KeyListener {
    @Inject
    private ChatCommandsConfig chatCommandsConfig;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!e.isControlDown() || !this.chatCommandsConfig.clearShortcuts()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 87: {
                String input = this.client.getVar(VarClientStr.CHATBOX_TYPED_TEXT);
                if (input == null) break;
                while (input.endsWith(" ")) {
                    input = input.substring(0, input.length() - 1);
                }
                int idx = input.lastIndexOf(32);
                String replacement = idx != -1 ? input.substring(0, idx) : "";
                this.clientThread.invoke(() -> {
                    this.client.setVar(VarClientStr.CHATBOX_TYPED_TEXT, replacement);
                    this.client.runScript(223, new Object[0]);
                });
                break;
            }
            case 8: {
                this.clientThread.invoke(() -> {
                    this.client.setVar(VarClientStr.CHATBOX_TYPED_TEXT, "");
                    this.client.runScript(223, new Object[0]);
                });
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

